/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.StringUtil;

public class PathUtil {
    public static String concat(String path1, String path2, char sep) {
        if (StringUtil.isEmpty(path1)) {
            return path2;
        }
        if (StringUtil.isEmpty(path2)) {
            return path1;
        }
        StringBuilder b = new StringBuilder();
        if (path1.charAt(path1.length() - 1) == sep) {
            b.append(path1, 0, path1.length() - 1);
        } else {
            b.append(path1);
        }
        b.append(sep);
        if (path2.charAt(0) == sep) {
            b.append(path2, 1, path2.length());
        } else {
            b.append(path2);
        }
        return b.toString();
    }

    public static String concatPath(String path1, String path2, char sep) {
        StringBuilder b = new StringBuilder();
        if (StringUtil.isNotEmpty(path1)) {
            if (path1.charAt(0) != sep) {
                b.append(sep);
            }
            if (path1.charAt(path1.length() - 1) == sep) {
                b.append(path1, 0, path1.length() - 1);
            } else {
                b.append(path1);
            }
        }
        if (StringUtil.isNotEmpty(path2)) {
            if (path2.charAt(0) != sep) {
                b.append(sep);
            }
            if (path2.charAt(path2.length() - 1) == sep) {
                b.append(path2, 0, path2.length() - 1);
            } else {
                b.append(path2);
            }
        }
        return b.toString();
    }

    public static String concatParts(String path1, String path2, char sep) {
        StringBuilder b = new StringBuilder();
        if (path1.charAt(path1.length() - 1) == sep) {
            b.append(path1, 0, path1.length() - 1);
        } else {
            b.append(path1);
        }
        if (path2.charAt(0) != sep) {
            b.append(sep);
        }
        if (path2.charAt(path2.length() - 1) == sep) {
            b.append(path2, 0, path2.length() - 1);
        } else {
            b.append(path2);
        }
        return b.toString();
    }

    public static String normalizePath(String path, char sep) {
        boolean needRemoveTrailingSlash;
        boolean needLeadingSlash = path.charAt(0) != sep;
        boolean bl = needRemoveTrailingSlash = path.charAt(path.length() - 1) == sep;
        if (needLeadingSlash || needRemoveTrailingSlash) {
            if (needLeadingSlash && needRemoveTrailingSlash) {
                StringBuilder b = new StringBuilder();
                b.append(sep);
                b.append(path, 0, path.length() - 1);
                return b.toString();
            }
            if (needLeadingSlash) {
                StringBuilder b = new StringBuilder();
                b.append(sep);
                b.append(path);
                return b.toString();
            }
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String surroundPath(String path, char sep) {
        boolean needTrailingSlash;
        boolean needLeadingSlash = path.charAt(0) != sep;
        boolean bl = needTrailingSlash = path.charAt(path.length() - 1) != sep;
        if (needLeadingSlash || needTrailingSlash) {
            if (needLeadingSlash && needTrailingSlash) {
                StringBuilder b = new StringBuilder();
                b.append(sep);
                b.append(path);
                b.append(sep);
                return b.toString();
            }
            if (needLeadingSlash) {
                StringBuilder b = new StringBuilder();
                b.append(sep);
                b.append(path);
                return b.toString();
            }
            StringBuilder b = new StringBuilder();
            b.append(path);
            b.append(sep);
            return b.toString();
        }
        return path;
    }
}

