/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

public abstract class ObjectPool {
    private Object[] data;
    private int count = 0;

    public ObjectPool(int poolSize) {
        this.data = new Object[poolSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get() throws Exception {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.count == 0) {
                Object object = this.createObject();
                return object;
            }
            return this.data[--this.count];
        }
    }

    public synchronized void recycle(Object object) {
        if (this.count < this.data.length) {
            this.data[this.count++] = object;
        }
    }

    protected abstract Object createObject() throws Exception;
}

