/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.io.ByteStreamCache;
import com.ibm.commons.util.io.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;

public class JarPackager {
    private JarOutputStream jarOS = null;
    private File file = null;
    private boolean bTempFile = false;
    private HashSet<String> entriesSet;

    public JarPackager(File file, Manifest mf) throws IOException {
        this.file = file;
        this.jarOS = mf != null ? new JarOutputStream((OutputStream)new FileOutputStream(file), mf) : new JarOutputStream(new FileOutputStream(file));
        this.entriesSet = new HashSet();
    }

    public JarPackager(File file) throws IOException {
        this(file, null);
    }

    public JarPackager(String filePath) throws IOException {
        this(filePath, null);
    }

    public JarPackager(String filePath, Manifest mf) throws IOException {
        this(new File(filePath), mf);
    }

    public JarPackager() throws IOException {
        this(File.createTempFile("designer", "jar"));
        this.bTempFile = true;
    }

    public void close() throws IOException {
        if (this.jarOS != null) {
            try {
                this.jarOS.close();
                if (this.bTempFile && this.file != null) {
                    this.file.delete();
                    this.file = null;
                }
                if (this.file != null) {
                    this.postFinishJar(this.file);
                }
            }
            finally {
                this.jarOS = null;
            }
        }
    }

    protected void postFinishJar(File file) {
    }

    public void addContents(String entryName, InputStream is) throws IOException {
        this.ensureOpen();
        if (this.entriesSet.contains(entryName)) {
            return;
        }
        JarEntry entry = new JarEntry(entryName);
        entry.setMethod(8);
        CRC32 checksumCalculator = new CRC32();
        ByteStreamCache bsc = new ByteStreamCache();
        entry.setSize(StreamUtil.copyStream(is, bsc.getOutputStream()));
        checksumCalculator.update(bsc.toByteArray());
        entry.setCrc(checksumCalculator.getValue());
        this.jarOS.putNextEntry(entry);
        StreamUtil.copyStream(bsc.getInputStream(), this.jarOS);
        this.entriesSet.add(entryName);
    }

    private void ensureOpen() {
        if (this.jarOS == null) {
            throw new IllegalStateException();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.jarOS != null && this.file != null) {
            if (this.hasEntries()) {
                this.jarOS.finish();
            }
            this.postFinishJar(this.file);
            return new FileInputStream(this.file);
        }
        return null;
    }

    public boolean hasEntries() {
        return !this.entriesSet.isEmpty();
    }

    public void addContents(File tempDir) throws IOException {
        if (tempDir.isDirectory()) {
            String baseDir = tempDir.getAbsolutePath();
            this.internal_addContents(tempDir, baseDir);
        }
    }

    private void internal_addContents(File file, String baseDir) throws IOException {
        if (file.isFile()) {
            FileInputStream is = null;
            try {
                String entryName = file.getAbsolutePath();
                entryName = entryName.substring(entryName.indexOf(baseDir) + baseDir.length() + 1);
                entryName = entryName.replace('\\', '/');
                is = new FileInputStream(file);
                this.addContents(entryName, is);
            }
            catch (Throwable throwable) {
                StreamUtil.close(is);
                throw throwable;
            }
            StreamUtil.close(is);
        } else {
            File[] childs = file.listFiles();
            if (childs != null) {
                int i = 0;
                while (i < childs.length) {
                    this.internal_addContents(childs[i], baseDir);
                    ++i;
                }
            }
        }
    }
}

