/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.FastStringBuffer;
import com.ibm.commons.util.StringUtil;

public final class HtmlTextUtil {
    private static String[] htmlEntities = null;

    static {
        String[] entities = new String[256];
        entities[32] = "nbsp";
        entities[34] = "quot";
        entities[38] = "amp";
        entities[60] = "lt";
        entities[62] = "gt";
        entities[160] = "nbsp";
        entities[161] = "iexcl";
        entities[162] = "cent";
        entities[163] = "pound";
        entities[164] = "curren";
        entities[165] = "yen";
        entities[166] = "brvbar";
        entities[167] = "sect";
        entities[168] = "uml";
        entities[169] = "copy";
        entities[170] = "ordf";
        entities[171] = "laquo";
        entities[172] = "not";
        entities[173] = "shy";
        entities[174] = "reg";
        entities[175] = "macr";
        entities[176] = "deg";
        entities[177] = "plusmn";
        entities[178] = "sup2";
        entities[179] = "sup3";
        entities[180] = "acute";
        entities[181] = "micro";
        entities[182] = "para";
        entities[183] = "middot";
        entities[184] = "cedil";
        entities[185] = "sup1";
        entities[186] = "ordm";
        entities[187] = "raquo";
        entities[188] = "frac14";
        entities[189] = "frac12";
        entities[190] = "frac34";
        entities[191] = "iquest";
        entities[192] = "Agrave";
        entities[193] = "Aacute";
        entities[194] = "Acirc";
        entities[195] = "Atilde";
        entities[196] = "Auml";
        entities[197] = "Aring";
        entities[198] = "AElig";
        entities[199] = "Ccedil";
        entities[200] = "Egrave";
        entities[201] = "Eacute";
        entities[202] = "Ecirc";
        entities[203] = "Euml";
        entities[204] = "Igrave";
        entities[205] = "Iacute";
        entities[206] = "Icirc";
        entities[207] = "Iuml";
        entities[208] = "ETH";
        entities[209] = "Ntilde";
        entities[210] = "Ograve";
        entities[211] = "Oacute";
        entities[212] = "Ocirc";
        entities[213] = "Otilde";
        entities[214] = "Ouml";
        entities[215] = "times";
        entities[216] = "Oslash";
        entities[217] = "Ugrave";
        entities[218] = "Uacute";
        entities[219] = "Ucirc";
        entities[220] = "Uuml";
        entities[221] = "Yacute";
        entities[222] = "THORN";
        entities[223] = "szlig";
        entities[224] = "agrave";
        entities[225] = "aacute";
        entities[226] = "acirc";
        entities[227] = "atilde";
        entities[228] = "auml";
        entities[229] = "aring";
        entities[230] = "aelig";
        entities[231] = "ccedil";
        entities[232] = "egrave";
        entities[233] = "eacute";
        entities[234] = "ecirc";
        entities[235] = "euml";
        entities[236] = "igrave";
        entities[237] = "iacute";
        entities[238] = "icirc";
        entities[239] = "iuml";
        entities[240] = "eth";
        entities[241] = "ntilde";
        entities[242] = "ograve";
        entities[243] = "oacute";
        entities[244] = "ocirc";
        entities[245] = "otilde";
        entities[246] = "ouml";
        entities[247] = "divide";
        entities[248] = "oslash";
        entities[249] = "ugrave";
        entities[250] = "uacute";
        entities[251] = "ucirc";
        entities[252] = "uuml";
        entities[253] = "yacute";
        entities[254] = "thorn";
        entities[255] = "yuml";
        htmlEntities = entities;
    }

    public static String toHTMLContentString(String s, boolean replaceSpaces) {
        return HtmlTextUtil.toHTMLString(s, replaceSpaces);
    }

    public static String toHTMLAttributeString(String s) {
        return HtmlTextUtil.toHTMLString(s, false);
    }

    public static String getEntity(char c) {
        if (c < '\u0100') {
            return htmlEntities[c];
        }
        if (c == '\u20ac') {
            return "euro";
        }
        return null;
    }

    private static String toHTMLString(String s, boolean replaceSpaces) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        FastStringBuffer b = null;
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            String replaceLabel = null;
            String replaceNumber = null;
            if (c == ' ') {
                if (replaceSpaces) {
                    replaceLabel = htmlEntities[c];
                }
            } else if (c < '\u0100') {
                replaceLabel = htmlEntities[c];
            } else if (c == '\u20ac') {
                replaceLabel = "euro";
            } else {
                replaceNumber = Integer.toString(c);
            }
            if (replaceLabel != null || replaceNumber != null) {
                if (b == null) {
                    b = new FastStringBuffer();
                    b.append(s, 0, i);
                }
                b.append("&");
                if (replaceLabel != null) {
                    b.append(replaceLabel);
                } else {
                    b.append("#");
                    b.append(replaceNumber);
                }
                b.append(";");
            } else if (b != null) {
                b.append(c);
            }
            ++i;
        }
        return b != null ? b.toString() : s;
    }

    public static String fromHTMLInputString(String s) {
        int firstChar;
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        int l = s.length();
        FastStringBuffer b = null;
        int start = 0;
        while ((firstChar = s.indexOf("&#", start)) != -1) {
            int lastChar;
            boolean ok = false;
            for (lastChar = firstChar + 2; lastChar < l; ++lastChar) {
                char c = s.charAt(lastChar);
                if (c == ';') {
                    ok = true;
                    break;
                }
                if (c < '0' || c > '9') break;
            }
            if (ok) {
                int n = Integer.parseInt(s.substring(firstChar + 2, lastChar));
                if (b == null) {
                    b = new FastStringBuffer();
                    b.append(s, 0, firstChar);
                } else {
                    b.append(s, start, firstChar);
                }
                b.append((char)n);
                start = lastChar + 1;
                continue;
            }
            start = firstChar + 2;
        }
        if (b != null && start < l) {
            b.append(s, start, l);
        }
        return b != null ? b.toString() : s;
    }

    public static String fromHTML(String s) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        FastStringBuffer b = null;
        char[] chars = s.toCharArray();
        int length = chars.length;
        int entityStart = -1;
        int i = 0;
        while (i < length) {
            char c = chars[i];
            if (c == '&') {
                if (entityStart != -1 && b != null) {
                    b.append(s, entityStart, i);
                }
                entityStart = i;
            } else if (c == ';' && entityStart != -1) {
                int entChar;
                block29: {
                    String ent = s.substring(entityStart + 1, i);
                    entChar = -1;
                    if (!StringUtil.isEmpty(ent)) {
                        if (ent.charAt(0) == '#') {
                            boolean hexa = false;
                            if (ent.length() > 1 && (ent.charAt(1) == 'x' || ent.charAt(1) == 'X')) {
                                hexa = true;
                            }
                            boolean num = true;
                            int k = hexa ? 2 : 1;
                            while (k < ent.length()) {
                                char ch = ent.charAt(k);
                                boolean ok = false;
                                if (ch >= '0' && ch <= '9') {
                                    ok = true;
                                } else if (hexa && (ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F')) {
                                    ok = true;
                                }
                                if (!ok) {
                                    num = false;
                                    break;
                                }
                                ++k;
                            }
                            if (num) {
                                try {
                                    if (hexa) {
                                        entChar = Integer.parseInt(ent.substring(1), 16);
                                        break block29;
                                    }
                                    entChar = Integer.parseInt(ent.substring(1));
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else if (ent.equals("euro")) {
                            entChar = 8364;
                        } else {
                            int k = 0;
                            while (k < htmlEntities.length) {
                                String htmlEntity = htmlEntities[k];
                                if (htmlEntity != null && ent.equals(htmlEntity)) {
                                    entChar = k;
                                    break;
                                }
                                ++k;
                            }
                        }
                    }
                }
                if (b == null) {
                    b = new FastStringBuffer();
                    if (entityStart > 0) {
                        b.append(s, 0, entityStart);
                    }
                }
                if (entChar != -1) {
                    b.append((char)entChar);
                } else {
                    b.append(s, entityStart, i);
                }
                entityStart = -1;
            } else if (b != null && entityStart == -1) {
                b.append(c);
            }
            ++i;
        }
        return b != null ? b.toString() : s;
    }
}

