/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.DateTime;
import com.ibm.commons.util.FastStringBuffer;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.TStringArrayMatching;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class FormatUtil {
    private static final String INVALID_DATE = "Invalid date '{0}'";
    public static final String SHORT_DATE = "<date>";
    public static final String LONG_DATE = "<long date>";
    public static final String SHORT_TIME = "<time>";
    public static final String LONG_TIME = "<long time>";
    public static final String SHORT_DATETIME = "<date and time>";
    public static final String LONG_DATETIME = "<long date and time>";
    private static Map<String, String> formatCache = new HashMap<String, String>();

    public static long getInteger(String integerString) {
        if (StringUtil.isEmpty(integerString)) {
            return 0L;
        }
        return Long.parseLong(integerString);
    }

    public static long parseInt(String src, Locale loc) throws ParseException {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        NumberFormat nf = NumberFormat.getNumberInstance(loc);
        nf.setParseIntegerOnly(true);
        return nf.parse(src).longValue();
    }

    public static double getDecimal(String doubleString) {
        if (StringUtil.isEmpty(doubleString)) {
            return 0.0;
        }
        return Double.parseDouble(doubleString);
    }

    public static double parseFloatWithDecimalSeparatorTolerance(String doubleString, Locale loc) {
        doubleString = FormatUtil.removeThousandSeparator(doubleString, loc);
        doubleString = FormatUtil.replaceCommaByPoint(doubleString, loc);
        return FormatUtil.getDecimal(doubleString);
    }

    public static String replaceCommaByPoint(String doubleString, Locale loc) {
        DecimalFormatSymbols symb = new DecimalFormatSymbols(loc);
        if (symb.getDecimalSeparator() == ',' && doubleString.indexOf(44) >= 0 && doubleString.indexOf(44) == doubleString.lastIndexOf(44) && doubleString.indexOf(46) == -1) {
            return doubleString.replace(',', '.');
        }
        return doubleString;
    }

    public static String removeThousandSeparator(String doubleString, Locale loc) {
        DecimalFormatSymbols symb = new DecimalFormatSymbols(loc);
        char thoSep = symb.getGroupingSeparator();
        if (thoSep == '.') {
            return doubleString;
        }
        if (thoSep == '\u00a0') {
            thoSep = ' ';
        }
        return StringUtil.replace(doubleString, String.valueOf(thoSep), null);
    }

    public static double parseFloat(String src, Locale loc) throws ParseException {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        return NumberFormat.getInstance(loc).parse(src).floatValue();
    }

    public static String formatInteger(long l, String format, String emptyFormat) {
        return FormatUtil.formatInteger(l, format, emptyFormat, Locale.getDefault());
    }

    public static String formatInteger(long l, String format, String emptyFormat, Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if ((double)l == 0.0 && !StringUtil.isEmpty(emptyFormat)) {
            return emptyFormat;
        }
        NumberFormat fmt = null;
        fmt = !StringUtil.isEmpty(format) ? new DecimalFormat(format, new DecimalFormatSymbols(loc)) : NumberFormat.getNumberInstance(loc);
        if (fmt != null) {
            return fmt.format(l);
        }
        return Long.toString(l);
    }

    public static String formatDecimal(double d, String format, String emptyFormat) {
        return FormatUtil.formatDecimal(d, format, emptyFormat, Locale.getDefault());
    }

    public static String formatDecimal(double d, String format, String emptyFormat, Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (d == 0.0 && !StringUtil.isEmpty(emptyFormat)) {
            return emptyFormat;
        }
        NumberFormat fmt = null;
        fmt = !StringUtil.isEmpty(format) ? new DecimalFormat(format, new DecimalFormatSymbols(loc)) : NumberFormat.getNumberInstance(loc);
        if (fmt != null) {
            return fmt.format(d);
        }
        return Double.toString(d);
    }

    public static String formatDateTime(Date date, String format) {
        return FormatUtil.formatDateTime(date, format, Locale.getDefault(), TimeZone.getDefault());
    }

    public static String formatDateTime(Date date) {
        return FormatUtil.formatDateTime(date, null, Locale.getDefault(), TimeZone.getDefault());
    }

    public static String formatDateTime(Date date, Locale loc) {
        return FormatUtil.formatDateTime(date, null, loc, TimeZone.getDefault());
    }

    public static String formatDateTime(Date date, String format, Locale loc) {
        return FormatUtil.formatDateTime(date, format, loc, TimeZone.getDefault());
    }

    public static String formatDateTime(Date date, String format, Locale loc, TimeZone tz) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        if (!StringUtil.isEmpty(format)) {
            if (format.charAt(0) == '<') {
                if (format.equals(SHORT_DATE)) {
                    return FormatUtil.getShortDateFormatter(loc, TimeZone.getDefault()).format(date);
                }
                if (format.equals(LONG_DATE)) {
                    return FormatUtil.getLongDateFormatter(loc, TimeZone.getDefault()).format(date);
                }
                if (format.equals(SHORT_TIME)) {
                    return FormatUtil.getShortTimeFormatter(loc, tz).format(date);
                }
                if (format.equals(LONG_TIME)) {
                    return FormatUtil.getLongTimeFormatter(loc, tz).format(date);
                }
                if (format.equals(SHORT_DATETIME)) {
                    return FormatUtil.getShortDatetimeFormatter(loc, tz).format(date);
                }
                if (format.equals(LONG_DATETIME)) {
                    return FormatUtil.getLongDatetimeFormatter(loc, tz).format(date);
                }
            } else {
                SimpleDateFormat fmt = new SimpleDateFormat(format, loc);
                if (format != null && (format.indexOf(104) != -1 || format.indexOf(72) != -1 || format.indexOf(109) != -1 || format.indexOf(115) != -1)) {
                    fmt.setTimeZone(tz);
                }
                return fmt.format(date);
            }
        }
        return FormatUtil.getDefaultDateFormatter(loc).format(date);
    }

    private static String getSimplifiedDateFormat(String javafmt) {
        if (!StringUtil.isEmpty(javafmt)) {
            String fmt = formatCache.get(javafmt);
            if (fmt == null) {
                FastStringBuffer b = new FastStringBuffer();
                javafmt = StringUtil.replace(javafmt, "MMMM", "J");
                javafmt = StringUtil.replace(javafmt, "MMM", "j");
                char lastch = '\u0000';
                int i = 0;
                while (i < javafmt.length()) {
                    char ch = javafmt.charAt(i);
                    if (ch != lastch) {
                        switch (ch) {
                            case 'y': {
                                b.append('Y');
                                break;
                            }
                            case 'M': {
                                b.append('M');
                                break;
                            }
                            case 'J': {
                                b.append('J');
                                break;
                            }
                            case 'j': {
                                b.append('j');
                                break;
                            }
                            case 'd': {
                                b.append('D');
                                break;
                            }
                            case 'H': 
                            case 'h': {
                                b.append('H');
                                break;
                            }
                            case 'm': {
                                b.append('N');
                                break;
                            }
                            case 's': {
                                b.append('S');
                                break;
                            }
                            case 'z': {
                                b.append('Z');
                                break;
                            }
                            case '-': 
                            case '.': 
                            case '/': {
                                b.append('/');
                                break;
                            }
                            case ':': {
                                b.append(':');
                            }
                        }
                    }
                    lastch = ch;
                    ++i;
                }
                fmt = b.toString();
                formatCache.put(javafmt, fmt);
            }
            return fmt;
        }
        return "";
    }

    public static Date parseDate(String text, String format) throws ParseException {
        return FormatUtil.parseDate(text, format, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Date parseDate(String text, String format, TimeZone tz) throws ParseException {
        return FormatUtil.parseDate(text, format, tz, Locale.getDefault());
    }

    public static Date parseDate(String text, String format, Locale loc) throws ParseException {
        return FormatUtil.parseDate(text, format, TimeZone.getDefault(), loc);
    }

    public static Date parseDate(String text, String format, TimeZone tz, Locale loc) throws ParseException {
        String dt;
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (StringUtil.isEmpty(dt = text.toLowerCase().trim())) {
            return null;
        }
        String fmt = FormatUtil.getSimplifiedDateFormat(format);
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int ampm = -1;
        int pos = 0;
        boolean hasDate = false;
        boolean hasTime = false;
        int nbCharForYear = 0;
        int point = dt.indexOf(46);
        if (point != -1 && dt.charAt(point - 1) >= 'a' && dt.charAt(point - 1) <= 'z') {
            dt = String.valueOf(dt.substring(0, point)) + dt.substring(point + 1);
        }
        int fmtpos = 0;
        while (pos < dt.length()) {
            int nbChar = 0;
            char c = dt.charAt(pos++);
            ++nbChar;
            if (c >= '0' && c <= '9') {
                int num = c - 48;
                while (pos < dt.length()) {
                    c = dt.charAt(pos);
                    if (c < '0' || c > '9') break;
                    num = num * 10 + (c - 48);
                    ++pos;
                    ++nbChar;
                }
                if (fmtpos < fmt.length()) {
                    switch (fmt.charAt(fmtpos)) {
                        case 'Y': {
                            year = num;
                            hasDate = true;
                            nbCharForYear = nbChar;
                            break;
                        }
                        case 'M': {
                            month = num;
                            hasDate = true;
                            break;
                        }
                        case 'J': {
                            month = num;
                            hasDate = true;
                            break;
                        }
                        case 'j': {
                            month = num;
                            hasDate = true;
                            break;
                        }
                        case 'D': {
                            day = num;
                            hasDate = true;
                            break;
                        }
                        case 'H': {
                            hour = num;
                            hasTime = true;
                            break;
                        }
                        case 'N': {
                            minute = num;
                            hasTime = true;
                            break;
                        }
                        case 'S': {
                            second = num;
                            hasTime = true;
                        }
                    }
                    ++fmtpos;
                    continue;
                }
                throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
            }
            if (Character.isLetter(c)) {
                String ss;
                StringBuilder b = new StringBuilder();
                b.append(c);
                while (pos < dt.length()) {
                    c = dt.charAt(pos);
                    if (!Character.isLetter(c)) break;
                    b.append(c);
                    ++pos;
                }
                if ((ss = b.toString()).equals("am")) {
                    if (ampm > 0) {
                        throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
                    }
                    ampm = 1;
                    continue;
                }
                if (ss.equals("pm")) {
                    if (ampm > 0) {
                        throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
                    }
                    ampm = 2;
                    continue;
                }
                if (fmtpos < fmt.length() && (fmt.charAt(fmtpos) == 'J' || fmt.charAt(fmtpos) == 'j')) {
                    int i = FormatUtil.computeMonth(ss, loc);
                    if (i != -1) {
                        month = i;
                        ++fmtpos;
                        continue;
                    }
                    throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
                }
                if (fmtpos < fmt.length() && fmt.charAt(fmtpos) == 'Z') {
                    TStringArrayMatching strArray = new TStringArrayMatching(TimeZone.getAvailableIDs());
                    if (strArray.containsIgnoreCase(ss) == 0) {
                        tz = TimeZone.getTimeZone(strArray.getExactString(ss));
                        ++fmtpos;
                        continue;
                    }
                    throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
                }
                throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
            }
            if (c == '/' || c == '.' || c == '-') {
                if (fmtpos >= fmt.length() || fmt.charAt(fmtpos) != '/') {
                    throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
                }
                ++fmtpos;
                continue;
            }
            if (c == ':') {
                if (fmtpos >= fmt.length() || fmt.charAt(fmtpos) != ':') {
                    throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
                }
                ++fmtpos;
                continue;
            }
            if (c == ' ' || c == ',') continue;
            throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
        }
        if (hasDate) {
            if (nbCharForYear <= 2) {
                year = DateTime.convertYearIfInf100(year);
            }
            int maxDay = month == 4 || month == 6 || month == 9 || month == 11 ? 30 : (month == 2 ? (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? 29 : 28) : 31);
            if (day < 1 || day > maxDay || month < 1 || month > 12 || year <= 0) {
                throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
            }
        } else {
            year = 0;
            month = 0;
            day = 0;
        }
        if (hasTime) {
            if (ampm == 1 && hour == 12) {
                hour = 0;
            } else if (ampm == 2 && hour != 12) {
                hour += 12;
            } else if (ampm == -1 && hour == 24) {
                hour = 0;
            }
            if (second == -1) {
                second = 0;
            }
            if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second != -1 && (second < 0 || second > 59)) {
                throw new ParseException(StringUtil.format(INVALID_DATE, text), pos);
            }
        } else {
            second = 0;
            minute = 0;
            hour = 0;
        }
        if (!hasDate && hasTime) {
            year = 1970;
            month = 1;
            day = 1;
        }
        if (hasDate || hasTime) {
            if (hasTime && !tz.hasSameRules(TimeZone.getDefault())) {
                DateTime.TGregorianCalendar cal = DateTime.getCalendar();
                try {
                    cal.setTimeZone(tz);
                    cal.set(year, month - 1, day, hour, minute, second);
                    Date date = cal.getTime();
                    return date;
                }
                finally {
                    DateTime.recycleCalendar(cal);
                }
            }
            return new DateTime.DateStruct(year, month, day, hour, minute, second).createDate();
        }
        return null;
    }

    private static int computeMonth(String ss, Locale loc) {
        DateFormatSymbols sym = new DateFormatSymbols(loc);
        String[] monthsArray = sym.getMonths();
        String[] shortMonthsArray = sym.getShortMonths();
        int i = 0;
        while (i < monthsArray.length) {
            if (StringUtil.equalsIgnoreCase(monthsArray[i], ss)) {
                return i + 1;
            }
            ++i;
        }
        if (ss.endsWith(".")) {
            ss = ss.substring(0, ss.length() - 1);
        }
        i = 0;
        while (i < shortMonthsArray.length) {
            if (shortMonthsArray[i].endsWith(".")) {
                shortMonthsArray[i] = shortMonthsArray[i].substring(0, shortMonthsArray[i].length() - 1);
            }
            if (StringUtil.equalsIgnoreCase(shortMonthsArray[i], ss)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public static Date convertDateIntoServerTimeZone(Date date, TimeZone userTZ) {
        return FormatUtil.timeZoneConversion(date, userTZ, TimeZone.getDefault());
    }

    public static Date convertDateIntoUserTimeZone(Date date, TimeZone userTZ) {
        return FormatUtil.timeZoneConversion(date, TimeZone.getDefault(), userTZ);
    }

    public static Date timeZoneConversion(Date date, TimeZone source, TimeZone target) {
        if (!source.equals(target)) {
            DateTime.TGregorianCalendar calSource = DateTime.getCalendar();
            DateTime.TGregorianCalendar calTarget = DateTime.getCalendar();
            try {
                calSource.setTimeZone(source);
                calSource.setTime(date);
                int zoneOffsetSource = -calSource.get(15);
                int dstOffsetSource = -calSource.get(16);
                calTarget.setTimeZone(target);
                calTarget.setMillis(calSource.getMillis());
                int zoneOffsetTarget = calTarget.get(15);
                int dstOffsetTarget = calTarget.get(16);
                long totalOffset = (long)zoneOffsetSource + (long)dstOffsetSource + (long)zoneOffsetTarget + (long)dstOffsetTarget;
                date = new Date(date.getTime() + totalOffset);
            }
            finally {
                DateTime.recycleCalendar(calSource);
                DateTime.recycleCalendar(calTarget);
            }
        }
        return date;
    }

    public static Timestamp convertTimestampIntoServerTimeZone(Timestamp date, TimeZone userTZ) {
        return FormatUtil.timeZoneTimestampConversion(date, userTZ, TimeZone.getDefault());
    }

    public static Timestamp convertTimestampIntoUserTimeZone(Timestamp date, TimeZone userTZ) {
        return FormatUtil.timeZoneTimestampConversion(date, TimeZone.getDefault(), userTZ);
    }

    public static Timestamp timeZoneTimestampConversion(Timestamp date, TimeZone source, TimeZone target) {
        if (!source.equals(target)) {
            DateTime.TGregorianCalendar calSource = DateTime.getCalendar();
            DateTime.TGregorianCalendar calTarget = DateTime.getCalendar();
            try {
                calSource.setTimeZone(source);
                calSource.setTime(date);
                int zoneOffsetSource = -calSource.get(15);
                int dstOffsetSource = -calSource.get(16);
                calTarget.setTimeZone(target);
                calTarget.setMillis(calSource.getMillis());
                int zoneOffsetTarget = calTarget.get(15);
                int dstOffsetTarget = calTarget.get(16);
                long totalOffset = (long)zoneOffsetSource + (long)dstOffsetSource + (long)zoneOffsetTarget + (long)dstOffsetTarget;
                date = new Timestamp(date.getTime() + totalOffset);
            }
            finally {
                DateTime.recycleCalendar(calSource);
                DateTime.recycleCalendar(calTarget);
            }
        }
        return date;
    }

    public static String getFormatString(String format, Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (!StringUtil.isEmpty(format) && format.charAt(0) == '<') {
            DateFormat fmt = null;
            if (format.equals(SHORT_DATE)) {
                fmt = FormatUtil.getShortDateFormatter(loc);
            } else if (format.equals(LONG_DATE)) {
                fmt = FormatUtil.getLongDateFormatter(loc);
            } else if (format.equals(SHORT_TIME)) {
                fmt = FormatUtil.getShortTimeFormatter(loc);
            } else if (format.equals(LONG_TIME)) {
                fmt = FormatUtil.getLongTimeFormatter(loc);
            } else if (format.equals(SHORT_DATETIME)) {
                fmt = FormatUtil.getShortDatetimeFormatter(loc);
            } else if (format.equals(LONG_DATETIME)) {
                fmt = FormatUtil.getLongDatetimeFormatter(loc);
            }
            if (fmt != null && fmt instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)fmt).toPattern();
            }
        }
        return format;
    }

    public static String getFormatString(String format) {
        return FormatUtil.getFormatString(format, Locale.getDefault());
    }

    public static final DateFormat getDefaultDateFormatter() {
        return FormatUtil.getShortDateFormatter();
    }

    public static final DateFormat getShortDateFormatter() {
        return DateFormat.getDateInstance(3);
    }

    public static final DateFormat getLongDateFormatter() {
        return DateFormat.getDateInstance(1);
    }

    public static final DateFormat getDefaultDateFormatter(Locale loc) {
        return FormatUtil.getShortDateFormatter(loc);
    }

    public static final DateFormat getShortDateFormatter(Locale loc) {
        return DateFormat.getDateInstance(3, loc);
    }

    public static final DateFormat getLongDateFormatter(Locale loc) {
        return DateFormat.getDateInstance(1, loc);
    }

    public static final DateFormat getDefaultDateFormatter(Locale loc, TimeZone tz) {
        return FormatUtil.getShortDateFormatter(loc, tz);
    }

    public static final DateFormat getShortDateFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateInstance(3, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getLongDateFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateInstance(1, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getDefaultTimeFormatter() {
        return FormatUtil.getShortTimeFormatter();
    }

    public static final DateFormat getShortTimeFormatter() {
        return DateFormat.getTimeInstance(3);
    }

    public static final DateFormat getLongTimeFormatter() {
        return DateFormat.getTimeInstance(1);
    }

    public static final DateFormat getDefaultTimeFormatter(Locale loc) {
        return FormatUtil.getShortTimeFormatter(loc);
    }

    public static final DateFormat getShortTimeFormatter(Locale loc) {
        return DateFormat.getTimeInstance(3, loc);
    }

    public static final DateFormat getLongTimeFormatter(Locale loc) {
        return DateFormat.getTimeInstance(1, loc);
    }

    public static final DateFormat getDefaultTimeFormatter(Locale loc, TimeZone tz) {
        return FormatUtil.getShortTimeFormatter(loc);
    }

    public static final DateFormat getShortTimeFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getTimeInstance(3, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getLongTimeFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getTimeInstance(1, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getDefaultDatetimeFormatter() {
        return FormatUtil.getShortDatetimeFormatter();
    }

    public static final DateFormat getShortDatetimeFormatter() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public static final DateFormat getLongDatetimeFormatter() {
        return DateFormat.getDateTimeInstance(1, 1);
    }

    public static final DateFormat getDefaultDatetimeFormatter(Locale loc) {
        return FormatUtil.getShortDatetimeFormatter(loc);
    }

    public static final DateFormat getShortDatetimeFormatter(Locale loc) {
        return DateFormat.getDateTimeInstance(3, 3, loc);
    }

    public static final DateFormat getLongDatetimeFormatter(Locale loc) {
        return DateFormat.getDateTimeInstance(1, 1, loc);
    }

    public static final DateFormat getDefaultDatetimeFormatter(Locale loc, TimeZone tz) {
        return FormatUtil.getShortDatetimeFormatter(loc);
    }

    public static final DateFormat getShortDatetimeFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getLongDatetimeFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateTimeInstance(1, 1, loc);
        df.setTimeZone(tz);
        return df;
    }
}

