/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import java.util.Iterator;

public abstract class FilteredIterator<T>
implements Iterator<T> {
    private boolean initialized;
    private Iterator<T> iterator;
    private boolean hasnext;
    private T current;

    public FilteredIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    protected abstract boolean accept(Object var1);

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.next();
            this.initialized = true;
        }
        return this.hasnext;
    }

    @Override
    public T next() {
        T result = this.current;
        this.hasnext = false;
        while (!this.hasnext && this.iterator.hasNext()) {
            this.current = this.iterator.next();
            if (!this.accept(this.current)) continue;
            this.hasnext = true;
        }
        return result;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Filtered iterators cannot be used to remove an item");
    }
}

