/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class FastStringBuffer {
    private char[] value;
    private int count;
    private static final int DELTA = 128;
    private static final int ASCII_MIN = 32;
    private static final int ASCII_MAX = 126;

    public FastStringBuffer() {
        this(128);
    }

    public FastStringBuffer(int length) {
        this.value = new char[length];
        this.count = 0;
    }

    public FastStringBuffer(char[] buffer, int count) {
        if (buffer == null) {
            throw new IllegalArgumentException("Can't pass null value");
        }
        this.value = buffer;
        this.count = count < 0 ? 0 : count;
    }

    public FastStringBuffer(String str) {
        this(str.length() + 128);
        this.append(str);
    }

    public final int length() {
        return this.count;
    }

    public final int capacity() {
        return this.value.length;
    }

    private final void expandCapacity(int minimumCapacity) {
        int newCapacity = Math.max((this.value.length + 1) * 2, minimumCapacity);
        if (newCapacity - this.value.length < 128) {
            newCapacity = this.value.length + 128;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public final char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public final void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin >= this.count) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public final void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public final FastStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public final FastStringBuffer append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public final FastStringBuffer append(char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public final FastStringBuffer append(char[] str, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public final FastStringBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public final FastStringBuffer append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
        return this;
    }

    public final FastStringBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public final FastStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public final FastStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public final FastStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public final FastStringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public final FastStringBuffer insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newcount;
        return this;
    }

    public final FastStringBuffer insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newcount;
        return this;
    }

    public final FastStringBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public final FastStringBuffer insert(int offset, char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newcount;
        return this;
    }

    public final FastStringBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public final FastStringBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public final FastStringBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public final FastStringBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public final FastStringBuffer reverse() {
        int n = this.count - 1;
        int j = n - 1 >> 1;
        while (j >= 0) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
            --j;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public FastStringBuffer(String str, int srcBegin, int srcEnd) {
        this(128 + srcEnd - srcBegin);
        this.append(str, srcBegin, srcEnd);
    }

    public final void clear() {
        this.count = 0;
    }

    public boolean equals(String str) {
        if (str != null && str.length() == this.count) {
            int i = 0;
            while (i < this.count) {
                if (this.value[i] != str.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public final boolean startsWith(char c) {
        return this.count > 0 && this.value[0] == c;
    }

    public final void repeat(String toRepeat, int count) {
        int i = 0;
        while (i < count) {
            this.append(toRepeat);
            ++i;
        }
    }

    public final void repeat(char toRepeat, int count) {
        int i = 0;
        while (i < count) {
            this.append(toRepeat);
            ++i;
        }
    }

    public final FastStringBuffer append(FastStringBuffer b, int srcBegin, int srcEnd) {
        if (b == null) {
            return this;
        }
        if (srcBegin >= srcEnd) {
            return this;
        }
        int newcount = this.count + srcEnd - srcBegin;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        b.getChars(srcBegin, srcEnd, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public final FastStringBuffer append(FastStringBuffer b) {
        if (b != null) {
            this.append(b, 0, b.length());
        }
        return this;
    }

    public final FastStringBuffer append(String str, int srcBegin, int srcEnd) {
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + srcEnd - srcBegin) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(srcBegin, srcEnd, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public final FastStringBuffer load(Reader r) {
        this.clear();
        return this.append(r);
    }

    public final FastStringBuffer append(Reader r) {
        char[] b = new char[8192];
        int len = 0;
        try {
            while ((len = r.read(b)) > 0) {
                this.append(b, 0, len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return this;
    }

    public final void save(Writer w) {
        try {
            w.write(this.value, 0, this.count);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public final void flush(Writer w) throws IOException {
        w.write(this.value, 0, this.count);
    }

    public final char[] toCharArray() {
        char[] c = new char[this.count];
        System.arraycopy(this.value, 0, c, 0, this.count);
        return c;
    }

    public final String substring(int first, int last) {
        return new String(this.value, first, last - first);
    }

    public final void delete(int begin, int end) {
        if (begin < end) {
            System.arraycopy(this.value, end, this.value, begin, this.count - end);
            this.count -= end - begin;
        }
    }

    public final void replace(int begin, int end, String replace) {
        this.delete(begin, end);
        this.insert(begin, replace);
    }

    public final void replace(int begin, int end, char[] replace) {
        this.delete(begin, end);
        this.insert(begin, replace);
    }

    public final void replace(int begin, int end, FastStringBuffer replace) {
        this.delete(begin, end);
        this.insert(begin, replace.toString());
    }

    public final void replace(String oldString, String newString) {
        for (int pos = 0; pos < this.length(); pos += newString.length()) {
            if ((pos = this.indexOf(oldString, pos)) >= 0) {
                this.replace(pos, pos + oldString.length(), newString);
                continue;
            }
            return;
        }
    }

    public int indexOf(char c, int begin) {
        int i = begin;
        while (i < this.count) {
            if (this.value[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(String string, int begin) {
        int length = string.length();
        if (length > 0) {
            char fc = string.charAt(0);
            int i = begin;
            while (i <= this.count - length) {
                block5: {
                    if (this.value[i] == fc) {
                        int j = 1;
                        while (j < length) {
                            if (this.value[i + j] == string.charAt(j)) {
                                ++j;
                                continue;
                            }
                            break block5;
                        }
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int lastIndexOf(char c, int end) {
        int i = end;
        while (i >= 0) {
            if (this.value[i] == c) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.count - 1);
    }

    public char getLastChar() {
        if (this.count > 0) {
            return this.value[this.count - 1];
        }
        return '\u0000';
    }

    public final FastStringBuffer appendFormat(String fmt, Object ... args) {
        if (fmt != null) {
            int pos = 0;
            int fmtLength = fmt.length();
            int nextObject = 0;
            boolean not_valid = false;
            while (true) {
                if (not_valid) {
                    ++nextObject;
                    not_valid = false;
                }
                if ((nextObject = fmt.indexOf(123, nextObject)) < 0) {
                    nextObject = fmtLength;
                }
                if (nextObject > pos) {
                    int newcount = this.count + nextObject - pos;
                    if (newcount > this.value.length) {
                        this.expandCapacity(newcount);
                    }
                    fmt.getChars(pos, nextObject, this.value, this.count);
                    this.count = newcount;
                    pos = nextObject;
                }
                if (pos >= fmtLength) break;
                if (pos < fmtLength - 2) {
                    char c1 = fmt.charAt(pos + 1);
                    if (Character.isDigit(c1)) {
                        char c2 = fmt.charAt(pos + 2);
                        if (Character.isDigit(c2) && pos < fmtLength - 1) {
                            char c3 = fmt.charAt(pos + 3);
                            if (c3 == '}') {
                                int index = c1 - 48;
                                not_valid = this.addArg(args, index = c2 - 48 + index * 10);
                                if (not_valid) {
                                    this.append(fmt.substring(pos, pos + 4));
                                }
                                nextObject = pos += 4;
                                continue;
                            }
                            not_valid = true;
                            continue;
                        }
                        if (c2 == '}') {
                            int index = c1 - 48;
                            not_valid = this.addArg(args, index);
                            if (not_valid) {
                                this.append(fmt.substring(pos, pos + 3));
                            }
                            nextObject = pos += 3;
                            continue;
                        }
                        not_valid = true;
                        continue;
                    }
                    not_valid = true;
                    continue;
                }
                not_valid = true;
            }
            not_valid = true;
        }
        return this;
    }

    private final boolean addArg(Object[] args, int index) {
        if (index >= args.length) {
            return true;
        }
        if (args[index] != null) {
            this.append(args[index].toString());
        } else {
            this.append("null");
        }
        return false;
    }

    public final FastStringBuffer prt(String fmt, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.appendFormat(fmt, p1, p2, p3, p4, p5);
        this.append('\n');
        return this;
    }

    public final FastStringBuffer prt(String fmt, Object p1, Object p2, Object p3, Object p4) {
        return this.prt(fmt, p1, p2, p3, p4, null);
    }

    public final FastStringBuffer prt(String fmt, Object p1, Object p2, Object p3) {
        return this.prt(fmt, p1, p2, p3, null, null);
    }

    public final FastStringBuffer prt(String fmt, Object p1, Object p2) {
        return this.prt(fmt, p1, p2, null, null, null);
    }

    public final FastStringBuffer prt(String fmt, Object p1) {
        return this.prt(fmt, p1, null, null, null, null);
    }

    public final FastStringBuffer prt(String fmt) {
        return this.prt(fmt, null, null, null, null, null);
    }

    public FastStringBuffer appendJavaString(String s, boolean addQuotes) {
        if (addQuotes) {
            this.append('\"');
        }
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    this.append("\\b");
                    break;
                }
                case '\t': {
                    this.append("\\t");
                    break;
                }
                case '\n': {
                    this.append("\\n");
                    break;
                }
                case '\f': {
                    this.append("\\f");
                    break;
                }
                case '\r': {
                    this.append("\\r");
                    break;
                }
                case '\'': {
                    this.append("\\'");
                    break;
                }
                case '\"': {
                    this.append("\\\"");
                    break;
                }
                case '\\': {
                    this.append("\\\\");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.append("\\u");
                        this.append(StringUtil.toUnsignedHex(c, 4));
                        break;
                    }
                    this.append(c);
                }
            }
            ++i;
        }
        if (addQuotes) {
            this.append('\"');
        }
        return this;
    }
}

