/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.log.CommonsLogger;
import com.ibm.commons.log.LogMgr;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.io.base64.Base64InputStream;
import com.ibm.commons.util.io.base64.Base64OutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;

public class EncryptionUtil {
    private static final KeyGenerator KEY_GENERATOR = EncryptionUtil.createKeyGenerator();
    private static final String ERROR_CODE = "ENC" + EncryptionUtil.class.hashCode();
    private static final String ALGORITHM = "DESede";
    private static final String MODE = "ECB";
    private static final String PADDING = "PKCS5Padding";
    private static final String CIPHER = "DESede/ECB/PKCS5Padding";
    private static final LogMgr log = CommonsLogger.ENCRYPTION;

    private static final KeyGenerator createKeyGenerator() {
        try {
            KeyGenerator gen = KeyGenerator.getInstance(ALGORITHM);
            return gen;
        }
        catch (Exception e) {
            try {
                if (log.isErrorEnabled()) {
                    String msg = "{0}: Error creating key generator for algorithm {1}";
                    log.error(e, msg, ERROR_CODE, ALGORITHM);
                }
            }
            catch (Exception ex) {
                e.printStackTrace();
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static synchronized Key generateKey() throws GeneralSecurityException {
        if (KEY_GENERATOR == null) {
            String msg = "Key generator failed to initialize. For cause, search logs for error code {0}.";
            msg = StringUtil.format(msg, ERROR_CODE);
            throw new GeneralSecurityException(msg);
        }
        return KEY_GENERATOR.generateKey();
    }

    private static Cipher createCipher(int cipherMode, Key encryptionKey) throws GeneralSecurityException {
        if (encryptionKey == null) {
            throw new NullPointerException();
        }
        Cipher cipher = Cipher.getInstance(CIPHER);
        if (cipherMode == 1) {
            cipher.init(cipherMode, encryptionKey);
        } else if (cipherMode == 2) {
            cipher.init(cipherMode, encryptionKey);
        } else {
            throw new IllegalArgumentException("" + cipherMode);
        }
        return cipher;
    }

    public static byte[] encrypt(Key key, byte[] data) throws GeneralSecurityException {
        if (key == null || data == null) {
            throw new IllegalArgumentException();
        }
        Cipher cipher = EncryptionUtil.createCipher(1, key);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(Key key, byte[] encryptedData) throws GeneralSecurityException {
        if (key == null || encryptedData == null) {
            throw new IllegalArgumentException();
        }
        Cipher cipher = EncryptionUtil.createCipher(2, key);
        return cipher.doFinal(encryptedData);
    }

    public static String encryptString(Key key, String plaintext) throws GeneralSecurityException {
        if (key == null || plaintext == null) {
            throw new NullPointerException();
        }
        try {
            byte[] data = plaintext.getBytes("UTF-8");
            byte[] cyphertext = EncryptionUtil.encrypt(key, data);
            ByteArrayOutputStream barrout = new ByteArrayOutputStream(cyphertext.length * 3 / 2);
            Base64OutputStream base64 = new Base64OutputStream(barrout);
            base64.write(cyphertext);
            base64.flush();
            barrout.flush();
            String ret = barrout.toString("ASCII");
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptString(Key key, String cyphertext) throws GeneralSecurityException {
        if (key == null || cyphertext == null) {
            throw new NullPointerException();
        }
        try {
            int r;
            byte[] base64 = cyphertext.getBytes("ASCII");
            ByteArrayInputStream bin = new ByteArrayInputStream(base64);
            Base64InputStream base64in = new Base64InputStream(bin);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] barr = new byte[cyphertext.length()];
            while ((r = base64in.read(barr)) > 0) {
                buffer.write(barr, 0, r);
            }
            byte[] encrypted = buffer.toByteArray();
            byte[] plaintext = EncryptionUtil.decrypt(key, encrypted);
            String ret = new String(plaintext, "UTF-8");
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

