/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

public class DoubleMap<K, V> {
    private int slotCount;
    private int size;
    private MapEntry[] keyEntries;
    private MapEntry[] valueEntries;

    public DoubleMap() {
        this(13);
    }

    public DoubleMap(int slotCount) {
        this.slotCount = slotCount;
        this.keyEntries = new MapEntry[slotCount];
        this.valueEntries = new MapEntry[slotCount];
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.keyEntries = new MapEntry[this.slotCount];
        this.valueEntries = new MapEntry[this.slotCount];
    }

    public void put(K key, V value) {
        MapEntry e = new MapEntry(key, value);
        this.put(e);
    }

    public void removeEntryByKey(K key) {
        MapEntry e = this.getEntryByKey(key);
        if (e != null) {
            this.removeEntry(e);
        }
    }

    public void removeEntryByValue(V value) {
        MapEntry e = this.getEntryByValue(value);
        if (e != null) {
            this.removeEntry(e);
        }
    }

    public V getNameByKey(K key) {
        MapEntry e = this.getEntryByKey(key);
        if (e != null) {
            return (V)e.value;
        }
        return null;
    }

    public K getIdByValue(V value) {
        MapEntry e = this.getEntryByValue(value);
        if (e != null) {
            return (K)e.key;
        }
        return null;
    }

    private final int getSlot(int hashCode) {
        return (hashCode & Integer.MAX_VALUE) % this.slotCount;
    }

    private final MapEntry getEntryByKey(K key) {
        int hashCode = key.hashCode();
        MapEntry e = this.keyEntries[this.getSlot(hashCode)];
        while (e != null) {
            if (e.keyHashCode == hashCode && e.key.equals(key)) {
                return e;
            }
            e = e.keyNextHash;
        }
        return null;
    }

    private final MapEntry getEntryByValue(V value) {
        int hashCode = value.hashCode();
        MapEntry e = this.valueEntries[this.getSlot(hashCode)];
        while (e != null) {
            if (e.valueHashCode == hashCode && e.value.equals(value)) {
                return e;
            }
            e = e.valueNextHash;
        }
        return null;
    }

    private void put(MapEntry e) {
        int keySlot = this.getSlot(e.keyHashCode);
        e.keyNextHash = this.keyEntries[keySlot];
        if (e.keyNextHash != null) {
            e.keyNextHash.keyPrevHash = e;
        }
        this.keyEntries[keySlot] = e;
        int valueSlot = this.getSlot(e.valueHashCode);
        e.valueNextHash = this.valueEntries[valueSlot];
        if (e.valueNextHash != null) {
            e.valueNextHash.valuePrevHash = e;
        }
        this.valueEntries[valueSlot] = e;
        ++this.size;
    }

    private final void removeEntry(MapEntry e) {
        if (e.keyPrevHash != null) {
            e.keyPrevHash.keyNextHash = e.keyNextHash;
        } else {
            this.keyEntries[this.getSlot((int)e.keyHashCode)] = e.keyNextHash;
        }
        if (e.keyNextHash != null) {
            e.keyNextHash.keyPrevHash = e.keyPrevHash;
        }
        if (e.valuePrevHash != null) {
            e.valuePrevHash.valueNextHash = e.valueNextHash;
        } else {
            this.valueEntries[this.getSlot((int)e.valueHashCode)] = e.valueNextHash;
        }
        if (e.valueNextHash != null) {
            e.valueNextHash.valuePrevHash = e.valuePrevHash;
        }
        --this.size;
    }

    private static final class MapEntry {
        MapEntry keyPrevHash;
        MapEntry keyNextHash;
        MapEntry valuePrevHash;
        MapEntry valueNextHash;
        int keyHashCode;
        int valueHashCode;
        Object key;
        Object value;

        MapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
            this.keyHashCode = key.hashCode();
            this.valueHashCode = value.hashCode();
        }
    }
}

