/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

public abstract class DichotomySearch {
    protected abstract int getCount();

    protected abstract int compareIndexWithValue(int var1);

    public int search(boolean exactSearch) {
        int low = 0;
        int high = this.getCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = this.compareIndexWithValue(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return exactSearch ? -1 : (low < this.getCount() ? low : this.getCount());
    }

    public static class StringArraySearch
    extends StringSearch {
        private String[] array;

        public StringArraySearch(String[] array, boolean ignoreCase) {
            super(ignoreCase);
            this.array = array;
        }

        @Override
        public int getCount() {
            return this.array.length;
        }

        @Override
        protected String getString(int idx) {
            return this.array[idx];
        }

        public String[] getArray() {
            return this.array;
        }
    }

    public static abstract class StringSearch
    extends DichotomySearch {
        private String value;
        private boolean ignoreCase;

        public StringSearch(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        @Override
        protected int compareIndexWithValue(int idx) {
            if (this.ignoreCase) {
                return this.getString(idx).compareToIgnoreCase(this.value);
            }
            return this.getString(idx).compareTo(this.value);
        }

        public int search(String value, boolean exactSearch) {
            this.value = value;
            return this.search(exactSearch);
        }

        public boolean contains(String value) {
            return this.search(value, true) >= 0;
        }

        protected abstract String getString(int var1);
    }
}

