/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.StringUtil;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTime {
    public static final String SHORT_DATE = "<date>";
    public static final String LONG_DATE = "<long date>";
    public static final String SHORT_TIME = "<time>";
    public static final String LONG_TIME = "<long time>";
    public static final String SHORT_DATETIME = "<date and time>";
    public static final String LONG_DATETIME = "<long date and time>";
    public static final String FULL_DATE = "<full>";
    public static final String MEDIUM_DATE = "<medium>";
    private static HashMap<String, String> formatCache = new HashMap();
    public static final int limitDate = 39;
    private static TGregorianCalendar[] gregorianCalendars = new TGregorianCalendar[16];
    private static int gcCount = 0;

    public static String formatDateTime(Date date, String format) {
        return DateTime.formatDateTime(date, format, Locale.getDefault(), TimeZone.getDefault());
    }

    public static String formatDateTime(Date date) {
        return DateTime.formatDateTime(date, null, Locale.getDefault(), TimeZone.getDefault());
    }

    public static String formatDateTime(Date date, Locale loc) {
        return DateTime.formatDateTime(date, null, loc, TimeZone.getDefault());
    }

    public static String formatDateTime(Date date, String format, Locale loc) {
        return DateTime.formatDateTime(date, format, loc, TimeZone.getDefault());
    }

    public static String formatDateTime(Date date, String format, Locale loc, TimeZone tz) {
        if (date == null) {
            return null;
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        if (!StringUtil.isEmpty(format)) {
            if (format.charAt(0) == '<') {
                if (format.equals(SHORT_DATE)) {
                    return DateTime.getShortDateFormatter(loc, TimeZone.getDefault()).format(date);
                }
                if (format.equals(LONG_DATE)) {
                    return DateTime.getLongDateFormatter(loc, TimeZone.getDefault()).format(date);
                }
                if (format.equals(SHORT_TIME)) {
                    return DateTime.getShortTimeFormatter(loc, tz).format(date);
                }
                if (format.equals(LONG_TIME)) {
                    return DateTime.getLongTimeFormatter(loc, tz).format(date);
                }
                if (format.equals(SHORT_DATETIME)) {
                    return DateTime.getShortDatetimeFormatter(loc, tz).format(date);
                }
                if (format.equals(LONG_DATETIME)) {
                    return DateTime.getLongDatetimeFormatter(loc, tz).format(date);
                }
            } else {
                SimpleDateFormat fmt = new SimpleDateFormat(format, loc);
                if (format != null && (format.indexOf(104) != -1 || format.indexOf(72) != -1 || format.indexOf(109) != -1 || format.indexOf(115) != -1)) {
                    fmt.setTimeZone(tz);
                }
                return fmt.format(date);
            }
        }
        return DateTime.getDefaultDateFormatter(loc).format(date);
    }

    private static String getSimplifiedDateFormat(String javafmt) {
        if (!StringUtil.isEmpty(javafmt)) {
            String fmt = formatCache.get(javafmt);
            if (fmt == null) {
                StringBuilder b = new StringBuilder();
                javafmt = StringUtil.replace(javafmt, "MMMM", "J");
                javafmt = StringUtil.replace(javafmt, "MMM", "j");
                char lastch = '\u0000';
                int i = 0;
                while (i < javafmt.length()) {
                    char ch = javafmt.charAt(i);
                    if (ch != lastch) {
                        switch (ch) {
                            case 'y': {
                                b.append('Y');
                                break;
                            }
                            case 'M': {
                                b.append('M');
                                break;
                            }
                            case 'J': {
                                b.append('J');
                                break;
                            }
                            case 'j': {
                                b.append('j');
                                break;
                            }
                            case 'd': {
                                b.append('D');
                                break;
                            }
                            case 'H': 
                            case 'h': {
                                b.append('H');
                                break;
                            }
                            case 'm': {
                                b.append('N');
                                break;
                            }
                            case 's': {
                                b.append('S');
                                break;
                            }
                            case 'z': {
                                b.append('Z');
                                break;
                            }
                            case '-': 
                            case '.': 
                            case '/': {
                                b.append('/');
                                break;
                            }
                            case ':': {
                                b.append(':');
                            }
                        }
                    }
                    lastch = ch;
                    ++i;
                }
                fmt = b.toString();
                formatCache.put(javafmt, fmt);
            }
            return fmt;
        }
        return "";
    }

    public static Date parseDate(String text, String format) throws ParseException {
        return DateTime.parseDate(text, format, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Date parseDate(String text, String format, TimeZone tz) throws ParseException {
        return DateTime.parseDate(text, format, tz, Locale.getDefault());
    }

    public static Date parseDate(String text, String format, Locale loc) throws ParseException {
        return DateTime.parseDate(text, format, TimeZone.getDefault(), loc);
    }

    public static Date parseDate(String text, String format, TimeZone tz, Locale loc) throws ParseException {
        String dt;
        if (text == null) {
            return null;
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (StringUtil.isEmpty(dt = text.toLowerCase().trim())) {
            return null;
        }
        String fmt = DateTime.getSimplifiedDateFormat(format);
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int ampm = -1;
        int pos = 0;
        boolean hasDate = false;
        boolean hasTime = false;
        int nbCharForYear = 0;
        int point = dt.indexOf(46);
        if (point != -1 && dt.charAt(point - 1) >= 'a' && dt.charAt(point - 1) <= 'z') {
            dt = String.valueOf(dt.substring(0, point)) + dt.substring(point + 1);
        }
        int fmtpos = 0;
        while (pos < dt.length()) {
            int nbChar = 0;
            char c = dt.charAt(pos++);
            ++nbChar;
            if (c >= '0' && c <= '9') {
                int num = c - 48;
                while (pos < dt.length()) {
                    c = dt.charAt(pos);
                    if (c < '0' || c > '9') break;
                    num = num * 10 + (c - 48);
                    ++pos;
                    ++nbChar;
                }
                if (fmtpos < fmt.length()) {
                    switch (fmt.charAt(fmtpos)) {
                        case 'Y': {
                            year = num;
                            hasDate = true;
                            nbCharForYear = nbChar;
                            break;
                        }
                        case 'M': {
                            month = num;
                            hasDate = true;
                            break;
                        }
                        case 'J': {
                            month = num;
                            hasDate = true;
                            break;
                        }
                        case 'j': {
                            month = num;
                            hasDate = true;
                            break;
                        }
                        case 'D': {
                            day = num;
                            hasDate = true;
                            break;
                        }
                        case 'H': {
                            hour = num;
                            hasTime = true;
                            break;
                        }
                        case 'N': {
                            minute = num;
                            hasTime = true;
                            break;
                        }
                        case 'S': {
                            second = num;
                            hasTime = true;
                        }
                    }
                    ++fmtpos;
                    continue;
                }
                throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
            }
            if (Character.isLetter(c)) {
                String ss;
                StringBuilder b = new StringBuilder();
                b.append(c);
                while (pos < dt.length()) {
                    c = dt.charAt(pos);
                    if (!Character.isLetter(c)) break;
                    b.append(c);
                    ++pos;
                }
                if ((ss = b.toString()).equals("am")) {
                    if (ampm > 0) {
                        throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
                    }
                    ampm = 1;
                    continue;
                }
                if (ss.equals("pm")) {
                    if (ampm > 0) {
                        throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
                    }
                    ampm = 2;
                    continue;
                }
                if (fmtpos < fmt.length() && (fmt.charAt(fmtpos) == 'J' || fmt.charAt(fmtpos) == 'j')) {
                    int i = DateTime.computeMonth(ss, loc);
                    if (i != -1) {
                        month = i;
                        ++fmtpos;
                        continue;
                    }
                    throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
                }
                if (fmtpos < fmt.length() && fmt.charAt(fmtpos) == 'Z') {
                    boolean found = false;
                    String[] ids = TimeZone.getAvailableIDs();
                    int i = 0;
                    while (i < ids.length) {
                        if (StringUtil.equalsIgnoreCase(ss, ids[i])) {
                            tz = TimeZone.getTimeZone(ids[i]);
                            ++fmtpos;
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (found) continue;
                    throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
                }
                throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
            }
            if (c == '/' || c == '.' || c == '-') {
                if (fmtpos >= fmt.length() || fmt.charAt(fmtpos) != '/') {
                    throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
                }
                ++fmtpos;
                continue;
            }
            if (c == ':') {
                if (fmtpos >= fmt.length() || fmt.charAt(fmtpos) != ':') {
                    throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
                }
                ++fmtpos;
                continue;
            }
            if (c == ' ' || c == ',') continue;
            throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
        }
        if (hasDate) {
            if (nbCharForYear <= 2) {
                year = DateTime.convertYearIfInf100(year);
            }
            int maxDay = month == 4 || month == 6 || month == 9 || month == 11 ? 30 : (month == 2 ? (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? 29 : 28) : 31);
            if (day < 1 || day > maxDay || month < 1 || month > 12 || year <= 0) {
                throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
            }
        } else {
            year = 0;
            month = 0;
            day = 0;
        }
        if (hasTime) {
            if (ampm == 1 && hour == 12) {
                hour = 0;
            } else if (ampm == 2 && hour != 12) {
                hour += 12;
            } else if (ampm == -1 && hour == 24) {
                hour = 0;
            }
            if (second == -1) {
                second = 0;
            }
            if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second != -1 && (second < 0 || second > 59)) {
                throw new ParseException(StringUtil.format("Invalid date '{0}'", text), pos);
            }
        } else {
            second = 0;
            minute = 0;
            hour = 0;
        }
        if (!hasDate && hasTime) {
            year = 1970;
            month = 1;
            day = 1;
        }
        if (hasDate || hasTime) {
            if (hasTime && !tz.hasSameRules(TimeZone.getDefault())) {
                TGregorianCalendar cal = DateTime.getCalendar();
                try {
                    cal.setTimeZone(tz);
                    cal.set(year, month - 1, day, hour, minute, second);
                    cal.set(14, 0);
                    Date date = cal.getTime();
                    return date;
                }
                finally {
                    DateTime.recycleCalendar(cal, true);
                }
            }
            TGregorianCalendar cal = DateTime.getCalendar();
            try {
                cal.set(year, month - 1, day, hour, minute, second);
                cal.set(14, 0);
                Date date = cal.getTime();
                return date;
            }
            finally {
                DateTime.recycleCalendar(cal, false);
            }
        }
        return null;
    }

    private static int computeMonth(String ss, Locale loc) {
        DateFormatSymbols sym = new DateFormatSymbols(loc);
        String[] monthsArray = sym.getMonths();
        String[] shortMonthsArray = sym.getShortMonths();
        int i = 0;
        while (i < monthsArray.length) {
            if (StringUtil.equalsIgnoreCase(monthsArray[i], ss)) {
                return i + 1;
            }
            ++i;
        }
        if (ss.endsWith(".")) {
            ss = ss.substring(0, ss.length() - 1);
        }
        i = 0;
        while (i < shortMonthsArray.length) {
            if (shortMonthsArray[i].endsWith(".")) {
                shortMonthsArray[i] = shortMonthsArray[i].substring(0, shortMonthsArray[i].length() - 1);
            }
            if (StringUtil.equalsIgnoreCase(shortMonthsArray[i], ss)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public static Date convertDateIntoJVMTimeZone(Date date, TimeZone userTZ) {
        return DateTime.timeZoneConversion(date, userTZ, TimeZone.getDefault());
    }

    public static Date convertDateFromJVMTimeZone(Date date, TimeZone userTZ) {
        return DateTime.timeZoneConversion(date, TimeZone.getDefault(), userTZ);
    }

    public static Date timeZoneConversion(Date date, TimeZone source, TimeZone target) {
        if (!source.equals(target)) {
            TGregorianCalendar calSource = DateTime.getCalendar();
            TGregorianCalendar calTarget = DateTime.getCalendar();
            try {
                calSource.setTimeZone(source);
                calSource.setTime(date);
                int zoneOffsetSource = -calSource.get(15);
                int dstOffsetSource = -calSource.get(16);
                calTarget.setTimeZone(target);
                calTarget.setMillis(calSource.getMillis());
                int zoneOffsetTarget = calTarget.get(15);
                int dstOffsetTarget = calTarget.get(16);
                long totalOffset = (long)zoneOffsetSource + (long)dstOffsetSource + (long)zoneOffsetTarget + (long)dstOffsetTarget;
                date = new Date(date.getTime() + totalOffset);
            }
            finally {
                DateTime.recycleCalendar(calSource, true);
                DateTime.recycleCalendar(calTarget, true);
            }
        }
        return date;
    }

    public static Timestamp convertTimestampIntoJVMTimeZone(Timestamp date, TimeZone userTZ) {
        return DateTime.timeZoneTimestampConversion(date, userTZ, TimeZone.getDefault());
    }

    public static Timestamp convertTimestampFromJVMTimeZone(Timestamp date, TimeZone userTZ) {
        return DateTime.timeZoneTimestampConversion(date, TimeZone.getDefault(), userTZ);
    }

    public static Timestamp timeZoneTimestampConversion(Timestamp date, TimeZone source, TimeZone target) {
        if (!source.equals(target)) {
            TGregorianCalendar calSource = DateTime.getCalendar();
            TGregorianCalendar calTarget = DateTime.getCalendar();
            try {
                calSource.setTimeZone(source);
                calSource.setTime(date);
                int zoneOffsetSource = -calSource.get(15);
                int dstOffsetSource = -calSource.get(16);
                calTarget.setTimeZone(target);
                calTarget.setMillis(calSource.getMillis());
                int zoneOffsetTarget = calTarget.get(15);
                int dstOffsetTarget = calTarget.get(16);
                long totalOffset = (long)zoneOffsetSource + (long)dstOffsetSource + (long)zoneOffsetTarget + (long)dstOffsetTarget;
                date = new Timestamp(date.getTime() + totalOffset);
            }
            finally {
                DateTime.recycleCalendar(calSource, true);
                DateTime.recycleCalendar(calTarget, true);
            }
        }
        return date;
    }

    public static String getFormatString(String format, Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (!StringUtil.isEmpty(format) && format.charAt(0) == '<') {
            DateFormat fmt = null;
            if (format.equals(SHORT_DATE)) {
                fmt = DateTime.getShortDateFormatter(loc);
            } else if (format.equals(LONG_DATE)) {
                fmt = DateTime.getLongDateFormatter(loc);
            } else if (format.equals(SHORT_TIME)) {
                fmt = DateTime.getShortTimeFormatter(loc);
            } else if (format.equals(LONG_TIME)) {
                fmt = DateTime.getLongTimeFormatter(loc);
            } else if (format.equals(SHORT_DATETIME)) {
                fmt = DateTime.getShortDatetimeFormatter(loc);
            } else if (format.equals(LONG_DATETIME)) {
                fmt = DateTime.getLongDatetimeFormatter(loc);
            }
            if (fmt != null && fmt instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)fmt).toPattern();
            }
        }
        return format;
    }

    public static String getFormatString(String format, Locale loc, TimeZone tZ) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (!StringUtil.isEmpty(format) && format.charAt(0) == '<') {
            DateFormat fmt = null;
            if (format.equals(SHORT_DATE)) {
                fmt = DateTime.getShortDateFormatter(loc, tZ);
            } else if (format.equals(LONG_DATE)) {
                fmt = DateTime.getLongDateFormatter(loc, tZ);
            } else if (format.equals(SHORT_TIME)) {
                fmt = DateTime.getShortTimeFormatter(loc, tZ);
            } else if (format.equals(LONG_TIME)) {
                fmt = DateTime.getLongTimeFormatter(loc, tZ);
            } else if (format.equals(SHORT_DATETIME)) {
                fmt = DateTime.getShortDatetimeFormatter(loc, tZ);
            } else if (format.equals(LONG_DATETIME)) {
                fmt = DateTime.getLongDatetimeFormatter(loc, tZ);
            } else if (format.equals(FULL_DATE)) {
                fmt = DateTime.getFullDateFormatter(loc, tZ);
            } else if (format.equals(MEDIUM_DATE)) {
                fmt = DateTime.getMediumDateFormatter(loc, tZ);
            }
            if (fmt != null && fmt instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)fmt).toPattern();
            }
        }
        return format;
    }

    public static String getFormatString(String format) {
        return DateTime.getFormatString(format, Locale.getDefault());
    }

    public static final DateFormat getDefaultDateFormatter() {
        return DateTime.getShortDateFormatter();
    }

    public static final DateFormat getShortDateFormatter() {
        return DateFormat.getDateInstance(3);
    }

    public static final DateFormat getLongDateFormatter() {
        return DateFormat.getDateInstance(1);
    }

    public static final DateFormat getDefaultDateFormatter(Locale loc) {
        return DateTime.getShortDateFormatter(loc);
    }

    public static final DateFormat getShortDateFormatter(Locale loc) {
        return DateFormat.getDateInstance(3, loc);
    }

    public static final DateFormat getLongDateFormatter(Locale loc) {
        return DateFormat.getDateInstance(1, loc);
    }

    public static final DateFormat getDefaultDateFormatter(Locale loc, TimeZone tz) {
        return DateTime.getShortDateFormatter(loc, tz);
    }

    public static final DateFormat getShortDateFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateInstance(3, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getLongDateFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateInstance(1, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getFullDateFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateInstance(0, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getMediumDateFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateInstance(2, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getDefaultTimeFormatter() {
        return DateTime.getShortTimeFormatter();
    }

    public static final DateFormat getShortTimeFormatter() {
        return DateFormat.getTimeInstance(3);
    }

    public static final DateFormat getLongTimeFormatter() {
        return DateFormat.getTimeInstance(1);
    }

    public static final DateFormat getDefaultTimeFormatter(Locale loc) {
        return DateTime.getShortTimeFormatter(loc);
    }

    public static final DateFormat getShortTimeFormatter(Locale loc) {
        return DateFormat.getTimeInstance(3, loc);
    }

    public static final DateFormat getLongTimeFormatter(Locale loc) {
        return DateFormat.getTimeInstance(1, loc);
    }

    public static final DateFormat getDefaultTimeFormatter(Locale loc, TimeZone tz) {
        return DateTime.getShortTimeFormatter(loc);
    }

    public static final DateFormat getShortTimeFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getTimeInstance(3, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getLongTimeFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getTimeInstance(1, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getDefaultDatetimeFormatter() {
        return DateTime.getShortDatetimeFormatter();
    }

    public static final DateFormat getShortDatetimeFormatter() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public static final DateFormat getLongDatetimeFormatter() {
        return DateFormat.getDateTimeInstance(1, 1);
    }

    public static final DateFormat getDefaultDatetimeFormatter(Locale loc) {
        return DateTime.getShortDatetimeFormatter(loc);
    }

    public static final DateFormat getShortDatetimeFormatter(Locale loc) {
        return DateFormat.getDateTimeInstance(3, 3, loc);
    }

    public static final DateFormat getLongDatetimeFormatter(Locale loc) {
        return DateFormat.getDateTimeInstance(1, 1, loc);
    }

    public static final DateFormat getDefaultDatetimeFormatter(Locale loc, TimeZone tz) {
        return DateTime.getShortDatetimeFormatter(loc);
    }

    public static final DateFormat getShortDatetimeFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static final DateFormat getLongDatetimeFormatter(Locale loc, TimeZone tz) {
        DateFormat df = DateFormat.getDateTimeInstance(1, 1, loc);
        df.setTimeZone(tz);
        return df;
    }

    public static int convertYear(String st) {
        int result = Integer.parseInt(st);
        if (st.length() <= 2) {
            return DateTime.convertYearIfInf100(result);
        }
        return result;
    }

    public static int convertYearIfInf100(int year) {
        if (year >= 0 && year <= 39) {
            year += 2000;
        }
        if (year > 39 && year <= 99) {
            year += 1900;
        }
        return year;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TGregorianCalendar getCalendar() {
        TGregorianCalendar[] tGregorianCalendarArray = gregorianCalendars;
        synchronized (gregorianCalendars) {
            if (gcCount == 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return new TGregorianCalendar();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return gregorianCalendars[--gcCount];
        }
    }

    public static void recycleCalendar(TGregorianCalendar cal) {
        DateTime.recycleCalendar(cal, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycleCalendar(TGregorianCalendar cal, boolean resetTZ) {
        if (resetTZ) {
            cal.setTimeZone(TimeZone.getDefault());
        }
        TGregorianCalendar[] tGregorianCalendarArray = gregorianCalendars;
        synchronized (gregorianCalendars) {
            if (gcCount < gregorianCalendars.length) {
                DateTime.gregorianCalendars[DateTime.gcCount++] = cal;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static class DateStruct {
        public int day;
        public int month;
        public int year;
        public int hour;
        public int minute;
        public int second;
        public int millis;

        public DateStruct() {
            this(System.currentTimeMillis());
        }

        public DateStruct(int year, int month, int day, int hour, int minute, int second, int millis) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.millis = millis;
        }

        public DateStruct(int year, int month, int day, int hour, int minute, int second) {
            this(year, month, day, hour, minute, second, 0);
        }

        public DateStruct(Date dt) {
            this(dt.getTime());
        }

        public DateStruct(long dt) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.setMillis(dt);
                this.year = gregorianCalendar.get(1);
                this.month = gregorianCalendar.get(2) + 1;
                this.day = gregorianCalendar.get(5);
                this.hour = gregorianCalendar.get(11);
                this.minute = gregorianCalendar.get(12);
                this.second = gregorianCalendar.get(13);
                this.millis = gregorianCalendar.get(14);
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public Date createDate() {
            return DateStruct.createDate(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millis);
        }

        public static final Date createDate(int year, int month, int day, int hour, int minute, int second) {
            return DateStruct.createDate(year, month, day, hour, minute, second, 0);
        }

        public static final Date createDate(int year, int month, int day, int hour, int minute, int second, int millis) {
            return new Date(DateStruct.createDateAsLong(year, month, day, hour, minute, second, millis));
        }

        public static final long createDateAsLong(int y, int m, int d, int h, int n, int s, int ms) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.set(y, m - 1, d, h, n, s);
                gregorianCalendar.set(14, ms);
                long l = gregorianCalendar.getMillis();
                return l;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public static final long createDateAsLong(int y, int m, int d, int h, int n, int s) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.set(y, m - 1, d, h, n, s);
                gregorianCalendar.set(14, 0);
                long l = gregorianCalendar.getMillis();
                return l;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public String toString() {
            return DateStruct.toString(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millis);
        }

        public static String toString(long ms) {
            return new DateStruct(ms).toString();
        }

        public static String toString(Date dt) {
            return new DateStruct(dt).toString();
        }

        public static String toString(int year, int month, int day, int hour, int minute, int second, int millis) {
            return String.valueOf(StringUtil.format("{0}-{1}-{2}", StringUtil.toString(year), StringUtil.toString(month), StringUtil.toString(day))) + StringUtil.format(" {0}:{1}:{2}", StringUtil.toString(hour), StringUtil.toString(minute), StringUtil.toString(second));
        }

        public static int getYear(long dt) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.setMillis(dt);
                int n = gregorianCalendar.get(1);
                return n;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public static int getYear(Date dt) {
            return DateStruct.getYear(dt.getTime());
        }

        public static int getMonth(long dt) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.setMillis(dt);
                int n = gregorianCalendar.get(2) + 1;
                return n;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public static int getMonth(Date dt) {
            return DateStruct.getMonth(dt.getTime());
        }

        public static int getDay(long dt) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.setMillis(dt);
                int n = gregorianCalendar.get(5);
                return n;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public static int getDay(Date dt) {
            return DateStruct.getDay(dt.getTime());
        }

        public static int getHour(long dt) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.setMillis(dt);
                int n = gregorianCalendar.get(11);
                return n;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public static int getHour(Date dt) {
            return DateStruct.getHour(dt.getTime());
        }

        public static int getMinute(long dt) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.setMillis(dt);
                int n = gregorianCalendar.get(12);
                return n;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public static int getMinute(Date dt) {
            return DateStruct.getMinute(dt.getTime());
        }

        public static int getSecond(long dt) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.setMillis(dt);
                int n = gregorianCalendar.get(13);
                return n;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public static int getSecond(Date dt) {
            return DateStruct.getSecond(dt.getTime());
        }

        public static int getMilliSecond(long dt) {
            TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
            try {
                gregorianCalendar.setMillis(dt);
                int n = gregorianCalendar.get(14);
                return n;
            }
            finally {
                DateTime.recycleCalendar(gregorianCalendar);
            }
        }

        public static int getMilliSecond(Date dt) {
            return DateStruct.getMilliSecond(dt.getTime());
        }
    }

    public static final class TGregorianCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = 1L;

        public final long getMillis() {
            return this.getTimeInMillis();
        }

        public final void setMillis(long ms) {
            this.setTimeInMillis(ms);
        }
    }
}

