/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.StringUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.TimeZone;

public final class Converter {
    public static char getDecimalSeparator(Locale loc) {
        return new DecimalFormatSymbols(loc).getDecimalSeparator();
    }

    public static char getGroupingSeparator(Locale loc) {
        return new DecimalFormatSymbols(loc).getGroupingSeparator();
    }

    public static Locale getJVMLocale() {
        return Locale.getDefault();
    }

    public static TimeZone getJVMTimeZone() {
        return TimeZone.getDefault();
    }

    public static long parseInteger(String src) {
        if (StringUtil.isEmpty(src)) {
            return 0L;
        }
        return Long.parseLong(src);
    }

    public static long parseInteger(String src, Locale loc) throws ParseException {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        NumberFormat nf = NumberFormat.getNumberInstance(loc);
        nf.setParseIntegerOnly(true);
        return nf.parse(src).longValue();
    }

    public static String formatInteger(long l) {
        return Converter.formatInteger(l, null, null, null);
    }

    public static String formatInteger(long l, String format) {
        return Converter.formatInteger(l, format, null, null);
    }

    public static String formatInteger(long l, Locale locale) {
        return Converter.formatInteger(l, null, null, locale);
    }

    public static String formatInteger(long l, String format, String emptyFormat) {
        return Converter.formatInteger(l, format, emptyFormat, null);
    }

    public static String formatInteger(long l, String format, String emptyFormat, Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if ((double)l == 0.0 && !StringUtil.isEmpty(emptyFormat)) {
            return emptyFormat;
        }
        NumberFormat fmt = null;
        fmt = !StringUtil.isEmpty(format) ? new DecimalFormat(format, new DecimalFormatSymbols(loc)) : NumberFormat.getNumberInstance(loc);
        if (fmt != null) {
            return fmt.format(l);
        }
        return Long.toString(l);
    }

    public static double parseDecimal(String src) {
        if (StringUtil.isEmpty(src)) {
            return 0.0;
        }
        return Double.parseDouble(src);
    }

    public static double parseDecimal(String src, Locale loc) throws ParseException {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        return NumberFormat.getInstance(loc).parse(src).floatValue();
    }

    public static double parseFloatWithDecimalSeparatorTolerance(String doubleString, Locale loc) {
        doubleString = Converter.removeThousandSeparator(doubleString, loc);
        doubleString = Converter.replaceCommaByPoint(doubleString, loc);
        return Converter.parseDecimal(doubleString);
    }

    public static String replaceCommaByPoint(String doubleString, Locale loc) {
        DecimalFormatSymbols symb = new DecimalFormatSymbols(loc);
        if (symb.getDecimalSeparator() == ',' && doubleString.indexOf(44) >= 0 && doubleString.indexOf(44) == doubleString.lastIndexOf(44) && doubleString.indexOf(46) == -1) {
            return doubleString.replace(',', '.');
        }
        return doubleString;
    }

    public static String removeThousandSeparator(String doubleString, Locale loc) {
        DecimalFormatSymbols symb = new DecimalFormatSymbols(loc);
        char thoSep = symb.getGroupingSeparator();
        if (thoSep == '.') {
            return doubleString;
        }
        if (thoSep == '\u00a0') {
            thoSep = ' ';
        }
        return StringUtil.replace(doubleString, String.valueOf(thoSep), null);
    }

    public static String formatDecimal(double d) {
        return Converter.formatDecimal(d, null, null, null);
    }

    public static String formatDecimal(double d, Locale locale) {
        return Converter.formatDecimal(d, null, null, locale);
    }

    public static String formatDecimal(double d, String format) {
        return Converter.formatDecimal(d, format, null, null);
    }

    public static String formatDecimal(double d, String format, String emptyFormat) {
        return Converter.formatDecimal(d, format, emptyFormat, null);
    }

    public static String formatDecimal(double d, String format, String emptyFormat, Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (d == 0.0 && !StringUtil.isEmpty(emptyFormat)) {
            return emptyFormat;
        }
        NumberFormat fmt = null;
        fmt = !StringUtil.isEmpty(format) ? new DecimalFormat(format, new DecimalFormatSymbols(loc)) : NumberFormat.getNumberInstance(loc);
        if (fmt != null) {
            return fmt.format(d);
        }
        return Double.toString(d);
    }

    public static String formatBoolean(boolean value) {
        return Converter.formatBoolean(value, null);
    }

    public static String formatBoolean(boolean value, Locale locale) {
        return value ? "True" : "False";
    }

    public static boolean parseBoolean(String value) {
        return StringUtil.equals(value, "True");
    }

    public static boolean parseBooleanLocale(String value) {
        return Converter.parseBoolean(value);
    }

    public static boolean parseBooleanLocale(String value, Locale locale) {
        return Converter.parseBoolean(value);
    }
}

