/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private Object array;
    private int lastItem;
    private int current;

    public ArrayIterator(Object array) {
        this.array = array;
        this.lastItem = Array.getLength(array);
    }

    public ArrayIterator(Object array, int first, int last) {
        this.array = array;
        this.current = first >= 0 ? first : 0;
        this.lastItem = last <= Array.getLength(array) ? last : Array.getLength(array);
    }

    @Override
    public boolean hasNext() {
        return this.current < this.lastItem;
    }

    @Override
    public T next() {
        if (this.current < this.lastItem) {
            return (T)Array.get(this.array, this.current++);
        }
        throw new NoSuchElementException("No more elements in the array iterator");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove items on array iterator");
    }
}

