/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.preferences;

import com.ibm.commons.util.FastStringBuffer;
import com.ibm.commons.util.StringUtil;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class Preferences {
    private HashMap<String, String> _properties = new HashMap();

    public String getString(String key) {
        String s = this._properties.get(key);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public int getInteger(String key) {
        String s = this._properties.get(key);
        if (StringUtil.isNotEmpty(s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public long getLong(String key) {
        String s = this._properties.get(key);
        if (StringUtil.isNotEmpty(s)) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    public double getDouble(String key) {
        String s = this._properties.get(key);
        if (StringUtil.isNotEmpty(s)) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0.0;
    }

    public boolean getBoolean(String key) {
        String s = this._properties.get(key);
        if (StringUtil.isNotEmpty(s)) {
            return s.equalsIgnoreCase("true");
        }
        return false;
    }

    public void putString(String key, String value) {
        this.checkKey(key);
        this.checkValue(value);
        if (StringUtil.isNotEmpty(value)) {
            this._properties.put(key, value);
        } else {
            this._properties.remove(key);
        }
    }

    public void putInteger(String key, int value) {
        this.checkKey(key);
        if (value != 0) {
            this._properties.put(key, Integer.toString(value));
        } else {
            this._properties.remove(key);
        }
    }

    public void putLong(String key, long value) {
        this.checkKey(key);
        if (value != 0L) {
            this._properties.put(key, Long.toString(value));
        } else {
            this._properties.remove(key);
        }
    }

    public void putDouble(String key, double value) {
        this.checkKey(key);
        if (value != 0.0) {
            this._properties.put(key, Double.toString(value));
        } else {
            this._properties.remove(key);
        }
    }

    public void putBoolean(String key, boolean value) {
        this.checkKey(key);
        if (value) {
            this._properties.put(key, "true");
        } else {
            this._properties.remove(key);
        }
    }

    private void checkKey(String key) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("Empty key");
        }
        if (key.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Key cannot contain '\\0' character");
        }
        if (key.indexOf(61) >= 0) {
            throw new IllegalArgumentException("Key cannot contain '=' character");
        }
    }

    private void checkValue(String value) {
        if (StringUtil.isNotEmpty(value) && value.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Value cannot contain '\\0' character");
        }
    }

    public void remove(String key) {
        this.checkKey(key);
        this._properties.remove(key);
    }

    public void clear() {
        this._properties.clear();
    }

    public void reset(Preferences prefs) {
        this._properties.clear();
        if (prefs != null) {
            for (Map.Entry<String, String> e : prefs._properties.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                this._properties.put(key, value);
            }
        }
    }

    public String writeToString() {
        FastStringBuffer b = new FastStringBuffer(4096);
        for (Map.Entry<String, String> e : this._properties.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (b.length() > 0) {
                b.append('\u0000');
            }
            b.append(key);
            b.append('=');
            b.append(value);
        }
        return b.toString();
    }

    public void readFromString(String s) {
        this._properties.clear();
        int len = s.length();
        int pos = 0;
        while (pos < len) {
            int idx = s.indexOf(61, pos);
            if (idx <= 0 || idx >= len - 1) break;
            int idx2 = s.indexOf(0, idx + 1);
            if (idx2 < 0) {
                idx2 = len;
            }
            String key = s.substring(pos, idx);
            String val = s.substring(idx + 1, idx2);
            this._properties.put(key, val);
            pos = idx2 + 1;
        }
    }

    public void dump(PrintStream out) {
        for (Map.Entry<String, String> e : this._properties.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            out.print(key);
            out.print("=");
            out.println(value);
        }
    }

    public static void main(String[] args) {
        Preferences p = new Preferences();
        p.putString("s1", "value1");
        p.putString("s1.s2", "value2=toto");
        p.putString("s1.s2.s3", "value2\ntoto");
        System.out.println("Initial:");
        p.dump(System.out);
        String s = p.writeToString();
        System.out.println("\nSerialization:");
        System.out.println(s);
        Preferences p2 = new Preferences();
        p2.readFromString(s);
        System.out.println("\nRead:");
        p2.dump(System.out);
    }
}

