/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.platform;

import com.ibm.commons.platform.GenericWebAppServerPlatform;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.TDiag;
import com.ibm.commons.util.io.ReaderInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.naming.NamingException;

public abstract class WebAppServerPlatform
extends GenericWebAppServerPlatform {
    public static final String PROP_INSTALLDIR = "webserver.installdir";
    public static final String PROP_RESOURCESDIR = "webserver.resourcesdir";
    public static final String RESNAME_RESOURCESXML = "resources.xml";
    public static final String RESNAME_SQLDDLPROPS = "sqlddl.properties";
    public static final String ENABLE_ADVSTATEMGR = "enableAdvStateMgr";

    @Override
    public String getProperty(String key) {
        if (PROP_INSTALLDIR.equals(key)) {
            return this.getInstallationDirectory().getAbsolutePath();
        }
        if (PROP_RESOURCESDIR.equals(key)) {
            return this.getResourcesDirectory().getAbsolutePath();
        }
        return super.getProperty(key);
    }

    public abstract File getInstallationDirectory();

    public abstract File getResourcesDirectory();

    @Override
    public InputStream getGlobalResource(String resourceName) {
        InputStream jndiStream = this.getGlobalResourceFromJNDI(resourceName);
        if (jndiStream != null) {
            return jndiStream;
        }
        InputStream fileStream = this.getGlobalResourceFromFile(resourceName);
        if (fileStream != null) {
            return fileStream;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected InputStream getGlobalResourceFromJNDI(String resourceName) {
        name = this.getResourceJNDIName(resourceName);
        if (StringUtil.isNotEmpty(name)) {
            logMsgs = new ArrayList<String>();
            resourcesXmlVal = null;
            try {
                resourcesXmlVal = this.getGlobalResJNDIProperty(resourceName);
            }
            catch (NamingException e) {
                logMsgs.add("NamingException while reading the JNDI property for global resources descriptor. Exception: " + e.getMessage());
            }
            if (StringUtil.isNotEmpty(resourcesXmlVal)) {
                url = null;
                try {
                    url = new URL(resourcesXmlVal);
                    logMsgs.add("Found a valid URL to global resources descriptor. Accessing URL now...");
                    return url.openStream();
                }
                catch (MalformedURLException v0) {
                    return new ReaderInputStream(new StringReader(resourcesXmlVal));
                }
                catch (IOException v1) {
                    logMsgs.add("IOException while accessing the URL to global resources descriptor.");
                    ** for (msg : logMsgs)
                }
lbl-1000:
                // 1 sources

                {
                    TDiag.trace(msg, new Object[0]);
                    continue;
                }
lbl26:
                // 1 sources

                logMsgs.clear();
            }
        }
        return null;
    }

    protected String getResourceJNDIName(String resourceName) {
        return null;
    }

    protected String getGlobalResJNDIProperty(String resourceName) throws NamingException {
        return null;
    }

    protected InputStream getGlobalResourceFromFile(String resourceName) {
        File file = this.getGlobalResourceFile(resourceName);
        if (file != null) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    @Override
    public File getGlobalResourceFile(String resourceName) {
        File file = new File(this.getResourcesDirectory(), resourceName);
        return file;
    }

    @Override
    public boolean isFeatureEnabled(String featureId) {
        if (StringUtil.equals(featureId, ENABLE_ADVSTATEMGR)) {
            return true;
        }
        return super.isFeatureEnabled(featureId);
    }
}

