/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.platform;

import com.ibm.commons.IPlatformService;
import com.ibm.commons.Platform;
import com.ibm.commons.log.LogMgrFactory;
import com.ibm.commons.log.eclipse.EclipseLogMgrFactory;
import com.ibm.commons.platform.IGlobalResourceProvider;
import com.ibm.commons.platform.IServiceFactory;
import java.io.InputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class GenericEclipsePlatform
extends Platform {
    public static final String ECLIPSE_PLATFORM = "Eclipse";

    @Override
    protected void initialize() {
    }

    @Override
    public String getName() {
        return "Generic Eclipse";
    }

    @Override
    public boolean isPlatform(String name) {
        if (ECLIPSE_PLATFORM.equals(name)) {
            return true;
        }
        return super.isPlatform(name);
    }

    @Override
    public PrintStream getOutputStream() {
        return System.out;
    }

    @Override
    public PrintStream getErrorStream() {
        return System.err;
    }

    @Override
    protected LogMgrFactory createLogMgrFactory() {
        return new EclipseLogMgrFactory();
    }

    @Override
    public final boolean isEclipseBased() {
        return true;
    }

    @Override
    public InputStream getGlobalResource(String resourceName) {
        InputStream is = this.findGlobalResource(resourceName);
        if (is != null) {
            return is;
        }
        return super.getGlobalResource(resourceName);
    }

    private InputStream findGlobalResource(String resourceName) {
        block7: {
            try {
                IExtensionRegistry reg = org.eclipse.core.runtime.Platform.getExtensionRegistry();
                if (reg == null) break block7;
                IConfigurationElement[] elt = reg.getConfigurationElementsFor("com.ibm.commons.GlobalResourceFactory");
                int i = 0;
                while (i < elt.length) {
                    if ("globalResourceFactory".equalsIgnoreCase(elt[i].getName())) {
                        try {
                            Object o = elt[i].createExecutableExtension("class");
                            IGlobalResourceProvider factory = (IGlobalResourceProvider)o;
                            InputStream is = factory.getGlobalResource(resourceName);
                            if (is != null) {
                                return is;
                            }
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IPlatformService getPlatformService(String serviceId) {
        IPlatformService srv = super.getPlatformService(serviceId);
        if (srv == null) {
            srv = this.findService(serviceId);
        }
        return srv;
    }

    private IPlatformService findService(String serviceId) {
        block7: {
            try {
                IExtensionRegistry reg = org.eclipse.core.runtime.Platform.getExtensionRegistry();
                if (reg == null) break block7;
                IConfigurationElement[] elt = reg.getConfigurationElementsFor("com.ibm.commons.ServiceFactory");
                int i = 0;
                while (i < elt.length) {
                    if ("serviceFactory".equalsIgnoreCase(elt[i].getName())) {
                        try {
                            Object o = elt[i].createExecutableExtension("class");
                            IServiceFactory factory = (IServiceFactory)o;
                            IPlatformService srv = factory.getPlatformService(serviceId);
                            if (srv != null) {
                                return srv;
                            }
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public boolean isFeatureEnabled(String featureId) {
        return false;
    }
}

