/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.log;

import com.ibm.commons.Platform;
import com.ibm.commons.log.CommonsLogger;
import com.ibm.commons.log.EmptyLogMgr;
import com.ibm.commons.log.LogException;
import com.ibm.commons.log.LogMgr;
import com.ibm.commons.log.jdk.JdkLogMgrFactory;
import com.ibm.commons.util.StringUtil;

public class Log {
    private static JdkLogMgrFactory _logFactory = null;
    private static String developerName = null;

    public static String getDeveloperName() {
        if (developerName == null) {
            try {
                developerName = Platform.getInstance().getProperty("ibm.developername");
            }
            catch (Throwable t) {
                CommonsLogger.STANDARD.error(t, "Error while reading the developer name", new Object[0]);
            }
            if (developerName == null) {
                developerName = "anonymous";
            }
        }
        return developerName;
    }

    private static LogMgr load(String loggerName, Class<?> loggerClass, String description) {
        try {
            LogMgr logger;
            if (_logFactory == null) {
                _logFactory = new JdkLogMgrFactory();
            }
            if ((logger = _logFactory.getLogMgr(loggerName, description)) == null) {
                throw new NullPointerException(String.valueOf(loggerName) + ": Failed to get log (null)");
            }
            return logger;
        }
        catch (Throwable t) {
            System.err.println("Logging error: " + t.getLocalizedMessage());
            t.printStackTrace();
            return new EmptyLogMgr();
        }
    }

    @Deprecated
    public static LogMgr load(String loggerName, Class<?> loggerClass) {
        return Log.load(loggerName, loggerClass, null);
    }

    public static LogMgr load(String loggerName) {
        return Log.load(loggerName, null, null);
    }

    public static LogMgr load(String loggerName, String description) {
        return Log.load(loggerName, null, description);
    }

    public static LogMgr loadDev(String userName) {
        boolean enabled = StringUtil.equals(userName, Log.getDeveloperName());
        if (!enabled) {
            return new EmptyLogMgr();
        }
        LogMgr mgr = Log.load("com.ibm.commons.devlog", "Development Logger for " + userName);
        mgr.setLogLevel(LogMgr.LOG_TRACEDEBUG_LEVEL);
        return mgr;
    }

    @Deprecated
    public static LogMgr get(Class theClass) {
        return Log.get(Log.getPackageName(theClass));
    }

    @Deprecated
    private static LogMgr get(String loggerName) {
        try {
            return Platform.getInstance().getLogMgrFactory().getLogMgr(loggerName, null);
        }
        catch (LogException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    private static String getPackageName(Class theClass) {
        String className;
        int index;
        Package pack = theClass.getPackage();
        String packageName = pack == null ? ((index = (className = theClass.getName()).lastIndexOf(46)) > 0 ? className.substring(0, index) : "") : theClass.getPackage().getName();
        return packageName;
    }
}

