/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class BasicFormatter
extends Formatter {
    private boolean dateTime;
    private static final DateFormat format = new SimpleDateFormat("h:mm:ss");
    private static final String lineSep = System.getProperty("line.separator");

    public BasicFormatter(boolean dateTime) {
        this.dateTime = dateTime;
    }

    @Override
    public String format(LogRecord record) {
        if (this.dateTime) {
            StringBuilder output = new StringBuilder().append("[").append(record.getLevel()).append('|').append(format.format(new Date(record.getMillis()))).append("]: ").append(record.getMessage()).append(' ').append(lineSep);
            return output.toString();
        }
        StringBuilder output = new StringBuilder().append(record.getMessage()).append(lineSep);
        return output.toString();
    }
}

