/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.log;

import com.ibm.commons.log.LogMgr;
import com.ibm.commons.log.LogMgrFactory;
import com.ibm.commons.util.StringUtil;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class AbstractLogMgr
implements LogMgr {
    private LogMgrFactory factory;
    private String description;
    private int indent;

    public AbstractLogMgr(LogMgrFactory factory, String description) {
        this.factory = factory;
        this.description = description;
    }

    public LogMgrFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void incIndent() {
        ++this.indent;
    }

    public void decIndent() {
        --this.indent;
    }

    public int getIndentationLevel() {
        return this.indent;
    }

    protected abstract LogRecord createLogRecord(Level var1, String var2);

    protected void log(Throwable t, Level level, String msg, Object[] objs) {
        LogRecord lr = this.createLogRecord(level, msg);
        if (t != null) {
            lr.setThrown(t);
        }
        if (objs != null) {
            lr.setParameters(objs);
        }
        this.getLogger().log(lr);
    }

    protected void logp(Object clazz, String methodName, Throwable t, Level level, String msg, Object[] objs) {
        LogRecord lr = this.createLogRecord(level, msg);
        if (t != null) {
            lr.setThrown(t);
        }
        if (clazz != null) {
            lr.setSourceClassName(this.toClassName(clazz));
        }
        if (methodName != null) {
            lr.setSourceMethodName(methodName);
        }
        if (objs != null) {
            lr.setParameters(objs);
        }
        this.getLogger().log(lr);
    }

    protected void logEntry(String className, String methodName, Object[] parameters) {
        this.getLogger().entering(className, methodName, parameters);
    }

    protected void logExit(String className, String methodName, Object retValue) {
        this.getLogger().exiting(className, methodName, retValue);
    }

    private String toClassName(Object clazz) {
        if (clazz instanceof String) {
            return clazz.toString();
        }
        if (clazz instanceof Class) {
            return ((Class)clazz).getName();
        }
        return clazz.getClass().getName();
    }

    @Override
    public boolean isTraceDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    @Override
    public boolean isTraceEntryExitEnabled() {
        return this.getLogger().isLoggable(Level.FINER);
    }

    public boolean isTraceEntryEnabled() {
        return this.getLogger().isLoggable(Level.FINER);
    }

    public boolean isTraceExitEnabled() {
        return this.getLogger().isLoggable(Level.FINER);
    }

    @Override
    public boolean isTraceEventEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    @Override
    public void setLogLevel(int newLevel) {
        int currentLevel = 0;
        if (this.getLogger().getLevel() != null) {
            currentLevel = this.getLogger().getLevel().intValue();
        }
        Level lLevel = null;
        if (newLevel == LOG_TRACEDEBUG_LEVEL) {
            lLevel = Level.FINEST;
        } else if (newLevel == LOG_TRACEENTRY_LEVEL || newLevel == LOG_TRACEEXIT_LEVEL || newLevel == LOG_TRACEENTRYEXIT_LEVEL) {
            lLevel = Level.FINER;
        } else if (newLevel == LOG_TRACEEVENT_LEVEL) {
            lLevel = Level.FINE;
        } else if (newLevel == LOG_INFO_LEVEL) {
            lLevel = Level.INFO;
        } else if (newLevel == LOG_WARN_LEVEL) {
            lLevel = Level.WARNING;
        } else if (newLevel == LOG_ERROR_LEVEL) {
            lLevel = Level.SEVERE;
        }
        if (lLevel != null && lLevel.intValue() != currentLevel) {
            this.resetLevels(this.getLogger(), lLevel);
        }
    }

    private void resetLevels(Logger loga, Level newLevel) {
        loga.setLevel(newLevel);
    }

    @Override
    public void traceEntry(Object o, String methodName) {
        if (this.isTraceEntryExitEnabled()) {
            this.logEntry(o.getClass().getName(), methodName, null);
        }
    }

    @Override
    public void traceEntry(Object o, String methodName, Object ... parameters) {
        if (this.isTraceEntryExitEnabled()) {
            this.logEntry(o.getClass().getName(), methodName, parameters);
        }
    }

    public void traceEntry(Class c, String methodName) {
        if (this.isTraceEntryExitEnabled()) {
            this.logEntry(c.getName(), methodName, null);
        }
    }

    public void traceEntry(Class c, String methodName, Object ... parameters) {
        if (this.isTraceEntryExitEnabled()) {
            this.logEntry(c.getName(), methodName, parameters);
        }
    }

    @Override
    public void traceExit(Object o, String methodName) {
        if (this.isTraceEntryExitEnabled()) {
            this.logExit(o.getClass().getName(), methodName, null);
        }
    }

    @Override
    public void traceExit(Object o, String methodName, Object ret) {
        if (this.isTraceEntryExitEnabled()) {
            this.logExit(o.getClass().getName(), methodName, ret);
        }
    }

    public void traceExit(Class c, String methodName) {
        if (this.isTraceEntryExitEnabled()) {
            this.logExit(c.getName(), methodName, null);
        }
    }

    public void traceExit(Class c, String methodName, Object ret) {
        if (this.isTraceEntryExitEnabled()) {
            this.logExit(c.getName(), methodName, ret);
        }
    }

    @Override
    public void info(String msg, Object ... parameters) {
        if (this.isInfoEnabled()) {
            this.log(null, Level.INFO, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void info(Throwable t, String msg, Object ... parameters) {
        if (this.isInfoEnabled()) {
            this.log(t, Level.INFO, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void infop(Object clazz, String methodName, String msg, Object ... parameters) {
        if (this.isInfoEnabled()) {
            this.logp(clazz, methodName, null, Level.INFO, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void infop(Object clazz, String methodName, Throwable t, String msg, Object ... parameters) {
        if (this.isInfoEnabled()) {
            this.logp(clazz, methodName, t, Level.INFO, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void warn(String msg, Object ... parameters) {
        if (this.isWarnEnabled()) {
            this.log(null, Level.WARNING, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void warn(Throwable t, String msg, Object ... parameters) {
        if (this.isWarnEnabled()) {
            this.log(t, Level.WARNING, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void warnp(Object clazz, String methodName, String msg, Object ... parameters) {
        if (this.isWarnEnabled()) {
            this.logp(clazz, methodName, null, Level.WARNING, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void warnp(Object clazz, String methodName, Throwable t, String msg, Object ... parameters) {
        if (this.isWarnEnabled()) {
            this.logp(clazz, methodName, t, Level.WARNING, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void error(String msg, Object ... parameters) {
        if (this.isErrorEnabled()) {
            this.log(null, Level.SEVERE, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void error(Throwable t, String msg, Object ... parameters) {
        if (this.isErrorEnabled()) {
            this.log(t, Level.SEVERE, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void errorp(Object clazz, String methodName, String msg, Object ... parameters) {
        if (this.isErrorEnabled()) {
            this.logp(clazz, methodName, null, Level.SEVERE, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void errorp(Object clazz, String methodName, Throwable t, String msg, Object ... parameters) {
        if (this.isErrorEnabled()) {
            this.logp(clazz, methodName, t, Level.SEVERE, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void traceEvent(String msg, Object ... parameters) {
        if (this.isTraceEventEnabled()) {
            this.log(null, Level.FINE, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void traceEvent(Throwable t, String msg, Object ... parameters) {
        if (this.isTraceEventEnabled()) {
            this.log(t, Level.FINE, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void traceEventp(Object clazz, String methodName, String msg, Object ... parameters) {
        if (this.isTraceEventEnabled()) {
            this.logp(clazz, methodName, null, Level.FINE, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void traceEventp(Object clazz, String methodName, Throwable t, String msg, Object ... parameters) {
        if (this.isTraceEventEnabled()) {
            this.logp(clazz, methodName, t, Level.FINE, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void traceDebug(String msg, Object ... parameters) {
        if (this.isTraceDebugEnabled()) {
            this.log(null, Level.FINEST, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void traceDebug(Throwable t, String msg, Object ... parameters) {
        if (this.isTraceDebugEnabled()) {
            this.log(t, Level.FINEST, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void traceDebugp(Object clazz, String methodName, String msg, Object ... parameters) {
        if (this.isTraceDebugEnabled()) {
            this.logp(clazz, methodName, null, Level.FINEST, StringUtil.format(msg, parameters), null);
        }
    }

    @Override
    public void traceDebugp(Object clazz, String methodName, Throwable t, String msg, Object ... parameters) {
        if (this.isTraceDebugEnabled()) {
            this.logp(clazz, methodName, t, Level.FINEST, StringUtil.format(msg, parameters), null);
        }
    }
}

