/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.extension;

import com.ibm.commons.extension.OSGiExtensionService;
import com.ibm.commons.log.CommonsLogger;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.TDiag;
import com.ibm.commons.util.io.StreamUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ExtensionManager {
    private static Provider provider;

    static {
        try {
            block8: {
                try {
                    String osgi = System.getProperty("osgi.framework.version");
                    if (!StringUtil.isNotEmpty(osgi)) break block8;
                    try {
                        String prop = System.getProperty("com.ibm.common.ExtensionManager");
                        if (StringUtil.isEmpty(prop) || StringUtil.equals(prop, "osgi")) {
                            Class.forName("org.eclipse.core.runtime.Platform");
                            provider = new EclipseProvider();
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {}
            }
            if (provider == null) {
                provider = new JavaServiceProvider();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static List<Object> findApplicationServices(ClassLoader loader, String serviceType) {
        return ExtensionManager.findApplicationServices(null, loader, serviceType);
    }

    public static List<Object> findApplicationServices(Map<String, List<Object>> services, ClassLoader loader, String serviceType) {
        List<Object> l;
        if (services != null && (l = services.get(serviceType)) != null) {
            return l;
        }
        l = ExtensionManager.loadServices(loader, serviceType);
        if (services != null) {
            services.put(serviceType, l);
        }
        return l;
    }

    public static List<Object> findServices(List<Object> list, Class<?> clazz, String serviceType) {
        return ExtensionManager.findServices(list, clazz.getClassLoader(), serviceType);
    }

    public static List<Object> findServices(List<Object> list, ClassLoader loader, String serviceType) {
        if (list != null) {
            return list;
        }
        ApplicationClassLoader ac = ExtensionManager.adaptApplicationClassloader(loader);
        if (ac != null) {
            loader = loader.getParent();
        }
        list = ExtensionManager.loadServices(loader, serviceType);
        return list;
    }

    public static <T> List<T> findServices(List<T> existingList, ClassLoader loader, String serviceType, Class<T> requiredType) {
        if (existingList != null) {
            return existingList;
        }
        List<Object> items = ExtensionManager.findServices(null, loader, serviceType);
        if (requiredType != null) {
            int i = 0;
            while (i < items.size()) {
                Object item = items.get(i);
                if (!requiredType.isAssignableFrom(item.getClass())) {
                    ExtensionManager.logServiceNotInstanceOf(serviceType, item, requiredType);
                    items.remove(i);
                    --i;
                }
                ++i;
            }
        }
        return items;
    }

    private static void logServiceNotInstanceOf(String extensionPointId, Object obj, Class<?> requiredType) {
        if (CommonsLogger.STANDARD.isWarnEnabled()) {
            String warnMsg = "The object {0} cannot contribute to the service {1}, as it is not an instance of {2}";
            CommonsLogger.STANDARD.warnp(ExtensionManager.class, "logClassNotLibrary", warnMsg, obj, extensionPointId, requiredType.getName());
        }
    }

    private static List<Object> loadServices(ClassLoader loader, String serviceType) {
        ArrayList<Object> list = new ArrayList<Object>();
        provider.findInitializer(loader, list, serviceType);
        return list;
    }

    private static ApplicationClassLoader adaptApplicationClassloader(ClassLoader loader) {
        if (loader instanceof ApplicationClassLoader) {
            return (ApplicationClassLoader)((Object)loader);
        }
        return null;
    }

    public static interface ApplicationClassLoader {
        public Enumeration<URL> findApplicationResources(String var1) throws IOException;
    }

    private static class EclipseProvider
    extends JavaServiceProvider {
        private EclipseProvider() {
            super(null, null);
        }

        @Override
        public void findInitializer(ClassLoader loader, List<Object> initializers, String serviceType) {
            ApplicationClassLoader ac;
            block13: {
                try {
                    Object o;
                    IExtensionRegistry reg = Platform.getExtensionRegistry();
                    if (reg == null) break block13;
                    IConfigurationElement[] elt = reg.getConfigurationElementsFor("com.ibm.commons.Extension");
                    int i = 0;
                    while (i < elt.length) {
                        String type;
                        if ("service".equalsIgnoreCase(elt[i].getName()) && StringUtil.equals(type = elt[i].getAttribute("type"), serviceType)) {
                            try {
                                o = elt[i].createExecutableExtension("class");
                                initializers.add(o);
                            }
                            catch (Throwable ex) {
                                this.logCouldNotCreateContribution(ex, elt[i], type);
                            }
                        }
                        ++i;
                    }
                    HashSet<URL> urls = new HashSet<URL>();
                    elt = reg.getConfigurationElementsFor("com.ibm.commons.ExtensionBundle");
                    int i2 = 0;
                    while (i2 < elt.length) {
                        try {
                            o = (OSGiExtensionService)elt[i2].createExecutableExtension("class");
                            Bundle bundle = o.getBundle();
                            if (bundle != null) {
                                this.findServicesClassLoader(o.getClass().getClassLoader(), urls, initializers, serviceType);
                            }
                        }
                        catch (Throwable ex) {
                            this.logCouldNotCreateContribution(ex, elt[i2], serviceType);
                        }
                        ++i2;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if ((ac = ExtensionManager.adaptApplicationClassloader(loader)) != null) {
                super.findInitializer(loader, initializers, serviceType);
            } else if (loader == Thread.currentThread().getContextClassLoader()) {
                super.findInitializer(loader, initializers, serviceType);
            }
        }

        @Override
        Enumeration<URL> getResourcesList(ClassLoader loader, String serviceType) throws IOException {
            ApplicationClassLoader ac = ExtensionManager.adaptApplicationClassloader(loader);
            if (ac != null) {
                return ac.findApplicationResources("META-INF/services/" + serviceType);
            }
            return loader.getResources("META-INF/services/" + serviceType);
        }

        private void findServicesClassLoader(ClassLoader loader, Set<URL> urls, List<Object> list, String serviceType) throws IOException {
            Enumeration<URL> e = loader.getResources("META-INF/services/" + serviceType);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                this.findServicesClassLoader(list, loader, urls, url, serviceType);
            }
        }

        private void findServicesClassLoader(List<Object> list, ClassLoader loader, Set<URL> urls, URL url, String serviceType) throws IOException {
            if (!(url == null || urls != null && urls.contains(url))) {
                this.parseResource(loader, list, url, serviceType);
                if (urls != null) {
                    urls.add(url);
                }
            }
        }

        void logCouldNotCreateContribution(Throwable ex, IConfigurationElement ext, String type) {
            if (CommonsLogger.STANDARD.isWarnEnabled()) {
                String extensionPointId = "com.ibm.commons.Extension";
                String className = ext.getAttribute("class");
                String warnMsg = "Could not create an instance of {0}, contributed to the extension point {1} with type {2}.";
                CommonsLogger.STANDARD.warnp((Object)this, "logCouldNotCreateContribution", ex, warnMsg, className, extensionPointId, type);
            }
        }
    }

    private static class JavaServiceProvider
    implements Provider {
        final String PREFIX = "META-INF/services/";

        private JavaServiceProvider() {
        }

        @Override
        public void findInitializer(ClassLoader loader, List<Object> initializers, String serviceType) {
            try {
                Enumeration<URL> e = this.getResourcesList(loader, serviceType);
                if (e != null) {
                    while (e.hasMoreElements()) {
                        URL url = e.nextElement();
                        this.parseResource(loader, initializers, url, serviceType);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        Enumeration<URL> getResourcesList(ClassLoader loader, String serviceType) throws IOException {
            return loader.getResources("META-INF/services/" + serviceType);
        }

        void parseResource(ClassLoader loader, List<Object> initializers, URL url, String serviceType) throws IOException {
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
            try {
                while (true) {
                    String s;
                    if ((s = r.readLine()) == null) {
                        return;
                    }
                    int comment = s.indexOf(35);
                    if (comment >= 0) {
                        s = s.substring(0, comment);
                    }
                    if (!StringUtil.isNotEmpty(s = s.trim())) continue;
                    try {
                        Class<?> c = loader.loadClass(s);
                        Object o = c.newInstance();
                        initializers.add(o);
                    }
                    catch (Throwable ex) {
                        this.logCouldNotCreateService(ex, s, serviceType);
                        TDiag.trace("Designer runtime: Error while parsing service file {0}", url.toString());
                    }
                }
            }
            finally {
                StreamUtil.close(r);
            }
        }

        private void logCouldNotCreateService(Throwable ex, String className, String serviceType) {
            if (CommonsLogger.STANDARD.isWarnEnabled()) {
                String warnMsg = "Could not create an instance of {0}, contributed to the service {1}.";
                CommonsLogger.STANDARD.warnp((Object)this, "logCouldNotCreateService", ex, warnMsg, className, serviceType);
            }
        }

        /* synthetic */ JavaServiceProvider(JavaServiceProvider javaServiceProvider, JavaServiceProvider javaServiceProvider2) {
            this();
        }
    }

    private static interface Provider {
        public void findInitializer(ClassLoader var1, List<Object> var2, String var3);
    }
}

