/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons;

public class PlatformClassLoader
extends SecurityManager {
    private static boolean retry = false;
    private static int idx = 0;

    public Class[] getClassContext() {
        return super.getClassContext();
    }

    public boolean canDefineClass(String classname) {
        try {
            this.checkPackageDefinition(classname);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public Class findClass(String classname) {
        Class[] stackd = this.getClassContext();
        retry = true;
        idx = 0;
        while (this.hasMore()) {
            ClassLoader cl = this.findDesLoader(stackd);
            if (cl == null) continue;
            try {
                return cl.loadClass(classname);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    private ClassLoader findDesLoader(Class[] stack) {
        return this.findClassLoader(stack, "com.ibm.workplace.designer");
    }

    private ClassLoader findClassLoader(Class[] stack, String pkgName) {
        while (idx < stack.length) {
            if (stack[idx].getName().startsWith(pkgName)) {
                return stack[idx++].getClassLoader();
            }
            ++idx;
        }
        retry = false;
        return null;
    }

    public boolean hasMore() {
        return retry;
    }

    public ClassLoader getClassLoader(String packageName) {
        Class[] stackd = this.getClassContext();
        retry = true;
        idx = 0;
        ClassLoader cl = this.findClassLoader(stackd, packageName);
        return cl != null ? cl : ClassLoader.getSystemClassLoader();
    }
}

