/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons;

import com.ibm.commons.IPlatformService;
import com.ibm.commons.extension.ExtensionManager;
import com.ibm.commons.log.LogMgrFactory;
import com.ibm.commons.platform.GenericEclipsePlatform;
import com.ibm.commons.platform.GenericPlatform;
import com.ibm.commons.platform.GenericWebAppServerPlatform;
import com.ibm.commons.platform.IPlatformFactory;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.io.StreamUtil;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public abstract class Platform {
    private static Platform instance;
    public static final String FACTORY_CLASS = "com.ibm.commons.platform.Factory";
    public static final String PORTAL6_PLATFORM_CLASS = "com.ibm.xsp.portlet.platform.PortalPlatform";
    public static final String PLATFORM_PROPERTY_KEY = "com.ibm.commons.platform";
    private static final String PLATFORM_PROPERTIES = "META-INF/com.ibm.commons.Platform.properties";
    private LogMgrFactory logMgrFactory;
    private HashMap<String, Object> _objects;
    private HashMap<String, IPlatformService> _services;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Platform getInstance() {
        if (instance != null) return instance;
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (instance != null) return instance;
            instance = Platform.createPlatform();
            instance.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPlatform(Platform platform) {
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (instance != null) {
                throw new IllegalStateException("Platform Object has already been set");
            }
            instance = platform;
            instance.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static Platform createPlatform() {
        Platform platform;
        String prop = System.getProperty(PLATFORM_PROPERTY_KEY);
        if (StringUtil.isNotEmpty(prop) && (platform = Platform.loadPlatform(prop)) != null) {
            return platform;
        }
        try {
            List<Object> l = ExtensionManager.findServices(null, Platform.class, FACTORY_CLASS);
            if (l.size() > 0) {
                try {
                    IPlatformFactory factory = (IPlatformFactory)l.get(0);
                    return factory.createPlatform();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {}
        try {
            Class<?> factoryClass = Class.forName(FACTORY_CLASS);
            try {
                IPlatformFactory factory = (IPlatformFactory)factoryClass.newInstance();
                return factory.createPlatform();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        platform = Platform.findPlatform();
        if (platform != null) {
            return platform;
        }
        return new GenericPlatform();
    }

    protected Platform() {
        instance = this;
        this._objects = new HashMap();
        this._services = new HashMap();
        this.logMgrFactory = this.createLogMgrFactory();
    }

    protected void initialize() {
    }

    public abstract String getName();

    public final LogMgrFactory getLogMgrFactory() {
        return this.logMgrFactory;
    }

    protected abstract LogMgrFactory createLogMgrFactory();

    public abstract PrintStream getOutputStream();

    public abstract PrintStream getErrorStream();

    public abstract boolean isEclipseBased();

    public boolean isPlatform(String name) {
        return false;
    }

    public IPlatformService getPlatformService(String serviceId) {
        return this._services.get(serviceId);
    }

    public void registerPlatformService(String serviceId, IPlatformService platformService) {
        this._services.put(serviceId, platformService);
    }

    public String getProperty(String key) {
        String s = (String)this._objects.get(key);
        if (s != null) {
            return s;
        }
        return null;
    }

    public void putProperty(String key, String object) {
        this._objects.put(key, object);
    }

    public void removeProperty(String key) {
        this._objects.remove(key);
    }

    public InputStream getGlobalResource(String resourceName) {
        return null;
    }

    public File getGlobalResourceFile(String resourceName) {
        return null;
    }

    public Object getObject(String key) {
        return null;
    }

    public void log(Throwable ex) {
        ex.printStackTrace();
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(String message, Object ... parameters) {
        System.out.println(StringUtil.format(message, parameters));
    }

    private static Platform findPlatform() {
        if (Platform.tryClass("javax.servlet.Servlet")) {
            Platform p = Platform.loadPlatformFromPropertiesFile();
            if (p != null) {
                return p;
            }
            if (Platform.tryClass("javax.portlet.Portlet") && Platform.tryClass("com.ibm.wps.datastore.domains.DatabaseDomain")) {
                return Platform.loadPlatform(PORTAL6_PLATFORM_CLASS);
            }
            return new GenericWebAppServerPlatform();
        }
        if (Platform.tryClass("org.eclipse.core.runtime.Platform")) {
            try {
                Class<?> c = Class.forName("com.ibm.commons.platform.EclipsePlatformFactory");
                IPlatformFactory factory = (IPlatformFactory)c.newInstance();
                return factory.createPlatform();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new GenericEclipsePlatform();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Platform loadPlatformFromPropertiesFile() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = Platform.class.getClassLoader();
            }
            InputStream is = null;
            try {
                is = loader.getResourceAsStream(PLATFORM_PROPERTIES);
                if (is == null) return null;
                Properties props = new Properties();
                props.load(is);
                String className = props.getProperty(PLATFORM_PROPERTY_KEY);
                if (!StringUtil.isEmpty(className)) return null;
                Platform platform = Platform.loadPlatform(className);
                return platform;
            }
            finally {
                StreamUtil.close(is);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private static boolean tryClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static Platform loadPlatform(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (Platform)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public abstract boolean isFeatureEnabled(String var1);
}

