/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.xpath.xml;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.xml.DOMUtil;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.XPathContext;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.XResultUtils;
import com.ibm.commons.xml.xpath.AbstractSimpleExpression;
import com.ibm.commons.xml.xpath.NodeListImpl;
import com.ibm.commons.xml.xpath.XPathException;
import com.ibm.commons.xml.xpath.part.AttributePart;
import com.ibm.commons.xml.xpath.part.IndexedElementPart;
import com.ibm.commons.xml.xpath.part.Part;
import com.ibm.commons.xml.xpath.xml.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSimpleExpression
extends AbstractSimpleExpression {
    public XmlSimpleExpression(String expression, boolean isFromRoot, Part[] parts) {
        super(expression, isFromRoot, parts);
    }

    @Override
    public boolean supportsXPathContext() {
        return true;
    }

    @Override
    public void pushXPathContext(Object node) throws XPathException {
        try {
            Document document = this.getDocument(node);
            DOMUtil.pushXPathContext(document, this.getExpression());
        }
        catch (XMLException xe) {
            throw new XPathException((Throwable)((Object)xe));
        }
    }

    @Override
    public void popXPathContext(Object node) throws XPathException {
        try {
            Document document = this.getDocument(node);
            XPathContext context = DOMUtil.getXPathContext(document);
            if (context != null && context.getExpression().equals(this.getExpression())) {
                DOMUtil.popXPathContext(document);
            }
        }
        catch (XMLException xe) {
            throw new XPathException((Throwable)((Object)xe));
        }
    }

    @Override
    protected XResult doEval(Object node, NamespaceContext namespaceContext) throws XPathException {
        Document document;
        XPathContext pathContext;
        if (!this.isFromRoot() && node instanceof Document && (pathContext = DOMUtil.getXPathContext(document = (Document)node)) != null && (node = pathContext.getContextNodes()) == null) {
            try {
                pathContext.createNodes();
            }
            catch (XMLException xe) {
                throw new XPathException((Throwable)((Object)xe));
            }
            node = pathContext.getContextNodes();
        }
        if (node == null) {
            throw new XPathException(new NullPointerException("Cannot evaluate an XPath on a null object"));
        }
        return super.doEval(node, namespaceContext);
    }

    @Override
    protected void doSetValue(Object node, Object value, NamespaceContext namespaceContext, boolean autoCreate) throws XPathException {
        Document document;
        XPathContext pathContext;
        if (node instanceof Document && (pathContext = DOMUtil.getXPathContext(document = (Document)node)) != null && (node = pathContext.getContextNodes()) == null && autoCreate) {
            try {
                pathContext.createNodes();
                node = ((NodeList)pathContext.getContextNodes()).item(0);
            }
            catch (XMLException xe) {
                throw new XPathException((Throwable)((Object)xe));
            }
        }
        super.doSetValue(node, value, namespaceContext, autoCreate);
    }

    @Override
    public boolean isReadOnly(Object node) {
        return false;
    }

    @Override
    public NamespaceContext resolveNamespaceContext(Object node, NamespaceContext ns) {
        NodeList l;
        if (node instanceof Node) {
            return Utils.resolveNamespaceContext((Node)node, ns);
        }
        if (node instanceof NodeList && (l = (NodeList)node).getLength() > 0) {
            return Utils.resolveNamespaceContext(l.item(0), ns);
        }
        return null;
    }

    @Override
    public Object getRootNode(Object node) {
        NodeList nl;
        if (node instanceof Node) {
            Node n = (Node)node;
            return DOMUtil.getOwnerDocument(n);
        }
        if (node instanceof NodeList && (nl = (NodeList)node).getLength() > 0) {
            return DOMUtil.getOwnerDocument(nl.item(0));
        }
        return node;
    }

    @Override
    protected Object createPart(Object node, Part part, NamespaceContext namespaceContext) throws XPathException {
        NodeListImpl nodeList;
        if (node instanceof NodeListImpl && (nodeList = (NodeListImpl)node).getLength() == 1) {
            node = nodeList.get(0);
        }
        if (node == null || !(node instanceof Node)) {
            throw new XPathException(null, "Error creating part:" + part.toString() + " Node must be of the type " + Node.class + " but it was :" + (node == null ? null : node.getClass()));
        }
        Node nodeObj = (Node)node;
        Document document = DOMUtil.getOwnerDocument(nodeObj);
        Node newNode = null;
        if (part instanceof AttributePart) {
            if (StringUtil.isEmpty((String)part.getPrefix())) {
                newNode = document.createAttribute(part.getName());
                nodeObj.getAttributes().setNamedItem(newNode);
            } else {
                String nsURI = XmlSimpleExpression.getNamespaceURI(namespaceContext, part.getPrefix());
                newNode = document.createAttributeNS(nsURI, part.getName());
                newNode.setPrefix(part.getPrefix());
                nodeObj.getAttributes().setNamedItem(newNode);
                this.setNamespaceAttr(newNode);
            }
        } else if (StringUtil.isEmpty((String)part.getPrefix())) {
            newNode = document.createElement(part.getName());
            nodeObj.appendChild(newNode);
        } else {
            String nsURI = XmlSimpleExpression.getNamespaceURI(namespaceContext, part.getPrefix());
            newNode = document.createElementNS(nsURI, part.getName());
            newNode.setPrefix(part.getPrefix());
            nodeObj.appendChild(newNode);
            this.setNamespaceAttr(newNode);
        }
        return newNode;
    }

    @Override
    protected void deletePart(Object node, Part part) {
        Node nodeObj;
        Node parentNode;
        NodeListImpl nodeList;
        if (node instanceof NodeListImpl && (nodeList = (NodeListImpl)node).getLength() == 1) {
            node = nodeList.get(0);
        }
        if (node instanceof Node && (parentNode = (nodeObj = (Node)node).getParentNode()) != null) {
            parentNode.removeChild(nodeObj);
        }
    }

    @Override
    protected Object evaluatePart(Object node, Part part, NamespaceContext namespaceContext) throws XPathException {
        if (node == null) {
            return null;
        }
        if (node instanceof NodeListImpl) {
            NodeListImpl result = new NodeListImpl(16);
            Iterator iter = ((NodeListImpl)node).iterator();
            while (iter.hasNext()) {
                Object res = this.evaluatePart(iter.next(), part, namespaceContext);
                if (res instanceof NodeListImpl) {
                    result.addAll((NodeListImpl)res);
                    continue;
                }
                if (res == null) continue;
                result.add(res);
            }
            return result.isEmpty() ? null : result;
        }
        Node nodeObj = (Node)node;
        if (part.getName().equals(".")) {
            return nodeObj;
        }
        if (part.getName().equals("..")) {
            return nodeObj.getParentNode();
        }
        if (part instanceof AttributePart) {
            if (node instanceof Element) {
                if (StringUtil.isEmpty((String)part.getPrefix())) {
                    return ((Element)node).getAttributeNode(part.getName());
                }
                String nsURI = XmlSimpleExpression.getNamespaceURI(namespaceContext, part.getPrefix());
                return ((Element)node).getAttributeNodeNS(nsURI, part.getName());
            }
            return null;
        }
        if (node instanceof Document) {
            Document doc = (Document)node;
            Element elem = doc.getDocumentElement();
            if (elem != null && XmlSimpleExpression.equalsName(namespaceContext, part, elem)) {
                return elem;
            }
            return null;
        }
        int index = 0;
        if (part instanceof IndexedElementPart && (index = ((IndexedElementPart)part).getIndex()) < 1) {
            String message = "Invalid predicate {0}, XPath predicates are 1-based.";
            message = StringUtil.format((String)message, (Object[])new Object[]{index});
            throw new IllegalArgumentException(message);
        }
        NodeList content = nodeObj.getChildNodes();
        Node resultObject = null;
        ArrayList resultList = null;
        int found = 0;
        int len = content.getLength();
        int i = 0;
        while (i < len) {
            Node childNode = content.item(i);
            if (XmlSimpleExpression.equalsName(namespaceContext, part, childNode) && (index == 0 || index == ++found)) {
                if (resultObject == null) {
                    resultObject = childNode;
                } else {
                    if (resultList == null) {
                        resultList = new NodeListImpl();
                        resultList.add(resultObject);
                    }
                    resultList.add(childNode);
                }
            }
            ++i;
        }
        if (resultList != null) {
            return resultList;
        }
        return resultObject;
    }

    @Override
    protected void setNodeValue(Object node, Object value) throws XPathException {
        if (node == null) {
            throw new XPathException(null, "Cannot set a value on an null XPath result");
        }
        if (node instanceof NodeListImpl) {
            NodeListImpl nodeList = (NodeListImpl)node;
            if (nodeList.getLength() == 1) {
                node = nodeList.get(0);
            } else {
                throw new XPathException(null, "Cannot set a value on a list of elements");
            }
        }
        Node nodeObj = (Node)node;
        String strValue = value == null ? "" : value.toString();
        DOMUtil.setTextValue(nodeObj, strValue);
    }

    @Override
    public boolean isValid(Object node) {
        return node instanceof Node || node instanceof NodeListImpl;
    }

    @Override
    public XResult wrapUp(Object node) throws XPathException {
        if (node == null) {
            return XResultUtils.emptyResult;
        }
        if (node instanceof Node) {
            return new XResultUtils.XMLNode((Node)node);
        }
        if (node instanceof NodeList) {
            NodeList nl = (NodeList)node;
            int len = nl.getLength();
            if (len == 0) {
                return XResultUtils.emptyResult;
            }
            if (len == 1) {
                return new XResultUtils.XMLNode(nl.item(0));
            }
            return new XResultUtils.XMLNodeList((NodeList)node);
        }
        throw new XPathException(null, "Internal error while executing simple path. Result:", node.toString());
    }

    protected void setNamespaceAttr(Node node) {
        if (node == null) {
            return;
        }
        try {
            Document document = node.getOwnerDocument();
            Element docElement = document.getDocumentElement();
            if (docElement == null) {
                return;
            }
            String prefix = node.getPrefix();
            String namespaceURI = node.getNamespaceURI();
            String qualifiedName = "xmlns:" + prefix;
            if (!docElement.hasAttribute(qualifiedName)) {
                Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", qualifiedName);
                attr.setNodeValue(namespaceURI);
                docElement.setAttributeNode(attr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Document getDocument(Object node) throws XMLException {
        if (node instanceof Document) {
            return (Document)node;
        }
        return ((Node)node).getOwnerDocument();
    }

    protected boolean equalsName(NamespaceContext namespaceContext, int idx, Node elem) {
        if (idx >= this.getPartCount()) {
            return false;
        }
        return XmlSimpleExpression.equalsName(namespaceContext, this.getPart(idx), elem);
    }

    protected static String getNamespaceURI(NamespaceContext namespaceContext, String nsPrefix) {
        if (namespaceContext != null) {
            return namespaceContext.getNamespaceURI(nsPrefix);
        }
        return null;
    }

    protected static boolean equalsName(NamespaceContext namespaceContext, Part part, Node elem) {
        if (elem == null) {
            return false;
        }
        String localName = elem.getLocalName();
        if (localName == null) {
            return StringUtil.equals((String)part.getName(), (String)elem.getNodeName());
        }
        if (StringUtil.equals((String)part.getName(), (String)localName)) {
            String elemNsURI = elem.getNamespaceURI();
            if (namespaceContext != null && !StringUtil.isEmpty((String)part.getPrefix())) {
                String partNsURI = XmlSimpleExpression.getNamespaceURI(namespaceContext, part.getPrefix());
                return StringUtil.equals((String)partNsURI, (String)elemNsURI);
            }
            return true;
        }
        return false;
    }
}

