/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.xpath;

import com.ibm.commons.util.profiler.Profiler;
import com.ibm.commons.util.profiler.ProfilerAggregator;
import com.ibm.commons.util.profiler.ProfilerType;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.xpath.XPathException;
import com.ibm.commons.xml.xpath.XPathExpression;
import java.util.List;

public abstract class AbstractExpression
implements XPathExpression {
    public static final ProfilerType profilerEval = new ProfilerType("XPath evaluation");
    public static final ProfilerType profilerSetValue = new ProfilerType("XPath set value");
    public static final ProfilerType profilerCreateNodes = new ProfilerType("XPath createNodes");
    protected String _expression;

    protected AbstractExpression(String expression) {
        this._expression = expression;
    }

    @Override
    public String getExpression() {
        return this._expression;
    }

    @Override
    public Class getType(Object node) throws XPathException {
        XResult result = this.eval(node, null);
        if (result != null) {
            switch (result.getValueType()) {
                case 0: {
                    return Void.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Number.class;
                }
                case 4: {
                    return Object.class;
                }
                case 5: {
                    return List.class;
                }
            }
        }
        return Void.class;
    }

    public abstract NamespaceContext resolveNamespaceContext(Object var1, NamespaceContext var2);

    @Override
    public final XResult eval(Object node, NamespaceContext namespaceContext) throws XPathException {
        if (Profiler.isEnabled()) {
            ProfilerAggregator agg = Profiler.startProfileBlock((ProfilerType)profilerEval, (String)this.getExpression());
            long ts = Profiler.getCurrentTime();
            try {
                XResult xResult = this.doEval(node, namespaceContext);
                return xResult;
            }
            finally {
                Profiler.endProfileBlock((ProfilerAggregator)agg, (long)ts);
            }
        }
        return this.doEval(node, namespaceContext);
    }

    @Override
    public final Object createNodes(Object node, NamespaceContext namespaceContext) throws XPathException {
        if (Profiler.isEnabled()) {
            ProfilerAggregator agg = Profiler.startProfileBlock((ProfilerType)profilerEval, (String)this.getExpression());
            long ts = Profiler.getCurrentTime();
            try {
                Object object = this.doCreateNodes(node, namespaceContext);
                return object;
            }
            finally {
                Profiler.endProfileBlock((ProfilerAggregator)agg, (long)ts);
            }
        }
        return this.doCreateNodes(node, namespaceContext);
    }

    @Override
    public final void setValue(Object node, Object value, NamespaceContext namespaceContext, boolean autoCreate) throws XPathException {
        if (Profiler.isEnabled()) {
            ProfilerAggregator agg = Profiler.startProfileBlock((ProfilerType)profilerEval, (String)this.getExpression());
            long ts = Profiler.getCurrentTime();
            try {
                this.doSetValue(node, value, namespaceContext, autoCreate);
            }
            finally {
                Profiler.endProfileBlock((ProfilerAggregator)agg, (long)ts);
            }
        } else {
            this.doSetValue(node, value, namespaceContext, autoCreate);
        }
    }

    protected abstract XResult doEval(Object var1, NamespaceContext var2) throws XPathException;

    protected abstract Object doCreateNodes(Object var1, NamespaceContext var2) throws XPathException;

    protected abstract void doSetValue(Object var1, Object var2, NamespaceContext var3, boolean var4) throws XPathException;
}

