/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml;

import com.ibm.commons.xml.DOMUtil;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.xpath.NodeListImpl;
import com.ibm.commons.xml.xpath.XPathException;
import com.ibm.commons.xml.xpath.XPathExpression;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathContext {
    private Document _doc;
    private XPathContext _parent;
    private XPathExpression _xPathExpression;
    private NodeListImpl _contextNodes;
    private boolean _isAbsolute;
    private Node _filteredContextNodes;

    public XPathContext(Document doc, XPathContext parent, String path) throws XMLException {
        this._doc = doc;
        this._parent = parent;
        this._xPathExpression = DOMUtil.createXPath(path);
        this._isAbsolute = this._xPathExpression.isFromRoot();
        this.compute();
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getExpression() {
        return this._xPathExpression.getExpression();
    }

    public void compute() throws XPathException {
        XResult r = null;
        if (!this._isAbsolute && this._parent != null) {
            NodeListImpl parentNodes = this._parent._contextNodes;
            if (parentNodes == null) {
                return;
            }
            r = this._xPathExpression.eval(parentNodes, null);
        } else {
            if (this._doc.getDocumentElement() == null) {
                return;
            }
            r = this._xPathExpression.eval(this._doc, null);
        }
        Iterator it = r.getNodeIterator();
        while (it.hasNext()) {
            if (this._contextNodes == null) {
                this._contextNodes = new NodeListImpl();
            }
            this._contextNodes.add(it.next());
        }
    }

    public XPathContext getParent() {
        return this._parent;
    }

    public Object getContextNodes() {
        if (this._filteredContextNodes != null) {
            return this._filteredContextNodes;
        }
        return this._contextNodes;
    }

    public int getContextNodesLength() {
        return this._contextNodes == null ? 0 : this._contextNodes.getLength();
    }

    public void setFilterIndex(int index) throws XMLException {
        if (index < 0) {
            this._filteredContextNodes = null;
        } else {
            if (--index < 0) {
                throw new XMLException(null, "XPath indexes start at 1");
            }
            if (this._contextNodes == null) {
                throw new XMLException(null, "Invalid XPath context: context is empty");
            }
            if (index >= this._contextNodes.getLength()) {
                throw new XMLException(null, "Invalid XPath context: index {0} too big", Integer.toString(index));
            }
            this._filteredContextNodes = this._contextNodes.item(index);
        }
    }

    public void setFilterNode(Node node) {
        this._filteredContextNodes = node;
    }

    public Node getUniqueContextNode() throws XMLException {
        if (this._filteredContextNodes != null) {
            return this._filteredContextNodes;
        }
        if (this._contextNodes == null) {
            throw new XMLException(null, "Invalid XPath context: context is empty");
        }
        if (this._contextNodes.getLength() > 1) {
            throw new XMLException(null, "Invalid XPath context: context contains more than one node");
        }
        return this._contextNodes.item(0);
    }

    public void createNodes() throws XMLException {
        if (this._contextNodes == null) {
            Object o;
            Node ctx = this._doc;
            if (!this._isAbsolute && this._parent != null) {
                this._parent.createNodes();
                ctx = this._parent.getUniqueContextNode();
            }
            if ((o = this._xPathExpression.createNodes(ctx, null)) != null) {
                this._contextNodes = new NodeListImpl();
                this._contextNodes.add(o);
            }
        }
    }
}

