/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListIterator
implements Iterator {
    private NodeList list;
    private Filter filter;
    private int length;
    private int current;
    public static Filter ELEMENT_FILTER = new Filter(){

        @Override
        public boolean accept(Node node) {
            return node.getNodeType() == 1;
        }
    };

    public NodeListIterator(NodeList list, Filter filter) {
        this.list = list;
        this.filter = filter;
        this.length = list.getLength();
        if (filter != null) {
            this.current = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.length) {
                Node n = list.item(i);
                if (filter.accept(n)) {
                    this.current = i;
                    break;
                }
                ++i;
            }
        }
    }

    public NodeListIterator(NodeList list) {
        this(list, null);
    }

    @Override
    public boolean hasNext() {
        return this.current < this.length;
    }

    public Object next() {
        if (this.current < this.length) {
            Node node = this.list.item(this.current++);
            if (this.filter != null) {
                while (this.current < this.length && !this.filter.accept(this.list.item(this.current))) {
                    ++this.current;
                }
            }
            return node;
        }
        throw new NoSuchElementException("Node iterator is empty");
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Cannot remove an item in a Node iterator");
    }

    public static interface Filter {
        public boolean accept(Node var1);
    }
}

