/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.spring.boot.U;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQConfigurationPropertiesTrace {
    private static Logger logger = LoggerFactory.getLogger(MQConfigurationPropertiesTrace.class);
    public static final String propertyTraceStatus = "com.ibm.msg.client.commonservices.trace.status";
    public static final String propertyTraceFileName = "com.ibm.msg.client.commonservices.trace.outputName";
    public static final String propertyTraceFileLimit = "com.ibm.msg.client.commonservices.trace.limit";
    public static final String propertyTraceFileCount = "com.ibm.msg.client.commonservices.trace.count";
    public static final String propertyParameterTrace = "com.ibm.msg.client.commonservices.trace.parameter";
    public static final String propertyMaxTraceBytes = "com.ibm.msg.client.commonservices.trace.maxBytes";
    public static final String propertyFFDCSuppress = "com.ibm.msg.client.commonservices.ffst.suppress";
    public static final String propertyFFDCSuppressProbeIDs = "com.ibm.msg.client.commonservices.ffst.suppress.probeIDs";
    public static final String propertyLogFileName = "com.ibm.msg.client.commonservices.log.outputName";
    private static final String propertyDiagnosticsFile = "com.ibm.mq.commonservices";
    private static final String propertyTraceDetail = "Diagnostics.Java.Trace.Detail";
    private static final String propertyTraceFile = "Diagnostics.Java.Trace.Destination.File";
    private static final String propertyTraceFilePath = "Diagnostics.Java.Trace.Destination.Pathname";
    private static final String propertyFFDCPath = "Diagnostics.Java.FFDC.Destination.Pathname";
    private static final String propertyErrorFileName = "Diagnostics.Java.Errors.Destination.Filename";
    private String status = "";
    private String maxTraceBytes = "";
    private String traceFileLimit = "";
    private String traceFileCount = "";
    private String parameterTrace = "";
    private String logFile = "";
    private String ffdcSuppress = "";
    private String ffstSuppress = "";
    private String ffdcSuppressProbeIDs = "";
    private String ffstSuppressProbeIDs = "";
    private String traceFile = "";
    private String ffdcPath = "";
    private String ffstPath = "";
    HashMap<String, String> setProps = new HashMap();
    private static File tempFile = null;

    public void setStatus(String status) {
        this.status = status.equalsIgnoreCase("true") || status.equalsIgnoreCase("ON") ? "ON" : "OFF";
    }

    public void setMaxTraceBytes(String maxTraceBytes) {
        this.maxTraceBytes = maxTraceBytes;
    }

    public void setTraceFileLimit(String traceFileLimit) {
        this.traceFileLimit = traceFileLimit;
    }

    public void setTraceFileCount(String traceFileCount) {
        this.traceFileCount = traceFileCount;
    }

    public void setParameterTrace(String parameterTrace) {
        this.parameterTrace = parameterTrace;
    }

    public void setFfdcSuppress(String ffdcSuppress) {
        this.ffdcSuppress = ffdcSuppress;
    }

    public void setFfdcSuppressProbeIDs(String ffdcSuppressProbeIDs) {
        this.ffdcSuppressProbeIDs = ffdcSuppressProbeIDs;
    }

    public void setFfstSuppress(String ffstSuppress) {
        this.ffdcSuppress = ffstSuppress;
    }

    public void setFfstSuppressProbeIDs(String ffstSuppressProbeIDs) {
        this.ffdcSuppressProbeIDs = ffstSuppressProbeIDs;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setTraceFile(String traceFile) {
        this.traceFile = traceFile;
    }

    public void setFFDCPath(String ffdcPath) {
        this.ffdcPath = ffdcPath;
    }

    public void setFFSTPath(String ffstPath) {
        this.ffdcPath = ffstPath;
    }

    private static synchronized void createTempFile() throws IOException {
        if (tempFile == null) {
            tempFile = File.createTempFile("ibmmqsbtc", ".tmp");
            tempFile.deleteOnExit();
        }
    }

    void setSysProp(String k, String v) {
        if (U.isNotNullOrEmpty(v)) {
            System.setProperty(k, v);
            this.setProps.put(k, v);
        }
    }

    void setDiagProp(String k, String v) {
        this.setSysProp(k, v);
    }

    void setProperties() {
        block5: {
            this.setProps.clear();
            if (U.isNotNullOrEmpty(this.ffdcPath)) {
                try {
                    MQConfigurationPropertiesTrace.createTempFile();
                    this.setSysProp(propertyDiagnosticsFile, tempFile.getAbsolutePath());
                    this.setDiagProp(propertyTraceFilePath, this.traceFile);
                    this.setDiagProp(propertyFFDCPath, this.ffdcPath);
                    this.setSysProp(propertyErrorFileName, this.logFile);
                    if (this.status.equalsIgnoreCase("ON")) {
                        this.setDiagProp(propertyTraceDetail, "high");
                        this.setDiagProp(propertyTraceFile, "enabled");
                        break block5;
                    }
                    this.setDiagProp(propertyTraceDetail, "low");
                    this.setDiagProp(propertyTraceFile, "disabled");
                }
                catch (IOException e) {
                    logger.error("Problem creating temporary file:", (Throwable)e);
                }
            } else {
                this.setSysProp(propertyTraceStatus, this.status);
                this.setSysProp(propertyTraceFileName, this.traceFile);
            }
        }
        this.setSysProp(propertyMaxTraceBytes, this.maxTraceBytes);
        this.setSysProp(propertyTraceFileLimit, this.traceFileLimit);
        this.setSysProp(propertyTraceFileCount, this.traceFileCount);
        this.setSysProp(propertyParameterTrace, this.parameterTrace.toUpperCase());
        this.setSysProp(propertyFFDCSuppress, this.ffdcSuppress);
        this.setSysProp(propertyFFDCSuppressProbeIDs, this.ffdcSuppressProbeIDs);
        this.setSysProp(propertyLogFileName, this.logFile);
    }

    public String getStatus() {
        return this.status;
    }

    public String getMaxTraceBytes() {
        return this.maxTraceBytes;
    }

    public String getTraceFileLimit() {
        return this.traceFileLimit;
    }

    public String getTraceFileCount() {
        return this.traceFileCount;
    }

    public String getParameterTrace() {
        return this.parameterTrace;
    }

    public String getFfdcSuppress() {
        return this.ffdcSuppress;
    }

    public String getFfdcSuppressProbeIDs() {
        return this.ffdcSuppressProbeIDs;
    }

    public String getFfstSuppress() {
        return this.ffstSuppress;
    }

    public String getFfstSuppressProbeIDs() {
        return this.ffstSuppressProbeIDs;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public String getFFDCPath() {
        return this.ffdcPath;
    }

    public String getFFSTPath() {
        return this.ffstPath;
    }

    public void traceProperties(Logger parentLogger) {
        if (!parentLogger.isTraceEnabled()) {
            return;
        }
        if (this.setProps.size() == 0) {
            parentLogger.trace("Trace Props Map: {}", (Object)"Empty");
        } else {
            parentLogger.trace("Trace Props Map:");
            ArrayList<String> ks = new ArrayList<String>(this.setProps.keySet());
            Collections.sort(ks);
            for (String s : ks) {
                parentLogger.trace("  {} : {}", (Object)s, (Object)this.setProps.get(s));
            }
        }
    }
}

