/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobilefirstplatform.serversdk.java.push;

public final class Target {
    private String[] deviceIds = null;
    private String[] userIds = null;
    private String[] platforms = null;
    private String[] tagNames = null;

    public final String[] getDeviceIds() {
        return this.deviceIds;
    }

    public final String[] getUserIds() {
        return this.userIds;
    }

    public final String[] getPlatforms() {
        return this.platforms;
    }

    public final String[] getTagNames() {
        return this.tagNames;
    }

    private Target(Builder builder) {
        this.deviceIds = builder.deviceIds;
        this.platforms = builder.platforms;
        this.tagNames = builder.tagNames;
        this.userIds = builder.userIds;
    }

    public static class Builder {
        private String[] deviceIds = null;
        private String[] userIds = null;
        private String[] platforms = null;
        private String[] tagNames = null;

        public final Builder deviceIds(String[] deviceIds) {
            this.deviceIds = deviceIds;
            return this;
        }

        public final Builder userIds(String[] userIds) {
            this.userIds = userIds;
            return this;
        }

        public final Builder tagNames(String[] tagNames) {
            this.tagNames = tagNames;
            return this;
        }

        public final Builder platforms(Platform[] platforms) {
            String[] platformArray = null;
            if (platforms != null && platforms.length > 0) {
                platformArray = new String[platforms.length];
                for (int i = 0; i < platforms.length; ++i) {
                    platformArray[i] = platforms[i].getValue();
                }
            }
            this.platforms = platformArray;
            return this;
        }

        public Target build() {
            return new Target(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Platform {
            APPLE("A"),
            GOOGLE("G"),
            WEBCHROME("WEB_CHROME"),
            WEBFIREFOX("WEB_FIREFOX"),
            WEBSAFARI("WEB_SAFARI"),
            APPEXTCHROME("APPEXT_CHROME");

            private final String platformCode;

            private Platform(String code) {
                this.platformCode = code;
            }

            public final String getValue() {
                return this.platformCode;
            }
        }
    }
}

