/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobilefirstplatform.serversdk.java.push;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public final class APNs {
    public static final Logger logger = Logger.getLogger(APNs.class.getName());
    private Integer badge;
    private String sound;
    private String iosActionKey;
    private JsonNode payload;
    private String interactiveCategory;
    private Builder.APNSNotificationType type;
    private String titleLocKey;
    private String locKey;
    private String launchImage;
    private String[] titleLocArgs;
    private String[] locArgs;
    private String subtitle;
    private String title;
    private String attachmentUrl;

    public final Integer getBadge() {
        return this.badge;
    }

    public final String getSound() {
        return this.sound;
    }

    public final String getIosActionKey() {
        return this.iosActionKey;
    }

    @JsonRawValue
    public final JsonNode getPayload() {
        return this.payload;
    }

    public final String getInteractiveCategory() {
        return this.interactiveCategory;
    }

    public final Builder.APNSNotificationType getType() {
        return this.type;
    }

    public final String getTitleLocKey() {
        return this.titleLocKey;
    }

    public final String getLocKey() {
        return this.locKey;
    }

    public final String getLaunchImage() {
        return this.launchImage;
    }

    public final String[] getTitleLocArgs() {
        return this.titleLocArgs;
    }

    public final String[] getLocArgs() {
        return this.locArgs;
    }

    public final String getSubtitle() {
        return this.subtitle;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getAttachmentUrl() {
        return this.attachmentUrl;
    }

    private APNs(Builder builder) {
        this.badge = builder.badge;
        this.interactiveCategory = builder.interactiveCategory;
        this.iosActionKey = builder.iosActionKey;
        this.payload = builder.payload;
        this.sound = builder.sound;
        this.titleLocKey = builder.titleLocKey;
        this.locKey = builder.locKey;
        this.launchImage = builder.launchImage;
        this.titleLocArgs = builder.titleLocArgs;
        this.locArgs = builder.locArgs;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.attachmentUrl = builder.attachmentUrl;
        this.type = builder.type;
    }

    public static class Builder {
        private Integer badge;
        private String sound;
        private String iosActionKey;
        private JsonNode payload;
        private String interactiveCategory;
        private APNSNotificationType type;
        private String titleLocKey;
        private String locKey;
        private String launchImage;
        private String[] titleLocArgs;
        private String[] locArgs;
        private String subtitle;
        private String title;
        private String attachmentUrl;

        public final Builder badge(Integer badge) {
            this.badge = badge;
            return this;
        }

        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final Builder iosActionKey(String iosActionKey) {
            this.iosActionKey = iosActionKey;
            return this;
        }

        public final Builder payload(JSONObject payload) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNodePayload = null;
            try {
                if (payload != null) {
                    jsonNodePayload = mapper.readTree(payload.toString());
                }
            }
            catch (JsonProcessingException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            this.payload = jsonNodePayload;
            return this;
        }

        public final Builder interactiveCategory(String interactiveCategory) {
            this.interactiveCategory = interactiveCategory;
            return this;
        }

        public final Builder type(APNSNotificationType type) {
            this.type = type;
            return this;
        }

        public final Builder titleLocKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public final Builder locKey(String locKey) {
            this.locKey = locKey;
            return this;
        }

        public final Builder launchImage(String launchImage) {
            this.launchImage = launchImage;
            return this;
        }

        public final Builder titleLocArgs(String[] titleLocArgs) {
            this.titleLocArgs = titleLocArgs;
            return this;
        }

        public final Builder locArgs(String[] locArgs) {
            this.locArgs = locArgs;
            return this;
        }

        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Builder attachmentUrl(String attachmentUrl) {
            this.attachmentUrl = attachmentUrl;
            return this;
        }

        public APNs build() {
            return new APNs(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum APNSNotificationType {
            DEFAULT,
            MIXED,
            SILENT;

        }
    }
}

