/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxASFException;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataInputStream
extends FilterInputStream {
    private InputStream is;
    private final int one = 1;
    private boolean usestrenc = false;
    private byte[] smint_buf = new byte[2];
    private byte[] int_buf = new byte[4];
    private byte[] lgint_buf = new byte[10];
    private byte[] long_buf = new byte[8];
    private IfxToJavaType ifxtojava = new IfxToJavaType();

    public IfxDataInputStream(InputStream i) {
        super(i);
        this.is = i;
    }

    public IfxDataInputStream(InputStream i, boolean encoption) {
        super(i);
        this.is = i;
        this.usestrenc = encoption;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    public byte readByte() throws IOException {
        int ch = this.is.read();
        return (byte)ch;
    }

    public int readFully(byte[] b) throws IOException {
        return this.readFully(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        return this.is.read(b, offset, length);
    }

    public int readFully(byte[] b, int offset, int length) throws IOException {
        int totalBytesRead;
        int bytesRead = 0;
        for (totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = this.is.read(b, offset + totalBytesRead, length - totalBytesRead);
            if (bytesRead >= 0) continue;
            throw new IOException();
        }
        return totalBytesRead;
    }

    public int readPadded(byte[] b, int offset, int length) throws IOException {
        int bytesRead = 0;
        bytesRead = this.readFully(b, offset, length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return bytesRead;
    }

    public int readPadded(byte[] b) throws IOException {
        int bytesRead = this.readFully(b, 0, b.length);
        if ((b.length & 1) >= 1) {
            this.read();
        }
        return bytesRead;
    }

    public int skipBytes(int n) throws IOException {
        int i = 0;
        while ((i += (int)this.is.skip(n - i)) < n) {
        }
        return n;
    }

    public int readInt() throws IOException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaInt(this.int_buf);
    }

    public String readChar() throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw IfxErrMsg.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        int rdlen = 0;
        int offset = 0;
        int newlen = b1.length;
        rdlen = this.readFully(b1, offset, newlen);
        newlen -= rdlen;
        offset += rdlen;
        if ((b1.length & 1) >= 1) {
            this.read();
        }
        return this.ifxtojava.IfxToJavaChar(b1, this.usestrenc);
    }

    public String readChar(String dbEnc) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw IfxErrMsg.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        int rdlen = 0;
        int offset = 0;
        int newlen = b1.length;
        rdlen = this.readFully(b1, offset, newlen);
        newlen -= rdlen;
        offset += rdlen;
        if ((b1.length & 1) >= 1) {
            this.read();
        }
        return this.ifxtojava.IfxToJavaChar(b1, dbEnc, this.usestrenc);
    }

    public Date readDate() throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaDate(this.int_buf);
    }

    public Timestamp readDateTime(short prec) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw IfxErrMsg.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDateTime(b1, prec);
    }

    public byte[] readRawDateTime(short prec) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw IfxErrMsg.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return b1;
    }

    public Interval readInterval(short prec) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw IfxErrMsg.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaInterval(b1, prec);
    }

    public BigDecimal readDecimal(short prec) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw IfxErrMsg.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDecimal(b1, prec);
    }

    public double readDouble(short prec) throws IOException, IfxASFException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaDouble(this.long_buf);
    }

    public float readReal(short prec) throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaReal(this.int_buf);
    }

    public short readSmallInt() throws IOException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        return IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
    }

    public short readShort() throws IOException {
        return this.readSmallInt();
    }

    public long readLongInt() throws IOException {
        this.readFully(this.lgint_buf, 0, this.lgint_buf.length);
        return IfxToJavaType.IfxToJavaLongInt(this.lgint_buf);
    }

    public long readLong() throws IOException {
        return this.readLongInt();
    }

    public long readLongBigint() throws IOException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaLongBigInt(this.long_buf);
    }
}

