/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class JavaToIfxType {
    public static final int IFX_INT_SIZE = 4;
    public static final int BYTESHIFT = 8;
    public static final int BYTEMASK = 255;
    public static final int IFX_LGINT_SIZE = 10;
    public static final int IFX_SMINT_SIZE = 2;
    public static final int IFX_SMFLOAT_SIZE = 4;
    public static final int IFX_LONG_SIZE = 8;
    public static final int IFX_DOUBLE_SIZE = 8;
    public static final int DefDblScale = 10;
    public static final int DefFltScale = 10;
    static final String defaultEncoding = "ISO8859_1";
    CharsetEncoder enc = null;
    CharsetEncoder defenc = null;
    static final String ENC_ISO2022CN = "ISO2022CN";
    static final String ENC_ISO2022CN_GB = "ISO2022CN_GB";
    public static final String NO_ENCODING = "NOENCODING";
    protected static final boolean TruncateFractSec = true;
    static final int NanosPerSecond = 1000000000;
    static final int MilliPerSecond = 1000;
    static final int SecondsPerMinute = 60;
    static final int SecondsPerHour = 3600;
    static final int SecondsPerDay = 86400;
    static final int MonthsPerYear = 12;

    public static byte[] JavaToIfxInt(int i) {
        byte[] b = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return b;
    }

    public byte[] JavaToIfxChar(String s, boolean usestrenc) throws UnsupportedEncodingException, SQLException {
        int x = s.length();
        byte[] b = new byte[x + 2];
        byte[] temp = this.getConvertedBytes(s, usestrenc);
        b[0] = (byte)(x >> 8 & 0xFF);
        b[1] = (byte)(x & 0xFF);
        System.arraycopy(temp, 0, b, 2, x);
        return b;
    }

    private byte[] getConvertedBytes(String s, boolean usestrenc) throws SQLException {
        return this.getConvertedBytes(s, usestrenc, defaultEncoding);
    }

    private byte[] getConvertedBytes(String s, boolean usestrenc, String encoding) throws SQLException {
        try {
            if (usestrenc) {
                return s.getBytes(encoding);
            }
            return this.doConversion(s, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw IfxErrMsg.getSQLException(-79783);
        }
    }

    public byte[] JavaToIfxChar(String s, String dbEnc, boolean usestrenc) throws UnsupportedEncodingException, SQLException {
        byte[] temp = null;
        temp = dbEnc != null ? (dbEnc.equals(NO_ENCODING) ? s.getBytes() : this.getConvertedBytes(s, usestrenc, dbEnc)) : this.getConvertedBytes(s, usestrenc);
        int x = temp.length;
        byte[] b = new byte[x + 2];
        b[0] = (byte)(x >> 8 & 0xFF);
        b[1] = (byte)(x & 0xFF);
        System.arraycopy(temp, 0, b, 2, x);
        return b;
    }

    public byte[] JavaToIfx4BytesChar(String s, boolean usestrenc) throws UnsupportedEncodingException, SQLException {
        int x = s.length();
        byte[] b = new byte[x + 4];
        byte[] temp = this.getConvertedBytes(s, usestrenc);
        b[0] = (byte)(x >> 24 & 0xFF);
        b[1] = (byte)(x >> 16 & 0xFF);
        b[2] = (byte)(x >> 8 & 0xFF);
        b[3] = (byte)(x & 0xFF);
        System.arraycopy(temp, 0, b, 4, x);
        return b;
    }

    public byte[] JavaToIfx4BytesChar(String s, String dbEnc, boolean usestrenc) throws UnsupportedEncodingException, SQLException {
        byte[] temp = null;
        temp = dbEnc != null ? (dbEnc.equals(NO_ENCODING) ? s.getBytes() : this.getConvertedBytes(s, usestrenc, dbEnc)) : this.getConvertedBytes(s, usestrenc);
        int x = temp.length;
        byte[] b = new byte[x + 4];
        b[0] = (byte)(x >> 24 & 0xFF);
        b[1] = (byte)(x >> 16 & 0xFF);
        b[2] = (byte)(x >> 8 & 0xFF);
        b[3] = (byte)(x & 0xFF);
        System.arraycopy(temp, 0, b, 4, x);
        return b;
    }

    public byte[] JavaToIfxVarChar(String s, String dbEnc, int leng, boolean usestrenc) throws UnsupportedEncodingException, SQLException {
        byte[] temp = null;
        temp = dbEnc != null ? this.getConvertedBytes(s, usestrenc, dbEnc) : this.getConvertedBytes(s, usestrenc);
        byte[] b = new byte[leng + 1];
        int x = temp.length;
        int y = Math.min(x, leng);
        b[0] = (byte)(y & 0xFF);
        System.arraycopy(temp, 0, b, 1, y);
        return b;
    }

    public byte[] JavaToIfxLvarchar(String s, String dbEnc, boolean usestrenc) throws UnsupportedEncodingException, SQLException {
        byte[] b = null;
        b = dbEnc != null ? this.getConvertedBytes(s, usestrenc, dbEnc) : this.getConvertedBytes(s, usestrenc);
        return b;
    }

    public static byte[] JavaToIfxDate(Date d) {
        int dtVal = IfxToJavaType.convertDateToDays(d);
        return JavaToIfxType.JavaToIfxInt(dtVal);
    }

    public static String convertNanosToFract(int nano) {
        char[] s = new char[5];
        double reducedNano = (double)nano / 10000.0 + 0.0;
        String st = Integer.toString((int)reducedNano);
        Decimal.charfill(s, 0, 4, '0');
        int minS = st.length() - 6;
        int j = 4;
        int i = st.length() - 1;
        while (i >= 0 && i >= minS) {
            s[j] = st.charAt(i);
            --i;
            --j;
        }
        return new String(s);
    }

    public static Decimal convertTimestampToDecimal(Timestamp t) {
        return JavaToIfxType.convertTimestampToDecimal(t, null);
    }

    public static Decimal convertTimestampToDecimal(Timestamp t, Calendar cal) {
        Calendar Cal = cal;
        if (Cal == null) {
            Cal = Calendar.getInstance();
        }
        Cal.setTime(t);
        int yr = Cal.get(1);
        int month = Cal.get(2) + 1;
        int day = Cal.get(5);
        int hour = Cal.get(11);
        int minute = Cal.get(12);
        int second = Cal.get(13);
        int nanos = t.getNanos();
        return new Decimal(yr, month, day, hour, minute, second, nanos / 10000);
    }

    public static Decimal convertTimeToDecimal(Time t) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(t);
        int hour = Cal.get(11);
        int minute = Cal.get(12);
        int second = Cal.get(13);
        return new Decimal(0, 0, 0, hour, minute, second, 0);
    }

    public static String convertIntervalToString(IntervalDF intrvl) {
        StringBuffer retval = new StringBuffer();
        short qual = intrvl.getQualifier();
        int start = Interval.getStartCode(qual);
        byte end = Interval.getEndCode(qual);
        int lfprec = intrvl.getLength() - (end - start);
        long secs = intrvl.getSeconds();
        long nans = intrvl.getNanoSeconds();
        if (secs < 0L || secs == 0L && nans < 0L) {
            retval.append("-");
            secs = -secs;
            nans = -nans;
        }
        int currentField = start;
        block6: while (end >= currentField) {
            int tmpInt;
            switch (currentField) {
                case 4: {
                    tmpInt = (int)Math.floor(secs / 86400L);
                    retval.append(JavaToIfxType.stringWithLFP(tmpInt, lfprec));
                    secs %= 86400L;
                    currentField += 2;
                    continue block6;
                }
                case 6: {
                    tmpInt = (int)Math.floor(secs / 3600L);
                    if (currentField == start) {
                        retval.append(JavaToIfxType.stringWithLFP(tmpInt, lfprec));
                    } else {
                        if (tmpInt < 10 && currentField != start) {
                            retval.append("0");
                        }
                        retval.append(String.valueOf(tmpInt));
                    }
                    secs %= 3600L;
                    currentField += 2;
                    continue block6;
                }
                case 8: {
                    tmpInt = (int)Math.floor(secs / 60L);
                    if (currentField == start) {
                        retval.append(JavaToIfxType.stringWithLFP(tmpInt, lfprec));
                    } else {
                        if (tmpInt < 10 && currentField != start) {
                            retval.append("0");
                        }
                        retval.append(String.valueOf(tmpInt));
                    }
                    secs %= 60L;
                    currentField += 2;
                    continue block6;
                }
                case 10: {
                    if (currentField == start) {
                        retval.append(JavaToIfxType.stringWithLFP((int)secs, lfprec));
                    } else {
                        if (secs < 10L && currentField != start) {
                            retval.append("0");
                        }
                        retval.append(String.valueOf(secs));
                    }
                    ++currentField;
                    continue block6;
                }
            }
            retval.append(".");
            tmpInt = 15 - end - 1 + 4;
            for (int i = 0; i <= tmpInt; ++i) {
                nans /= 10L;
            }
            retval.append(String.valueOf(nans));
            ++currentField;
        }
        return retval.toString();
    }

    public static Decimal convertIntervalToDecimal(IntervalDF intrvl) {
        byte[] b = new byte[20];
        boolean sign = false;
        int idx = 0;
        short qual = intrvl.getQualifier();
        int start = Interval.getStartCode(qual);
        int end = Interval.getEndCode(qual);
        int lfprec = intrvl.getLength() - (end - start);
        long secs = intrvl.getSeconds();
        long nans = intrvl.getNanoSeconds();
        if (secs < 0L || secs == 0L && nans < 0L) {
            sign = true;
            secs = -secs;
            nans = -nans;
        }
        if (start == 12) {
            start = 11;
        }
        int subField = 0;
        for (int currentField = start; end >= currentField; currentField += subField) {
            int loop;
            int mod;
            int tmpInt;
            switch (currentField) {
                case 4: {
                    tmpInt = (int)(secs / 86400L);
                    secs %= 86400L;
                    subField = 2;
                    break;
                }
                case 6: {
                    tmpInt = (int)(secs / 3600L);
                    secs %= 3600L;
                    subField = 2;
                    break;
                }
                case 8: {
                    tmpInt = (int)(secs / 60L);
                    secs %= 60L;
                    subField = 2;
                    break;
                }
                case 10: {
                    tmpInt = (int)secs;
                    subField = 1;
                    break;
                }
                default: {
                    tmpInt = 15 - end - 1 + 4;
                    for (int i = 0; i <= tmpInt; ++i) {
                        nans /= 10L;
                    }
                    for (tmpInt = end - currentField + 1; tmpInt > 0; tmpInt -= 2) {
                        mod = 1;
                        for (loop = tmpInt - 2; loop > 0; --loop) {
                            mod *= 10;
                        }
                        if (tmpInt == 1) {
                            nans *= 10L;
                        }
                        b[idx] = (byte)(nans / (long)mod);
                        nans %= (long)mod;
                        ++idx;
                    }
                    currentField += 10;
                }
            }
            if (currentField == start) {
                if (lfprec % 2 > 0) {
                    mod = 1;
                    for (loop = --lfprec; loop > 0; --loop) {
                        mod *= 10;
                    }
                    b[idx] = (byte)(tmpInt / mod);
                    tmpInt %= mod;
                    ++idx;
                }
                while (lfprec > 0) {
                    mod = 1;
                    for (loop = lfprec -= 2; loop > 0; --loop) {
                        mod *= 10;
                    }
                    b[idx] = (byte)(tmpInt / mod);
                    tmpInt %= mod;
                    ++idx;
                }
                continue;
            }
            if (currentField > end) continue;
            b[idx] = (byte)tmpInt;
            ++idx;
        }
        return new Decimal(sign, b, idx, intrvl.getQualifier());
    }

    private static String stringWithLFP(int value, int lfprec) {
        int len;
        String retval = "";
        String s = String.valueOf(value);
        for (int i = len = lfprec - s.length(); i > 0; --i) {
            retval = retval + "0";
        }
        retval = retval + s;
        return retval;
    }

    public static String convertIntervalToString(IntervalYM intrvl) {
        String s = "";
        StringBuffer sb = new StringBuffer();
        short qual = intrvl.getQualifier();
        byte start = Interval.getStartCode(qual);
        byte end = Interval.getEndCode(qual);
        int lfprec = intrvl.getLength() - (end - start);
        long months = intrvl.getMonths();
        if (months < 0L) {
            months = -months;
            sb.append("-");
        }
        if (start == 2) {
            sb.append(JavaToIfxType.stringWithLFP((int)months, lfprec));
        } else {
            int years = (int)(months / 12L);
            sb.append(JavaToIfxType.stringWithLFP(years, lfprec));
            if (end == 2) {
                s = String.valueOf(months % 12L);
                if (s.length() == 1) {
                    sb.append("0");
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static Decimal convertIntervalToDecimal(IntervalYM intrvl) {
        byte[] b = new byte[20];
        boolean sign = false;
        int idx = 0;
        short qual = intrvl.getQualifier();
        byte start = Interval.getStartCode(qual);
        byte end = Interval.getEndCode(qual);
        int lfprec = intrvl.getLength() - (end - start);
        long months = intrvl.getMonths();
        if (months < 0L) {
            sign = true;
            months = -months;
        }
        if (start == 2) {
            int loop;
            int mod;
            if (lfprec % 2 > 0) {
                mod = 1;
                for (loop = --lfprec; loop > 0; --loop) {
                    mod *= 10;
                }
                b[idx] = (byte)(months / (long)mod);
                months %= (long)mod;
                ++idx;
            }
            while (lfprec > 0) {
                mod = 1;
                for (loop = lfprec -= 2; loop > 0; --loop) {
                    mod *= 10;
                }
                b[idx] = (byte)(months / (long)mod);
                months %= (long)mod;
                ++idx;
            }
        } else {
            int loop;
            int mod;
            int years = (int)(months / 12L);
            if (lfprec % 2 > 0) {
                mod = 1;
                for (loop = --lfprec; loop > 0; --loop) {
                    mod *= 10;
                }
                b[idx] = (byte)(years / mod);
                years %= mod;
                ++idx;
            }
            while (lfprec > 0) {
                mod = 1;
                for (loop = lfprec -= 2; loop > 0; --loop) {
                    mod *= 10;
                }
                b[idx] = (byte)(years / mod);
                years %= mod;
                ++idx;
            }
            if (end == 2) {
                b[idx] = (byte)(months % 12L);
                ++idx;
            }
        }
        return new Decimal(sign, b, idx, intrvl.getQualifier());
    }

    public static byte[] JavaToIfxDateTime(Timestamp t) {
        return JavaToIfxType.JavaToIfxDateTime(t, null);
    }

    public static byte[] JavaToIfxDateTime(Timestamp t, Calendar cal) {
        return JavaToIfxType.convertTimestampToDecimal(t, cal).javaToIfx();
    }

    public static byte[] JavaToIfxDateTime(Time t) {
        return JavaToIfxType.convertTimeToDecimal(t).javaToIfx();
    }

    public static byte[] JavaToIfxInterval(IntervalDF t) {
        byte[] buf = JavaToIfxType.convertIntervalToDecimal(t).javaToIfx();
        return buf;
    }

    public static byte[] JavaToIfxInterval(IntervalYM t) {
        byte[] buf = JavaToIfxType.convertIntervalToDecimal(t).javaToIfx();
        return buf;
    }

    public static final byte[] JavaToIfxDecimalNull(short qual) {
        byte dgt_len = (byte)(qual >> 8 & 0xFF);
        byte TU_end = (byte)(qual & 0xF);
        byte len = (byte)((dgt_len + (TU_end & 1) + 1) / 2);
        byte[] ret = new byte[len + 1];
        return ret;
    }

    public static final byte[] JavaToIfxDecimal(BigDecimal n) {
        Decimal d;
        byte[] b = new byte[18];
        if (n == null) {
            for (int k = 0; k < 18; ++k) {
                b[k] = 0;
            }
            d = new Decimal(b);
        } else {
            d = new Decimal(n);
        }
        return d.javaToIfx();
    }

    public static final byte[] JavaToIfxDouble(Double d) {
        return JavaToIfxType.JavaToIfxDouble((double)d);
    }

    public static final byte[] JavaToIfxDouble(double d) {
        byte[] b = new byte[8];
        long val = Double.doubleToLongBits(d);
        b[0] = (byte)(val >> 56 & 0xFFL);
        b[1] = (byte)(val >> 48 & 0xFFL);
        b[2] = (byte)(val >> 40 & 0xFFL);
        b[3] = (byte)(val >> 32 & 0xFFL);
        b[4] = (byte)(val >> 24 & 0xFFL);
        b[5] = (byte)(val >> 16 & 0xFFL);
        b[6] = (byte)(val >> 8 & 0xFFL);
        b[7] = (byte)(val & 0xFFL);
        return b;
    }

    public static final byte[] JavaToIfxReal(Float f) {
        return JavaToIfxType.JavaToIfxReal(f.floatValue());
    }

    public static byte[] JavaToIfxReal(float f) {
        int val = Float.floatToIntBits(f);
        return JavaToIfxType.JavaToIfxInt(val);
    }

    public static byte[] JavaToIfxSmallInt(short s) {
        byte[] b = new byte[]{(byte)(s >> 8), (byte)s};
        return b;
    }

    public static byte[] JavaToIfxLongInt(long l) {
        byte[] b = new byte[10];
        short sign = 1;
        if (l < 0L) {
            sign = -1;
            l = -l;
        }
        byte[] bSign = JavaToIfxType.JavaToIfxSmallInt(sign);
        System.arraycopy(bSign, 0, b, 0, 2);
        long i0 = l & 0xFFFFFFFFL;
        byte[] bInt = JavaToIfxType.JavaToIfxInt((int)i0);
        System.arraycopy(bInt, 0, b, 2, 4);
        int i1 = (int)(l >> 32);
        byte[] bUInt = JavaToIfxType.JavaToIfxInt(i1);
        System.arraycopy(bUInt, 0, b, 6, 4);
        return b;
    }

    private byte[] doConversion(String str, String dbEncode) throws SQLException {
        byte[] gbBytes = null;
        CharsetEncoder cenc = null;
        if (!dbEncode.equals(defaultEncoding)) {
            if (this.enc == null) {
                this.enc = Charset.forName(dbEncode).newEncoder();
            }
            cenc = this.enc;
        } else {
            if (this.defenc == null) {
                this.defenc = Charset.forName(dbEncode).newEncoder();
            }
            cenc = this.defenc;
        }
        cenc.reset();
        cenc.onMalformedInput(CodingErrorAction.REPORT);
        cenc.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            ByteBuffer bb = cenc.encode(CharBuffer.wrap(str));
            gbBytes = JavaToIfxType.copyToByteArray(bb.array(), bb.limit());
        }
        catch (CharacterCodingException e) {
            throw IfxErrMsg.getSQLException(e, -23103);
        }
        return gbBytes;
    }

    private static byte[] copyToByteArray(byte[] a, int l) {
        byte[] b = new byte[l];
        System.arraycopy(a, 0, b, 0, Math.min(l, a.length));
        return b;
    }

    public static byte[] JavaToIfxLongBigInt(long val) {
        byte[] b = new byte[]{(byte)(val >> 56), (byte)(val >> 48), (byte)(val >> 40), (byte)(val >> 32), (byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
        return b;
    }
}

