/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.util.AdvancedProperties;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class AdvancedUppercaseProperties
extends AdvancedProperties {
    private static final long serialVersionUID = 1L;

    public AdvancedUppercaseProperties() {
    }

    public AdvancedUppercaseProperties(File fileLocation) throws IOException {
        super(fileLocation);
    }

    public AdvancedUppercaseProperties(File fileLocation, Properties prop) throws IOException {
        super(fileLocation, AdvancedUppercaseProperties.uppercaseEntries(prop));
    }

    public AdvancedUppercaseProperties(Properties prop) {
        super(AdvancedUppercaseProperties.uppercaseEntries(prop));
    }

    private static Properties uppercaseEntries(Map<? extends Object, ? extends Object> p) {
        if (p == null) {
            return null;
        }
        Properties upperCased = new Properties();
        for (Map.Entry<? extends Object, ? extends Object> entry : p.entrySet()) {
            upperCased.setProperty(entry.getKey().toString().toUpperCase(), entry.getValue().toString());
        }
        return upperCased;
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(key.toUpperCase());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return super.getProperty(key.toUpperCase(), defaultValue);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return super.put(key.toString().toUpperCase(), value);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        for (Map.Entry<? extends Object, ? extends Object> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(key.toUpperCase(), value);
    }
}

