/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxOutputStream;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;

public class IfxTmpFile {
    private File tempFile = null;
    private String fileName = null;
    private int refCount = 0;
    private String locale = null;

    IfxTmpFile(IfxConnection conn) throws SQLException {
        this.setConnection(conn);
        try {
            File tmpf;
            String tmpDirName = conn.getJDBCTempDir();
            if (tmpDirName == null || tmpDirName.length() == 0) {
                tmpDirName = System.getProperty("user.dir");
            }
            final File tmpDir = new File(tmpDirName);
            this.tempFile = tmpf = (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File tmpfDo = File.createTempFile("IfxTmpFile_", "", tmpDir);
                    return tmpfDo;
                }
            });
            if (tmpf != null) {
                this.fileName = tmpf.getPath();
                ((IfxSqliConnect)conn).addToFileList(this.tempFile);
            }
        }
        catch (Exception e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.locale);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected synchronized int incRefCount() {
        ++this.refCount;
        return this.refCount;
    }

    protected synchronized void close() {
        if (this.refCount == 0) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        File fd = new File(IfxTmpFile.this.fileName);
                        fd.delete();
                        return null;
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            --this.refCount;
        }
    }

    private void setConnection(IfxConnection conn) {
        if (conn != null) {
            this.locale = conn.getclLocale();
        }
    }

    int length() throws Exception {
        final File tempFileDo = this.tempFile;
        Integer length = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                Integer lengthDo = (int)tempFileDo.length();
                return lengthDo;
            }
        });
        return length;
    }

    IfxInputStream getInputStream() throws Exception {
        final IfxTmpFile thisDo = this;
        IfxInputStream tmpStream = (IfxInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                IfxInputStream tmpStreamDo = new IfxInputStream(thisDo);
                IfxTmpFile.this.incRefCount();
                return tmpStreamDo;
            }
        });
        return tmpStream;
    }

    IfxOutputStream getOutputStream() throws Exception {
        final IfxTmpFile thisDo = this;
        IfxOutputStream tmpStream = (IfxOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                IfxOutputStream tmpStreamDo = new IfxOutputStream(thisDo);
                IfxTmpFile.this.incRefCount();
                return tmpStreamDo;
            }
        });
        return tmpStream;
    }
}

