/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxUDT;
import com.informix.jdbc.IfxUDTInput;
import com.informix.json.JSON;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;

public class IfxBSONObject
extends IfxUDT
implements SQLData,
BSONObject {
    protected byte[] bsonObjectBytes = null;
    protected BSONObject bsonObject = null;
    protected int bsonObjectHashCode = 0;

    public IfxBSONObject() {
        this.setExtendedId(26);
        this.bsonObjectBytes = null;
        this.bsonObject = null;
        this.bsonObjectHashCode = 0;
    }

    public IfxBSONObject(byte[] bytes) {
        this(bytes, false);
    }

    public IfxBSONObject(byte[] bytes, boolean copyBytes) {
        this.setExtendedId(26);
        if (copyBytes) {
            this.bsonObjectBytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.bsonObjectBytes, 0, bytes.length);
        } else {
            this.bsonObjectBytes = bytes;
        }
        this.bsonObject = null;
        this.bsonObjectHashCode = 0;
    }

    public IfxBSONObject(BSONObject bsonObject) {
        this.setExtendedId(26);
        this.bsonObject = bsonObject;
        this.bsonObjectHashCode = this.bsonObject.hashCode();
        this.bsonObjectBytes = null;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return "bson";
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        this.unsafeSetBSONObject(null);
        IfxUDTInput input = (IfxUDTInput)stream;
        this.bsonObjectBytes = input.readBytes(input.length());
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        this.ensureBsonObjectBytes();
        if (this.bsonObjectBytes == null) {
            throw new NullPointerException("the BSON byte array must not be null");
        }
        stream.writeBytes(this.bsonObjectBytes);
    }

    protected void ensureBsonObjectBytes() {
        if (this.bsonObjectBytes == null) {
            if (this.bsonObject == null) {
                this.unsafeSetBSONObject(new BasicBSONObject());
            }
            this.bsonObjectBytes = new BasicBSONEncoder().encode(this.bsonObject);
        } else if (this.bsonObject != null && this.bsonObjectHashCode != this.bsonObject.hashCode()) {
            this.bsonObjectBytes = new BasicBSONEncoder().encode(this.bsonObject);
            this.bsonObjectHashCode = this.bsonObject.hashCode();
        }
    }

    protected void ensureBsonObject() {
        if (this.bsonObject == null) {
            if (this.bsonObjectBytes != null) {
                this.unsafeSetBSONObject(new BasicBSONDecoder().readObject(this.bsonObjectBytes));
            } else {
                this.unsafeSetBSONObject(new BasicBSONObject());
            }
        }
    }

    public byte[] getBytes() {
        this.ensureBsonObjectBytes();
        return this.bsonObjectBytes;
    }

    public void setBytes(byte[] bytes) {
        this.unsafeSetBSONObject(null);
        this.bsonObjectBytes = bytes;
    }

    public void setBSONObject(BSONObject bsonObject) {
        if (bsonObject == null) {
            throw new NullPointerException("The bsonObject must not be null");
        }
        this.unsafeSetBSONObject(bsonObject);
        this.bsonObjectBytes = null;
    }

    protected void unsafeSetBSONObject(BSONObject bsonObject) {
        this.bsonObject = bsonObject;
        this.bsonObjectHashCode = bsonObject == null ? 0 : bsonObject.hashCode();
    }

    public static IfxBSONObject ensureIfxBSONObject(Object o) {
        if (o == null) {
            throw new NullPointerException("The object must not be null");
        }
        if (o instanceof IfxBSONObject) {
            return (IfxBSONObject)o;
        }
        if (o instanceof BSONObject) {
            return new IfxBSONObject((BSONObject)o);
        }
        throw new IllegalArgumentException(MessageFormat.format("The specified object is not of type {0} and does not implement the interface {1}", IfxBSONObject.class.getSimpleName(), BSONObject.class.getSimpleName()));
    }

    @Override
    public String toString() {
        this.ensureBsonObject();
        StringBuilder builder = new StringBuilder();
        builder.append(IfxBSONObject.class.getSimpleName());
        builder.append(" ");
        builder.append(JSON.serialize(this.bsonObject));
        return builder.toString();
    }

    @Override
    public Object put(String key, Object v) {
        this.ensureBsonObject();
        this.bsonObjectBytes = null;
        return this.bsonObject.put(key, v);
    }

    @Override
    public void putAll(BSONObject o) {
        this.ensureBsonObject();
        this.bsonObjectBytes = null;
        this.bsonObject.putAll(o);
    }

    @Override
    public void putAll(Map m) {
        this.ensureBsonObject();
        this.bsonObjectBytes = null;
        this.bsonObject.putAll(m);
    }

    @Override
    public Object get(String key) {
        this.ensureBsonObject();
        return this.bsonObject.get(key);
    }

    @Override
    public Map<String, Object> toMap() {
        this.ensureBsonObject();
        return this.bsonObject.toMap();
    }

    @Override
    public Object removeField(String key) {
        this.ensureBsonObject();
        this.bsonObjectBytes = null;
        return this.bsonObject.removeField(key);
    }

    @Override
    @Deprecated
    public boolean containsKey(String s) {
        this.ensureBsonObject();
        return this.bsonObject.containsKey(s);
    }

    @Override
    public boolean containsField(String s) {
        this.ensureBsonObject();
        return this.bsonObject.containsField(s);
    }

    @Override
    public Set<String> keySet() {
        this.ensureBsonObject();
        return this.bsonObject.keySet();
    }

    public int hashCode() {
        if (this.bsonObject != null) {
            return this.bsonObject.hashCode();
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BSONObject) {
            this.ensureBsonObject();
            return this.bsonObject.equals(o);
        }
        return false;
    }
}

