/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.spring.boot;

import com.ibm.db2.jcc.DB2SimpleDataSource;
import com.ibm.db2.jcc.DB2XADataSource;
import com.ibm.db2.spring.boot.Db2ConfigurationProperties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={Db2ConfigurationProperties.class})
public class Db2AutoConfiguration {
    @Autowired
    private Db2ConfigurationProperties config;

    @Bean
    @ConfigurationProperties(prefix="db2")
    @ConditionalOnMissingBean(value={DB2XADataSource.class})
    public XADataSource getXADataSource() throws ClassNotFoundException {
        this.loadDb2DriverJar();
        DB2XADataSource xaDataSource = new DB2XADataSource();
        this.setProperties(xaDataSource);
        return xaDataSource;
    }

    @Bean
    @ConfigurationProperties(prefix="db2")
    @ConditionalOnMissingBean(value={DB2SimpleDataSource.class})
    public DataSource getDB2SimpleDataSource() throws ClassNotFoundException {
        this.loadDb2DriverJar();
        DB2SimpleDataSource dataSource = new DB2SimpleDataSource();
        this.setProperties(dataSource);
        return dataSource;
    }

    private void setProperties(Object ds) {
        ConfigurablePropertyAccessor propertyAccessor = PropertyAccessorFactory.forDirectFieldAccess((Object)ds);
        propertyAccessor.setPropertyValue("driverType", (Object)new Integer(4));
        if (this.config.getServerName() != null) {
            propertyAccessor.setPropertyValue("serverName", (Object)this.config.getServerName());
        }
        if (this.config.getPortNumber() != null) {
            try {
                propertyAccessor.setPropertyValue("portNumber", (Object)new Integer(Integer.parseInt(this.config.getPortNumber())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.config.getDatabaseName() != null) {
            propertyAccessor.setPropertyValue("databaseName", (Object)this.config.getDatabaseName());
        }
        if (this.config.getUser() != null) {
            propertyAccessor.setPropertyValue("user", (Object)this.config.getUser());
        }
        if (this.config.getPassword() != null) {
            propertyAccessor.setPropertyValue("password", (Object)this.config.getPassword());
        }
        if (this.config.getTraceFile() != null) {
            propertyAccessor.setPropertyValue("traceFile", (Object)this.config.getTraceFile());
        }
        if (this.config.getTraceLevel() != null) {
            try {
                propertyAccessor.setPropertyValue("traceLevel", (Object)new Integer(Integer.parseInt(this.config.getTraceLevel())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.config.getTraceOption() != null) {
            try {
                propertyAccessor.setPropertyValue("traceOption", (Object)new Integer(Integer.parseInt(this.config.getTraceOption())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.config.getTraceFileSize() != null) {
            try {
                propertyAccessor.setPropertyValue("traceFileSize", (Object)new Integer(Integer.parseInt(this.config.getTraceFileSize())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.config.getTraceFileCount() != null) {
            try {
                propertyAccessor.setPropertyValue("traceFileCount", (Object)new Integer(Integer.parseInt(this.config.getTraceFileCount())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.config.getEnableSysplexWLB() != null) {
            try {
                propertyAccessor.setPropertyValue("enableSysplexWLB", (Object)new Boolean(Boolean.parseBoolean(this.config.getEnableSysplexWLB())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void loadDb2DriverJar() throws ClassNotFoundException {
        Class.forName("com.ibm.db2.jcc.DB2Driver");
    }
}

