/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.trace;

import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDataSourcePool;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.monitor.MonitorAgentImpl;
import com.ibm.db2.cmx.internal.monitor.PeriodicTask;
import com.ibm.db2.cmx.runtime.Data;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.proxy.PDQProxy;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataPrintWriter;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataLogger {
    private static String pmrStampingStr_ = null;
    public static final String COMPONENT_NAME = "[pdq]";
    public static final String PMR_STAMP_EYECATCHER = "PDQ PMR Stamping Eyecatcher";
    private static final String END_PMR_STAMP = "End PDQ PMR Stamping Eyecatcher";
    private static final int MAX_PMR_STAMP_LINE_LEN = 70;
    private static StringBuffer stringBuffForPMRStamp_ = new StringBuffer();
    private static int pmrStampCurrentLineLen_ = 0;
    public static final String warningMessagePrefix = Messages.getText("MSG_WARN", new Object[0]) + "  ";
    static Hashtable<String, DataPrintWriter> printWriters = new Hashtable();
    private static final String locationInUserApplicationPrefixMessageNoMethodName_;

    private DataLogger() {
    }

    public static void enter(Logger logger, Object object, String string) {
        logger.entering(DataLogger.getShortName(object), string, null);
    }

    public static void sqlOriginal(Logger logger, Data data, String string, String string2) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        logger.logp(Level.FINER, DataLogger.getShortName(data), string, "Original SQL: " + string2);
    }

    public static void sql(Logger logger, Data data, String string, String string2) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        logger.logp(Level.FINER, DataLogger.getShortName(data), string, "SQL         : " + string2);
    }

    public static void exit(Logger logger, Object object, String string, Object object2) {
        if (object2 != null && object2 instanceof PDQProxy) {
            object2 = DataLogger.getShortName(object2);
        }
        logger.exiting(DataLogger.getShortName(object), string, object2);
    }

    public static void throwing(Logger logger, Data data, String string, Throwable throwable) {
        if (throwable != null) {
            throwable.getMessage();
        }
        logger.throwing(DataLogger.getShortName(data), string, throwable);
    }

    public static String getShortName(Object object) {
        if (object == null) {
            return "null";
        }
        int n2 = System.identityHashCode(object);
        int n3 = object.hashCode();
        String string = "@" + Integer.toHexString(n2);
        if (n2 != n3) {
            string = string + ":" + Integer.toHexString(n3);
        }
        return object.getClass().getSimpleName() + string;
    }

    public static DataPrintWriter getPrintWriter(String string) throws Exception {
        return DataLogger.getPrintWriter(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataPrintWriter getPrintWriter(String string, boolean bl2) throws Exception {
        Hashtable<String, DataPrintWriter> hashtable = printWriters;
        synchronized (hashtable) {
            DataPrintWriter dataPrintWriter = printWriters.get(string);
            if (dataPrintWriter == null) {
                OutputStream outputStream = DataProperties.runningUnderSecurityManager_ ? (OutputStream)AccessController.doPrivileged(DataLogger.getFileAsBufferedOutputStreamPriv(string, bl2)) : DataLogger.getFileAsBufferedOutputStream(string, bl2);
                dataPrintWriter = new DataPrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                printWriters.put(string, dataPrintWriter);
            }
            return dataPrintWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAndRemoveDataPrintWriter(DataPrintWriter dataPrintWriter) {
        Hashtable<String, DataPrintWriter> hashtable = printWriters;
        synchronized (hashtable) {
            dataPrintWriter.closeDataPrintWriter();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, DataPrintWriter> object : printWriters.entrySet()) {
                arrayList.add(object.getKey());
            }
            for (String string : arrayList) {
                printWriters.remove(string);
            }
        }
    }

    private static String getParamInfo(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Object[]) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DataLogger.getShortName(object));
            stringBuilder.append(':');
            stringBuilder.append("[");
            for (Object object2 : (Object[])object) {
                stringBuilder.append(DataLogger.getParamInfo(object2));
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        String string = String.valueOf(object);
        if (string.startsWith(object.getClass().getName() + "@")) {
            return DataLogger.getShortName(object);
        }
        return DataLogger.getShortName(object) + ":" + string;
    }

    public static void logInfo(Logger logger, Data data, String string, String string2, Object ... objectArray) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" - Info:");
        if (objectArray != null) {
            for (int i10 = 0; i10 < objectArray.length; ++i10) {
                stringBuilder.append(" [");
                stringBuilder.append(DataLogger.getParamInfo(objectArray[i10]));
                stringBuilder.append("]");
            }
        }
        logger.logp(Level.FINEST, DataLogger.getShortName(data), string, stringBuilder.toString());
    }

    public static void logInfo(Logger logger, Data data, String string, String string2) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        logger.logp(Level.FINEST, DataLogger.getShortName(data), string, string2);
    }

    public static void logSplRegWithConApi(Logger logger, Object object, String string, String string2, String string3) {
        if (!logger.isLoggable(Level.FINE) || logger.isLoggable(Level.FINER)) {
            return;
        }
        String string4 = DataLogger.getLocationInUserApplicationMessage();
        String string5 = warningMessagePrefix + Messages.getText("MSG_PROFILER_JCC_WARN_REGISTER_SET_CONNECTION_API2", "pureQuery Runtime", string2, string3, string4);
        logger.logp(Level.FINE, DataLogger.getShortName(object), string, string5);
    }

    public static void logActiveBeans(Logger logger, MonitorAgentImpl monitorAgentImpl, PeriodicTask periodicTask) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        monitorAgentImpl.logActiveBeans(logger);
        periodicTask.logActiveBeans(logger);
    }

    public static void logControlDataSource(Logger logger, Object object, String string, ControlDataSourceImpl controlDataSourceImpl) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.append("ControlDataSource:: logicalName: " + controlDataSourceImpl.getLogicalName() + " monitoredDatabaseServerName: " + controlDataSourceImpl.getMonitoredServerName() + " monitoredDatabasePort: " + controlDataSourceImpl.getMonitoredPortNumber() + " monitoredDatabaseName: " + controlDataSourceImpl.getMonitoredDatabaseName());
        printWriter.append(" defaults: ");
        if (controlDataSourceImpl.getDefaults() != null) {
            controlDataSourceImpl.getDefaults().list(printWriter);
        } else {
            printWriter.append("null");
        }
        printWriter.append(" overrides: ");
        if (controlDataSourceImpl.getOverrides() != null) {
            controlDataSourceImpl.getOverrides().list(printWriter);
        } else {
            printWriter.append("null");
        }
        printWriter.flush();
        logger.logp(Level.FINE, DataLogger.getShortName(object), string, charArrayWriter.toString());
    }

    public static void logTrappedMonitoringException(Logger logger, Object object, String string, Throwable throwable, String string2) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        throwable.getMessage();
        logger.logp(Level.FINEST, DataLogger.getShortName(object), string, "MONITOR WARNING: " + (string2 == null ? "" : string2 + ": ") + "Monitor trapped the following: " + throwable + " Message: " + throwable.getMessage() + " Cause: " + throwable.getCause(), throwable);
    }

    public static void logTrappedMonitoringExceptionDebug(Logger logger, Object object, String string, Throwable throwable, String string2) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        throwable.getMessage();
        logger.logp(Level.FINE, DataLogger.getShortName(object), string, "MONITOR WARNING: " + (string2 == null ? "" : string2 + ": ") + "Monitor trapped the following: " + throwable + " Message: " + throwable.getMessage() + " Cause: " + throwable.getCause(), throwable);
    }

    public static void logTrappedException(Logger logger, Object object, String string, Throwable throwable, String string2) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        throwable.getMessage();
        logger.logp(Level.FINEST, DataLogger.getShortName(object), string, "WARNING: " + (string2 == null ? "" : string2 + ": ") + "Trapped the following: " + throwable + " Message: " + throwable.getMessage() + " Cause: " + throwable.getCause(), throwable);
    }

    public static void logMonitorMessage(Logger logger, Object object, String string, String string2) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        logger.logp(Level.FINER, DataLogger.getShortName(object), string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logRuntimeMemoryUsage(Logger logger) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        long l10 = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        long l11 = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Runtime.getRuntime().totalMemory();
            }
        });
        long l12 = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Runtime.getRuntime().maxMemory();
            }
        });
        logger.fine("JVM Free Memory = " + l10);
        logger.fine("JVM Total Memory = " + l11);
        logger.fine("JVM Max Memory = " + l12);
        Map<String, ControlDataSourceImpl> map = ControlDataSourcePool.getInstance().getPool();
        logger.fine("Active Control DataSources follow:");
        Map<String, ControlDataSourceImpl> map2 = map;
        synchronized (map2) {
            Set<String> set = map.keySet();
            for (String string : set) {
                DataLogger.logControlDataSource(logger, null, "logRuntimeMemoryUsage", map.get(string));
            }
        }
    }

    public static void logConfigHighVis(Logger logger, Object object, String string, String string2, boolean bl2) {
        if (logger.isLoggable(Level.CONFIG)) {
            if (bl2) {
                string2 = StaticProfileConstants.maskJdbcURLPasswords(string2);
            }
            logger.logp(Level.CONFIG, DataLogger.getShortName(object), string, string2);
        }
    }

    public static void logMonitorBuffer(Logger logger, Object object, String string, String string2, Message message) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        DataLogger.logMonitorMessage(logger, object, string, string2 + JSONHelper.decodeJSONMessage(message));
    }

    public static String getLocationInUserApplicationMessage() {
        CharSequence charSequence;
        String string;
        String string2;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n2 = StaticProfileCaptureHelper.getProxyLocationInTrace(stackTraceElementArray);
        int n3 = n2 + 1;
        String string3 = stackTraceElementArray[n3].getClassName();
        String string4 = "";
        if (null == string3) {
            string3 = "";
        } else {
            int n4 = string3.lastIndexOf(46);
            if (n4 != -1) {
                string4 = string3.substring(0, n4);
                string3 = string3.substring(n4 + 1);
            }
        }
        String string5 = stackTraceElementArray[n3].getFileName();
        if (null == string5) {
            string5 = "Unknown Source";
        }
        if (null == (string2 = stackTraceElementArray[n3].getMethodName())) {
            string2 = "";
        }
        boolean bl2 = stackTraceElementArray[n3].isNativeMethod();
        String string6 = String.valueOf(bl2);
        if (string4.startsWith(StaticProfileCaptureHelper.proxyPackage__)) {
            string5 = "Unknown Source";
            string = "";
        } else {
            int n5 = stackTraceElementArray[n3].getLineNumber();
            string = 0 != n5 && !bl2 ? String.valueOf(n5) : "";
        }
        String string7 = null;
        if (0 <= n2 && null != (charSequence = stackTraceElementArray[n2].getMethodName()) && XmlFileHelper.isAttributeSet((String)charSequence)) {
            string7 = Messages.getText("MSG_LOCATION_IN_USER_APPLICATION_INCLUDES_METHOD_NAME", charSequence);
        }
        if (null == string7) {
            string7 = locationInUserApplicationPrefixMessageNoMethodName_;
        }
        charSequence = new StringBuilder(string7);
        ((StringBuilder)charSequence).append("  ");
        ((StringBuilder)charSequence).append("classFile").append("=\"").append(string3).append("\" ");
        ((StringBuilder)charSequence).append("containingPkg").append("=\"").append(string4).append("\" ");
        ((StringBuilder)charSequence).append("fileName").append("=\"").append(string5).append("\" ");
        ((StringBuilder)charSequence).append("isNative").append("=\"").append(string6).append("\" ");
        ((StringBuilder)charSequence).append("lineNo").append("=\"").append(string).append("\" ");
        ((StringBuilder)charSequence).append("method").append("=\"").append(string2).append("\"");
        return ((StringBuilder)charSequence).toString();
    }

    private static final Thread addShutdownHook(Runnable runnable) {
        Thread thread = new Thread(runnable, "DataLoggerSHThread");
        Runtime.getRuntime().addShutdownHook(thread);
        return thread;
    }

    private static final PrivilegedAction<Thread> addShutdownHookPriv(final Runnable runnable) {
        return new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return DataLogger.addShutdownHook(runnable);
            }
        };
    }

    private static BufferedOutputStream getFileAsBufferedOutputStream(String string, boolean bl2) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(string, bl2));
    }

    private static final PrivilegedExceptionAction<BufferedOutputStream> getFileAsBufferedOutputStreamPriv(final String string, final boolean bl2) {
        return new PrivilegedExceptionAction<BufferedOutputStream>(){

            @Override
            public BufferedOutputStream run() throws FileNotFoundException {
                return new BufferedOutputStream(new FileOutputStream(string, bl2));
            }
        };
    }

    public static void logThrowable(Logger logger, Throwable throwable) {
        if (logger == null) {
            logger = Log.getGlobalLogger();
        }
        ExceptionFactory.logException(logger, throwable);
    }

    public static void logAppSpecificProperties(Logger logger, Object object, String string, String string2) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        logger.logp(Level.FINEST, DataLogger.getShortName(object), string, StaticProfileConstants.maskJdbcURLPasswords(string2));
    }

    public static void logAtLevelFiner(Logger logger, Object object, String string, String string2) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        logger.logp(Level.FINER, DataLogger.getShortName(object), string, string2);
    }

    public static void lowImpactLogger(Logger logger, Object object, String string, String string2, Throwable throwable) {
        if (throwable != null) {
            throwable.getMessage();
        }
        logger.logp(Level.INFO, DataLogger.getShortName(object), string, string2, throwable);
    }

    public static void logConnectedComponents(Logger logger, Object object, String string, String string2) {
        logger.logp(Level.FINE, DataLogger.getShortName(object), string, string2);
    }

    public static void logUserLevel(Logger logger, Object object, String string, String string2) {
        logger.logp(Level.INFO, DataLogger.getShortName(object), string, string2);
    }

    public static void logUserLevel(Logger logger, Object object, String string, String string2, Throwable throwable) {
        logger.logp(Level.INFO, DataLogger.getShortName(object), string, string2, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPmrStamp() {
        if (pmrStampingStr_ != null) return pmrStampingStr_;
        String string = PMR_STAMP_EYECATCHER;
        synchronized (PMR_STAMP_EYECATCHER) {
            Enumeration<Driver> enumeration;
            if (pmrStampingStr_ != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return pmrStampingStr_;
            }
            DataLogger.appendStringToBuffWithMaxLineLen(PMR_STAMP_EYECATCHER);
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("java.home=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("java.home"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("java.runtime.name=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("java.runtime.name"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("java.fullversion=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.removeNewlineFromSB(DataLogger.getSystemProperty("java.fullversion")));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("java.runtime.version=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.removeNewlineFromSB(DataLogger.getSystemProperty("java.runtime.version")));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("java.vm.vendor=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("java.vm.vendor"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("java.vm.name=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.removeNewlineFromSB(DataLogger.getSystemProperty("java.vm.name")));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("java.vm.info=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.removeNewlineFromSB(DataLogger.getSystemProperty("java.vm.info")));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("java.io.tmpdir=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("java.io.tmpdir"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("sun.jnu.encoding=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("sun.jnu.encoding"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("sun.io.unicode.encoding=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("sun.io.unicode.encoding"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("file.encoding=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("file.encoding"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("os.arch=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("os.arch"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("os.encoding=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("os.encoding"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("os.name=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("os.name"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("os.version=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.removeNewlineFromSB(DataLogger.getSystemProperty("os.version")));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("user.country=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("user.country"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("user.name=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("user.name"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("user.dir=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.getSystemProperty("user.dir"));
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("pdqVer=\"");
            DataLogger.appendStringToBuffWithMaxLineLen("3.3306.7");
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("pdqJar=\"");
            try {
                Class.forName("com.ibm.db2.cmx.runtime.internal.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (Configuration.pureQueryDriverPath__ != null) {
                DataLogger.appendStringToBuffWithMaxLineLen(Configuration.pureQueryDriverPath__);
            }
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("pdqFeatures=\"Act ");
            if (Configuration.isLicensed__) {
                DataLogger.appendStringToBuffWithMaxLineLen("Act ");
            } else {
                DataLogger.appendStringToBuffWithMaxLineLen("NotAct ");
            }
            if (Configuration.isExtendedInsightLicensed__) {
                if (Configuration.isExtendedInsightZosLicensed__) {
                    DataLogger.appendStringToBuffWithMaxLineLen("Act ");
                } else {
                    DataLogger.appendStringToBuffWithMaxLineLen("NotAct ");
                }
                if (Configuration.isExtendedInsightLUWLicensed__) {
                    DataLogger.appendStringToBuffWithMaxLineLen("Act");
                } else {
                    DataLogger.appendStringToBuffWithMaxLineLen("NotAct");
                }
            } else {
                DataLogger.appendStringToBuffWithMaxLineLen("NotAct NotAct");
            }
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            DataLogger.appendStringToBuffWithMaxLineLen("secutityManager=\"");
            DataLogger.appendStringToBuffWithMaxLineLen(DataProperties.runningUnderSecurityManager_ ? "Yes" : "No");
            DataLogger.appendStringToBuffWithMaxLineLen("\"");
            DataLogger.appendStringToBuffWithMaxLineLen("\n");
            if (Configuration.isJCCPresent__) {
                DataLogger.appendStringToBuffWithMaxLineLen("pdqJccPrereq=\"");
                if (!Configuration.isJCCAtPrerequisiteLevel__) {
                    DataLogger.appendStringToBuffWithMaxLineLen("NOT ");
                }
                DataLogger.appendStringToBuffWithMaxLineLen("Met\"");
                DataLogger.appendStringToBuffWithMaxLineLen("\n");
                DataLogger.appendStringToBuffWithMaxLineLen("jccVer=\"");
                DataLogger.appendStringToBuffWithMaxLineLen(DataLogger.removeNewlineFromSB("IBM Data Server Driver for JDBC and SQLJ"));
                DataLogger.appendStringToBuffWithMaxLineLen(" at version ");
                DataLogger.appendStringToBuffWithMaxLineLen(Configuration.JCCVersionAsString__);
                DataLogger.appendStringToBuffWithMaxLineLen("\"");
                DataLogger.appendStringToBuffWithMaxLineLen("\n");
                DataLogger.appendStringToBuffWithMaxLineLen("reqJCCVer=\"");
                if (Configuration.JCCMajorVersion__ == 3) {
                    DataLogger.appendStringToBuffWithMaxLineLen("3.57");
                } else {
                    DataLogger.appendStringToBuffWithMaxLineLen("4.7");
                }
                DataLogger.appendStringToBuffWithMaxLineLen("\"");
                DataLogger.appendStringToBuffWithMaxLineLen("\n");
            }
            if ((enumeration = DriverManager.getDrivers()).hasMoreElements()) {
                DataLogger.appendStringToBuffWithMaxLineLen("jdbcDriversAvailable=\"");
                boolean bl2 = false;
                while (enumeration.hasMoreElements()) {
                    Driver driver = enumeration.nextElement();
                    if (bl2) {
                        DataLogger.appendStringToBuffWithMaxLineLen(", ");
                    } else {
                        bl2 = true;
                    }
                    DataLogger.appendStringToBuffWithMaxLineLen(driver.getClass().getCanonicalName());
                    DataLogger.appendStringToBuffWithMaxLineLen(" ver ");
                    DataLogger.appendStringToBuffWithMaxLineLen(String.valueOf(driver.getMajorVersion()));
                    DataLogger.appendStringToBuffWithMaxLineLen(".");
                    DataLogger.appendStringToBuffWithMaxLineLen(String.valueOf(driver.getMinorVersion()));
                }
                DataLogger.appendStringToBuffWithMaxLineLen("\"");
            }
            stringBuffForPMRStamp_.append('\n');
            stringBuffForPMRStamp_.append(END_PMR_STAMP);
            stringBuffForPMRStamp_.append("\njava.class.path=\n");
            stringBuffForPMRStamp_.append(DataLogger.getSystemProperty("java.class.path").replace(";", "\n"));
            stringBuffForPMRStamp_.append('\n');
            pmrStampingStr_ = stringBuffForPMRStamp_.toString();
            stringBuffForPMRStamp_ = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return pmrStampingStr_;
        }
    }

    private static void appendStringToBuffWithMaxLineLen(String string) {
        int n2 = string.length();
        if (n2 == 1 && string.charAt(0) == '\n') {
            if (pmrStampCurrentLineLen_ != 0) {
                stringBuffForPMRStamp_.append('\n');
                pmrStampCurrentLineLen_ = 0;
            }
            return;
        }
        int n3 = pmrStampCurrentLineLen_ + n2;
        if (n3 >= 70) {
            int n4 = 0;
            while (n2 > 0) {
                n3 = pmrStampCurrentLineLen_ + n2;
                int n5 = n3 > 70 ? 70 - pmrStampCurrentLineLen_ : n2;
                stringBuffForPMRStamp_.append(string.substring(n4, n4 + n5));
                pmrStampCurrentLineLen_ += n5;
                n4 += n5;
                if ((n2 -= n5) == 0) continue;
                stringBuffForPMRStamp_.append('\n');
                pmrStampCurrentLineLen_ = 0;
            }
        } else {
            stringBuffForPMRStamp_.append(string);
            pmrStampCurrentLineLen_ += n2;
        }
    }

    private static String removeNewlineFromSB(String string) {
        if (string != null) {
            string = string.replace('\n', '~');
        }
        return string;
    }

    private static String getSystemProperty(String string) {
        String string2 = null;
        if (DataProperties.runningUnderSecurityManager_) {
            try {
                string2 = AccessController.doPrivileged(DataLogger.getSystemPropertyPriv(string));
            }
            catch (Exception exception) {}
        } else {
            string2 = DataLogger.getSystemPropertyNoSM(string);
        }
        return string2;
    }

    private static String getSystemPropertyNoSM(String string) {
        return System.getProperty(string, "");
    }

    private static final PrivilegedAction<String> getSystemPropertyPriv(final String string) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return DataLogger.getSystemPropertyNoSM(string);
            }
        };
    }

    static {
        try {
            printWriters.values().iterator();
            if (DataProperties.runningUnderSecurityManager_) {
                AccessController.doPrivileged(DataLogger.addShutdownHookPriv(new PrintWriterCloser()));
            } else {
                DataLogger.addShutdownHook(new PrintWriterCloser());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        locationInUserApplicationPrefixMessageNoMethodName_ = Messages.getText("MSG_LOCATION_IN_USER_APPLICATION_NO_METHOD_NAME", new Object[0]);
    }

    public static class PrintWriterCloser
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Object object2;
            Object object3;
            try {
                object2 = object3 = Log.getGlobalLogger();
                synchronized (object2) {
                    object = ((Logger)object3).getHandlers();
                    for (Handler handler : object) {
                        ((Logger)object3).removeHandler(handler);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
            object3 = printWriters;
            synchronized (object3) {
                object2 = printWriters.values().iterator();
                while (object2.hasNext()) {
                    try {
                        object = (DataPrintWriter)object2.next();
                        ((PrintWriter)object).flush();
                        while (0 < ((DataPrintWriter)object).decrementUserCount()) {
                        }
                        ((DataPrintWriter)object).closeDataPrintWriter();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.err);
                    }
                }
            }
        }
    }
}

