/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers.db2;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.StaticProfileSection;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.JDBCDynamicExecutionHandlerPropertiesRefresh;
import com.ibm.db2.cmx.runtime.internal.wrappers.ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.jcc.DB2PreparedStatement;
import com.ibm.db2.jcc.DBPreparedStatementInfoInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;

public class DB2CallableStatementExecutionHandler
extends DB2PreparedStatementExecutionHandler {
    private CallableStatement physicalCallableStatement_ = null;
    private DB2ConnectionExecutionHandler db2ConnExecutionHandler_;

    public DB2CallableStatementExecutionHandler(DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler, CallableStatement callableStatement, String string, int n2, int n3, int n4, String string2, Method method, Object ... objectArray) throws SQLException {
        super(dB2ConnectionExecutionHandler, (PreparedStatement)callableStatement, string, n2, n3, n4, null, null, 0, string2, method, objectArray);
        this.db2ConnExecutionHandler_ = dB2ConnectionExecutionHandler;
        this.physicalCallableStatement_ = callableStatement;
    }

    public DB2CallableStatementExecutionHandler(DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler, CallableStatement callableStatement, String string, int n2, int n3, int n4, StaticProfileSection staticProfileSection, String string2, Method method, Object ... objectArray) throws SQLException {
        super(dB2ConnectionExecutionHandler, (PreparedStatement)callableStatement, string, n2, n3, n4, null, null, 0, staticProfileSection, string2, method, objectArray);
        this.db2ConnExecutionHandler_ = dB2ConnectionExecutionHandler;
        this.physicalCallableStatement_ = callableStatement;
        this.initializeCallStatement(staticProfileSection);
    }

    private void initializeCallStatement(StaticProfileSection staticProfileSection) throws SQLException {
        SqlStatementType sqlStatementType;
        this.isCallStmt_ = null != staticProfileSection ? staticProfileSection.isCall() : SqlStatementType.CALL == (sqlStatementType = this.getCurrentSqlType());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(String string, Method method, Object[] objectArray) throws Throwable {
        Connection connection = this.db2ConnectionExecutionHandler_.physicalConnection_;
        synchronized (connection) {
            Object object;
            block31: {
                Object object2 = null;
                if (this.db2ConnectionExecutionHandler_.driverTraceOn_) {
                    this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] enter...");
                }
                if (this.db2ConnectionExecutionHandler_.isClosed_) {
                    return method.invoke((Object)this.physicalStatement_, objectArray);
                }
                if (this.logger_.isLoggable(Level.FINER)) {
                    if (string.equals("equals") || string.equals("hashCode") || string.equals("toString")) {
                        return method.invoke((Object)this.physicalCallableStatement_, objectArray);
                    }
                    DataLogger.logAtLevelFiner(this.logger_, this, "invoke: " + string, "ENTRY " + Arrays.deepToString(objectArray));
                }
                try {
                    block30: {
                        block34: {
                            block37: {
                                block36: {
                                    block35: {
                                        block33: {
                                            block32: {
                                                if (this.propertyRefreshEnabled_ && (string.startsWith("set") || string.startsWith("closeOn"))) {
                                                    this.modifiedStatementAttributes_.saveModifiedAttributeIfNeeded(string, method, objectArray);
                                                }
                                                if (!string.equals("registerJccOutParameterAtName") || this.NamedParamMap_ == null) break block32;
                                                this.registerJccOutParameterAtName(objectArray);
                                                break block30;
                                            }
                                            if (!string.startsWith("set") || objectArray == null || objectArray.length != 2 && objectArray.length != 3) break block33;
                                            this.setIsParameterizedDynamicStatement(true);
                                            if (string.startsWith("setJcc") && this.NamedParamMap_ != null) {
                                                this.setJccXXXAtName(method, objectArray);
                                                break block30;
                                            } else {
                                                object2 = method.invoke((Object)this.physicalCallableStatement_, objectArray);
                                            }
                                            break block30;
                                        }
                                        if (!string.startsWith("execute")) break block34;
                                        this.releaseStaticUpdateableCursor();
                                        this.resultSet_ = null;
                                        if (!string.equals("execute") || objectArray != null) break block35;
                                        object2 = this.execute();
                                        break block30;
                                    }
                                    if (!string.equals("executeQuery") || objectArray != null) break block36;
                                    object2 = this.executeQuery();
                                    break block30;
                                }
                                if (!string.equals("executeUpdate") || objectArray != null) break block37;
                                object2 = this.executeUpdate();
                                break block30;
                            }
                            if (string.equals("executeBatch") && objectArray == null) {
                                object2 = this.executeBatch();
                                break block30;
                            } else if (string.equals("executeDB2QueryBatch") && objectArray == null) {
                                super.executeDB2QueryBatch();
                                break block30;
                            } else {
                                object2 = this.isCallStmt_ ? method.invoke((Object)this.physicalCallableStatement_, objectArray) : super.invoke(string, method, objectArray);
                            }
                            break block30;
                        }
                        if (string.equals("setCursorName")) {
                            super.setCursorName(method, objectArray);
                        } else if (string.equals("addBatch")) {
                            object2 = this.addBatch(method, objectArray);
                        } else if (string.equals("clearBatch")) {
                            this.clearBatch();
                        } else if (string.equals("close")) {
                            super.close();
                        } else {
                            object2 = string.equals("getMoreResults") ? (objectArray == null ? Boolean.valueOf(this.getMoreResults()) : Boolean.valueOf(this.getMoreResults((Integer)objectArray[0]))) : (string.equals("getResultSet") ? (this.isCallStmt_ ? this.physicalCallableStatement_.getResultSet() : super.getResultSet()) : method.invoke((Object)this.physicalCallableStatement_, objectArray));
                        }
                    }
                    object = object2;
                    if (this.db2ConnectionExecutionHandler_.driverTraceOn_) {
                        this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] exit...");
                    }
                    if (!this.logger_.isLoggable(Level.FINER)) break block31;
                }
                catch (InvocationTargetException invocationTargetException) {
                    try {
                        Throwable throwable = invocationTargetException.getTargetException();
                        DataLogger.logThrowable(this.logger_, throwable);
                        this.dumpLogs(throwable);
                        throw throwable;
                        catch (IllegalAccessException illegalAccessException) {
                            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 10447);
                        }
                        catch (SQLException sQLException) {
                            DataLogger.logThrowable(this.logger_, sQLException);
                            this.dumpLogs(sQLException);
                            throw sQLException;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.db2ConnectionExecutionHandler_.driverTraceOn_) {
                            this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] exit...");
                        }
                        if (this.logger_.isLoggable(Level.FINER)) {
                            DataLogger.exit(this.logger_, this, "invoke: " + string, object2);
                        }
                        throw throwable;
                    }
                }
                DataLogger.exit(this.logger_, this, "invoke: " + string, object2);
            }
            return object;
        }
    }

    private void registerJccOutParameterAtName(Object[] objectArray) throws SQLException {
        String string = ((String)objectArray[0]).toUpperCase();
        ArrayList arrayList = (ArrayList)this.NamedParamMap_.get(string);
        Object[] objectArray2 = new Object[objectArray.length - 1];
        for (int i10 = 1; i10 < objectArray.length; ++i10) {
            objectArray2[i10 - 1] = objectArray[i10];
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (objectArray2.length == 1) {
                this.physicalCallableStatement_.registerOutParameter(n2, (int)((Integer)objectArray2[0]));
                continue;
            }
            if (objectArray2.length != 2) continue;
            if (objectArray2[1].getClass().isAssignableFrom(Integer.class)) {
                this.physicalCallableStatement_.registerOutParameter(n2, (int)((Integer)objectArray2[0]), (int)((Integer)objectArray2[1]));
                continue;
            }
            this.physicalCallableStatement_.registerOutParameter(n2, (int)((Integer)objectArray2[0]), (String)objectArray2[1]);
        }
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordNonQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, long l10, long l11, int n2) throws SQLException {
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = ((DB2PreparedStatement)((Object)this.physicalCallableStatement_)).getDBPreparedStatementInfo();
        String[] stringArray2 = null;
        if (this.autoGenKeyColNames_ != null || this.autoGenKeyColIndexes_ != null || dBPreparedStatementInfoInterface.getNamedParameterMarkerMap() != null) {
            stringArray2 = dBPreparedStatementInfoInterface.getSQLString();
        }
        sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().recordNonQueryStmt(this.db2ConnectionExecutionHandler_, this.getSqlString(), dBPreparedStatementInfoInterface.getDBParameterMetaData(), null, sqlStatementKey, null, stringArray2, this.getCurrentSqlType(), false, this.definitionTraceInfo_, stringArray, dBPreparedStatementInfoInterface.getNamedParameterMarkerMap(), null, l10, l11, n2);
        return sqlStatementInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        if (!this.isCallStmt_) {
            return super.execute();
        }
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, false, this.sqlStr_);
        boolean bl2 = false;
        boolean bl3 = true;
        try {
            this.db2ConnectionExecutionHandler_.systemMonitorStart();
            bl2 = this.physicalCallableStatement_.execute();
            bl3 = false;
        }
        finally {
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
            this.checkAndCaptureCallStmt(bl3, this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0);
            if (!bl3 && this.db2ConnectionExecutionHandler_.getSrValueSetImmediateTrackRequired()) {
                StaticProfileCaptureHelper staticProfileCaptureHelper = this.currentStates_.getProfilerHelperInstance();
                if (staticProfileCaptureHelper == null) {
                    this.db2ConnectionExecutionHandler_.performSRegQueryAndSetTimeZone();
                } else {
                    staticProfileCaptureHelper.generateAndCaptureSpecialRegSet(this.db2ConnectionExecutionHandler_);
                }
            }
        }
        return bl2;
    }

    @Override
    public ResultSetExecutionHandler executeQuery() throws SQLException {
        if (!this.isCallStmt_) {
            return super.executeQuery();
        }
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, false, this.sqlStr_);
        boolean bl2 = true;
        try {
            this.db2ConnectionExecutionHandler_.systemMonitorStart();
            ResultSet resultSet = this.physicalCallableStatement_.executeQuery();
            if (resultSet != null) {
                this.resultSet_ = new DB2ResultSetExecutionHandler(this, resultSet, resultSet.getType(), resultSet.getConcurrency(), this.physicalCallableStatement_.getResultSetHoldability(), resultSet.getCursorName());
            }
            bl2 = false;
        }
        finally {
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
            this.checkAndCaptureCallStmt(bl2, this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0);
        }
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        if (!this.isCallStmt_) {
            return super.executeUpdate();
        }
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, false, this.sqlStr_);
        int n2 = 0;
        boolean bl2 = true;
        try {
            this.db2ConnectionExecutionHandler_.systemMonitorStart();
            n2 = this.physicalCallableStatement_.executeUpdate();
            bl2 = false;
        }
        finally {
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
            this.checkAndCaptureCallStmt(bl2, this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0);
            if (!bl2 && this.db2ConnectionExecutionHandler_.getSrValueSetImmediateTrackRequired()) {
                StaticProfileCaptureHelper staticProfileCaptureHelper = this.currentStates_.getProfilerHelperInstance();
                if (staticProfileCaptureHelper == null) {
                    this.db2ConnectionExecutionHandler_.performSRegQueryAndSetTimeZone();
                } else {
                    staticProfileCaptureHelper.generateAndCaptureSpecialRegSet(this.db2ConnectionExecutionHandler_);
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int[] executeBatch() throws SQLException {
        if (!this.isCallStmt_) {
            return super.executeBatch();
        }
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, false, this.sqlStr_);
        int[] nArray = null;
        boolean bl2 = true;
        int n2 = this.isHomogeneousBatch_ ? super.getBatchCount() : 0;
        try {
            this.db2ConnectionExecutionHandler_.systemMonitorStart();
            nArray = this.physicalCallableStatement_.executeBatch();
            bl2 = false;
        }
        finally {
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
            super.setBatchCount(0);
            this.checkAndCaptureCallStmt(bl2, 0L, this.db2ConnectionExecutionHandler_.getElapsedTime(), n2);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionHandler getNewExecutionHandler() throws SQLException {
        ExecutionHandler executionHandler;
        Object[] objectArray;
        try {
            this.physicalCallableStatement_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.args_.length != 4) {
            objectArray = new Object[]{this.args_[0], this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_};
            this.args_ = objectArray;
            this.method_ = ConnectionExecutionHandler.getMethodPrepareCall4args();
        }
        if (!this.cachedConnectionAttributesForStatement_.equals(this.db2ConnExecutionHandler_.getCurrentConnectionAttributes())) {
            Object[] objectArray2 = objectArray = this.db2ConnExecutionHandler_.physicalConnection_;
            synchronized (objectArray) {
                try {
                    this.cachedConnectionAttributesForStatement_.transferCachedConnectionAttributes((Connection)objectArray);
                    executionHandler = (ExecutionHandler)this.db2ConnExecutionHandler_.invoke(this.methodName_, this.method_, this.args_);
                    executionHandler.setCachedConnectionAttributes(this.cachedConnectionAttributesForStatement_);
                }
                catch (Throwable throwable) {
                    throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11100);
                }
                finally {
                    try {
                        this.db2ConnExecutionHandler_.restoreConnectionAttributes();
                    }
                    catch (Throwable throwable) {
                        throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11101);
                    }
                }
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
        }
        try {
            executionHandler = (ExecutionHandler)this.db2ConnExecutionHandler_.invoke(this.methodName_, this.method_, this.args_);
        }
        catch (Throwable throwable) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11102);
        }
        {
            executionHandler.setAndTransferModifiedStatementAttributes(this.modifiedStatementAttributes_);
            return executionHandler;
        }
    }

    @Override
    public ExecutionHandler checkAndReplaceExecutionHandler() throws SQLException {
        if (this.propertyRefreshEnabled_ && this.propertyRedirectedKey_.isModified()) {
            CallableStatement callableStatement = this.physicalCallableStatement_;
            ExecutionHandler executionHandler = this.getNewExecutionHandler();
            if (this.logger_.isLoggable(Level.CONFIG)) {
                JDBCDynamicExecutionHandlerPropertiesRefresh.logNewExecutionHandler(this.logger_, this.db2ConnectionExecutionHandler_.driverTraceOn_, this.sqlStr_, callableStatement, this, executionHandler, this.db2ConnExecutionHandler_);
            }
            return executionHandler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object addBatch(Method method, Object[] objectArray) throws SQLException, IllegalAccessException, InvocationTargetException {
        if (!this.isCallStmt_) {
            return super.addBatch(method, objectArray);
        }
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, false, this.sqlStr_);
        Object object = null;
        boolean bl2 = true;
        int n2 = super.getBatchCount();
        try {
            object = method.invoke((Object)this.physicalCallableStatement_, objectArray);
            bl2 = false;
            this.isHomogeneousBatch_ = true;
        }
        finally {
            if (!this.isAddBatchDone_) {
                this.checkAndCaptureCallStmt(bl2, 0L, 0L, 0);
                this.isAddBatchDone_ = true;
            }
            super.setBatchCount(n2++);
        }
        return object;
    }

    @Override
    protected void clearBatch() throws SQLException {
        super.setBatchCount(0);
        this.physicalCallableStatement_.clearBatch();
    }

    @Override
    public String toString() {
        return new String("DB2CallableStatementExecutionHandler@" + Integer.toHexString(this.hashCode()) + "[physical: " + (this.physicalCallableStatement_ == null ? "null" : this.physicalCallableStatement_.toString()) + "]");
    }
}

