/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.DB2Struct;
import COM.ibm.db2.app.DB2StructConstant;
import COM.ibm.db2.app.DereferencedNativeArray;
import COM.ibm.db2.app.NativeArray;
import COM.ibm.db2.app.TypeMapTableElement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;

public class DB2StructInput
extends DB2Struct
implements SQLInput {
    public boolean currAttrIsNull;
    public boolean prevAttrWasNull;

    public DB2StructInput(DereferencedNativeArray dereferencedNativeArray, HashMap hashMap, int n2, ClassLoader classLoader) throws SQLException {
        super(dereferencedNativeArray, hashMap, n2, classLoader);
        this.numAttr = dereferencedNativeArray.getShort(n2 + 6);
        this.typeTag = dereferencedNativeArray.getInt(n2 + 12);
        this.totalLength = dereferencedNativeArray.getInt(n2 + 8);
        DB2StructConstant.print("numAttr = " + this.numAttr);
        DB2StructConstant.print("typeTag = " + this.typeTag);
        DB2StructConstant.print("totalLength = " + this.totalLength);
        this.nextAttr();
    }

    public DB2StructInput() {
    }

    @Override
    public void reset(DereferencedNativeArray dereferencedNativeArray, HashMap hashMap, int n2) throws SQLException {
        super.reset(dereferencedNativeArray, hashMap, n2);
        this.numAttr = dereferencedNativeArray.getShort(n2 + 6);
        this.typeTag = dereferencedNativeArray.getInt(n2 + 12);
        this.totalLength = dereferencedNativeArray.getInt(n2 + 8);
        DB2StructConstant.print("numAttr = " + this.numAttr);
        DB2StructConstant.print("typeTag = " + this.typeTag);
        DB2StructConstant.print("totalLength = " + this.totalLength);
        this.nextAttr();
    }

    @Override
    public void reset() throws SQLException {
        super.reset();
        this.numAttr = this.nativeStructTypeBuff.getShort(this.indexof_currStructTypeFrame + 6);
        this.typeTag = this.nativeStructTypeBuff.getInt(this.indexof_currStructTypeFrame + 12);
        this.totalLength = this.nativeStructTypeBuff.getInt(this.indexof_currStructTypeFrame + 8);
        DB2StructConstant.print("numAttr = " + this.numAttr);
        DB2StructConstant.print("typeTag = " + this.typeTag);
        DB2StructConstant.print("totalLength = " + this.totalLength);
        this.nextAttr();
    }

    @Override
    public void nextAttr() throws SQLException {
        super.nextAttr();
        this.currAttrType = this.nativeStructTypeBuff.getShort(this.indexof_currStructTypeFrame + this.indexof_metaFlag);
        DB2StructConstant.print("indexof_metaFlag  = " + this.indexof_metaFlag);
        DB2StructConstant.print("indexof_currStructTypeFrame = " + this.indexof_currStructTypeFrame);
        DB2StructConstant.print("currAttrType = " + this.currAttrType);
        this.prevAttrWasNull = this.currAttrIsNull;
        this.currAttrIsNull = (this.currAttrType & 0x40) != 0;
    }

    public static HashMap loadTypeMap(NativeArray nativeArray) throws SQLException {
        return DB2Struct.loadTypeMap(nativeArray, true);
    }

    @Override
    public String readString() throws SQLException {
        DB2StructConstant.print("Beginning readString");
        if (this.currAttrType != 1536) {
            DB2StructInput.error("Current Attribute is not of type String !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        String string = this.nativeStructTypeBuff.getDereferencedString(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (string == null) {
            DB2StructInput.error("Null string object returned");
        }
        this.nextAttr();
        DB2StructConstant.print("Ending readString");
        return string;
    }

    @Override
    public boolean readBoolean() throws SQLException {
        DB2StructInput.error("DB2 does not currently support boolean data types");
        return false;
    }

    @Override
    public URL readURL() throws SQLException {
        DB2StructInput.error("DB2 does not currently support DATALINK data types");
        return null;
    }

    @Override
    public byte readByte() throws SQLException {
        DB2StructInput.error("DB2 does not currently support byte data types");
        return 0;
    }

    @Override
    public short readShort() throws SQLException {
        DB2StructConstant.print("Beginning readShort");
        if (this.currAttrType != 8192) {
            DB2StructInput.error("Current Attribute is not of type Short Integer !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0;
        }
        short s2 = this.nativeStructTypeBuff.getShort(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("Ending readShort");
        return s2;
    }

    @Override
    public int readInt() throws SQLException {
        DB2StructConstant.print("Beginning readInt");
        if (this.currAttrType != 8448) {
            DB2StructInput.error("Current Attribute is not of type Integer !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0;
        }
        int n2 = this.nativeStructTypeBuff.getInt(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("Ending readInt");
        return n2;
    }

    @Override
    public long readLong() throws SQLException {
        DB2StructConstant.print("Beginning readLong");
        if (this.currAttrType != 8704) {
            DB2StructInput.error("Current Attribute is not of type Long Integer !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0L;
        }
        long l10 = this.nativeStructTypeBuff.getLong(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("ENDING getLong");
        return l10;
    }

    @Override
    public float readFloat() throws SQLException {
        DB2StructConstant.print("Beginning ReadFloat");
        if (this.currAttrType != 8960) {
            DB2StructInput.error("Current Attribute is not of type float !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0.0f;
        }
        float f10 = this.nativeStructTypeBuff.getFloat(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("Ending ReadFloat");
        return f10;
    }

    @Override
    public double readDouble() throws SQLException {
        DB2StructConstant.print("Beginning ReadFloat");
        if (this.currAttrType != 9216) {
            DB2StructInput.error("Current Attribute is not of type double !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0.0;
        }
        double d10 = this.nativeStructTypeBuff.getLong(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("Ending ReadFloat");
        return d10;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        if (this.currAttrType != 0) {
            DB2StructInput.error("Current Attribute is not of type decimal !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        BigDecimal bigDecimal = this.nativeStructTypeBuff.getDereferencedBigDecimal(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (bigDecimal == null) {
            DB2StructInput.error("Null BigDecimal Object Returned");
        }
        this.nextAttr();
        return bigDecimal;
    }

    @Override
    public byte[] readBytes() throws SQLException {
        DB2StructInput.error("DB2 does not currently support byte array data types");
        return null;
    }

    @Override
    public Date readDate() throws SQLException {
        if (this.currAttrType != 9728) {
            DB2StructInput.error("Current Attribute is not of type decimal !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Date date = this.nativeStructTypeBuff.getDate(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (date == null) {
            DB2StructInput.error("Null Date Object Returned");
        }
        this.nextAttr();
        return date;
    }

    @Override
    public Time readTime() throws SQLException {
        DB2StructConstant.print("Beginning readTime");
        if (this.currAttrType != 9984) {
            DB2StructInput.error("Current Attribute is not of type time !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Time time = this.nativeStructTypeBuff.getTime(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (time == null) {
            DB2StructInput.error("Null Time Object returned");
        }
        this.nextAttr();
        DB2StructConstant.print("Ending readTime");
        return time;
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        if (this.currAttrType != 768) {
            DB2StructInput.error("Current Attribute is not of type timestamp !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Timestamp timestamp = this.nativeStructTypeBuff.getDereferencedTimestamp(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (timestamp == null) {
            DB2StructInput.error("Null Timestamp object Returned");
        }
        this.nextAttr();
        return timestamp;
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        DB2StructInput.error("DB2 does not currently support character streams");
        return null;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        DB2StructInput.error("DB2 does not currently support ascii streams");
        return null;
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        DB2StructInput.error("DB2 does not currently support binary streams");
        return null;
    }

    @Override
    public Object readObject() throws SQLException {
        DB2StructConstant.print("Beginning ReadObject");
        DB2StructConstant.print("Going to typeMapTable.get...");
        TypeMapTableElement typeMapTableElement = (TypeMapTableElement)this.typeMapTable.get(new Integer(this.typeTag));
        if (typeMapTableElement == null) {
            DB2StructInput.error("Invalid typetag" + this.typeTag);
        }
        DB2StructConstant.print("Survived typeMapTable.get...");
        if (typeMapTableElement.classRef == null) {
            try {
                typeMapTableElement.classRef = this.classLoader.loadClass(typeMapTableElement.className);
                this.typeMapTable.put(new Integer(this.typeTag), typeMapTableElement);
            }
            catch (ClassNotFoundException classNotFoundException) {
                DB2StructConstant.print("Failed classloader!!!");
            }
            DB2StructConstant.print("Passed classloader!!!");
        }
        SQLData sQLData = null;
        if (!this.isStructTypeHeaderProcessed) {
            this.isStructTypeHeaderProcessed = true;
            try {
                sQLData = (SQLData)typeMapTableElement.classRef.newInstance();
            }
            catch (Exception exception) {
                DB2StructConstant.print("Exception calling classRef.newInstance!!!");
                DB2StructInput.error(exception.toString());
            }
            DB2StructConstant.print("Survived created java object instance...");
            sQLData.readSQL(this, typeMapTableElement.className);
        } else {
            if (this.currAttrType != 4096) {
                DB2StructInput.error("Current Attribute is not of type structured type !!");
            }
            if (this.currAttrIsNull) {
                this.nextAttr();
                return null;
            }
            long l10 = this.nativeStructTypeBuff.getLong(this.indexof_currStructTypeFrame + this.indexof_srp);
            DB2StructInput dB2StructInput = new DB2StructInput(this.nativeStructTypeBuff, this.typeMapTable, this.indexof_currStructTypeFrame + (int)l10, this.classLoader);
            sQLData = (SQLData)dB2StructInput.readObject();
        }
        super.nextAttr();
        DB2StructConstant.print("Ending readObject");
        return sQLData;
    }

    @Override
    public Ref readRef() throws SQLException {
        if (this.currAttrType != 32) {
            DB2StructInput.error("Current Attribute is not of type reference type !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Ref ref = this.nativeStructTypeBuff.getDereferencedRef(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (ref == null) {
            DB2StructInput.error("Null Ref Object Returned");
        }
        this.nextAttr();
        return ref;
    }

    @Override
    public Blob readBlob() throws SQLException {
        if (this.currAttrType != 12544) {
            DB2StructInput.error("Current Attribute is not of type structured type !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Blob blob = this.nativeStructTypeBuff.getDereferencedBlob(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (blob == null) {
            DB2StructInput.error("Null Blob Object Returned");
        }
        this.nextAttr();
        return blob;
    }

    @Override
    public Clob readClob() throws SQLException {
        if (this.currAttrType != 12288) {
            DB2StructInput.error("Current Attribute is not of type structured type !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Clob clob = this.nativeStructTypeBuff.getDereferencedClob(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (clob == null) {
            DB2StructInput.error("Null Clob object returned");
        }
        this.nextAttr();
        return clob;
    }

    @Override
    public Array readArray() throws SQLException {
        DB2StructInput.error("DB2 does not support Array data types");
        return null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.prevAttrWasNull;
    }

    @Override
    public NClob readNClob() throws SQLException {
        DB2StructInput.error("readNClob not supported");
        return null;
    }

    @Override
    public String readNString() throws SQLException {
        DB2StructInput.error("readNString not supported");
        return null;
    }

    @Override
    public RowId readRowId() throws SQLException {
        DB2StructInput.error("readRowId not supported");
        return null;
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        DB2StructInput.error("readSQLXML not supported");
        return null;
    }
}

