/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.Database;
import com.ibm.db2.cmx.ProductInformation;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.TransportPoolStatistics;
import com.ibm.db2.cmx.impl.DataSourceDescriptor;
import com.ibm.db2.cmx.impl.DriverDescriptor;
import com.ibm.db2.cmx.impl.TransportPoolStatistics;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerMessageHelper;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.jcc.am.GlobalProperties;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CMXImplMessageHelper {
    private static final CMXImplMessageHelper instance_ = new CMXImplMessageHelper();

    public static CMXImplMessageHelper getInstance() {
        return instance_;
    }

    private CMXImplMessageHelper() {
    }

    private PushDownError parsePushDownError(JSONArray jSONArray) {
        PushDownError pushDownError = null;
        if (jSONArray != null) {
            PushDownError.ErrorType errorType = PushDownError.ErrorType.valueOf((String)jSONArray.get(0));
            switch (errorType) {
                case unrecognizedProperty: {
                    pushDownError = new PushDownError.UnrecognizedProperty((String)jSONArray.get(1), PushDownError.PushDownLevel.valueOf((String)jSONArray.get(2)));
                    break;
                }
                case unsupportedPropertyForDynamicPushDown: {
                    pushDownError = new PushDownError.UnsupportedPropertyForDynamicPushDown((String)jSONArray.get(1), PushDownError.PushDownLevel.valueOf((String)jSONArray.get(2)));
                    break;
                }
                case sqlException: {
                    pushDownError = new PushDownError.SQLException((String)jSONArray.get(1), PushDownError.PushDownLevel.valueOf((String)jSONArray.get(2)), this.parseSQLException((JSONArray)jSONArray.get(3)));
                    break;
                }
            }
        }
        return pushDownError;
    }

    ArrayList<PushDownError> parsePushDownErrors(JSONArray jSONArray) {
        ArrayList<PushDownError> arrayList = null;
        if (jSONArray != null) {
            arrayList = new ArrayList<PushDownError>();
            for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
                arrayList.add(this.parsePushDownError((JSONArray)jSONArray.get(i10)));
            }
        }
        return arrayList;
    }

    private Throwable parseCauseX(JSONArray jSONArray) {
        Throwable throwable = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            throwable = new Throwable((String)jSONArray.get(0));
        }
        return throwable;
    }

    private Throwable parseCause(JSONArray jSONArray) {
        Throwable throwable = null;
        Throwable throwable2 = null;
        if (jSONArray != null && jSONArray.size() > 0 && (throwable2 = (throwable = this.parseCauseX((JSONArray)jSONArray.get(0)))) != null) {
            for (int i10 = 1; i10 < jSONArray.size(); ++i10) {
                Throwable throwable3 = this.parseCauseX((JSONArray)jSONArray.get(i10));
                if (throwable != null) {
                    throwable.initCause(throwable3);
                }
                throwable = throwable3;
            }
        }
        return throwable2;
    }

    private SQLException parseSQLExceptionX(JSONArray jSONArray) {
        SQLException sQLException = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            sQLException = new SQLException((String)jSONArray.get(0), (String)jSONArray.get(1), ((Number)jSONArray.get(2)).intValue());
            sQLException.initCause(this.parseCause((JSONArray)jSONArray.get(3)));
        }
        return sQLException;
    }

    SQLException parseSQLException(JSONArray jSONArray) {
        SQLException sQLException = null;
        if (jSONArray != null && jSONArray.size() > 0 && (sQLException = this.parseSQLExceptionX((JSONArray)jSONArray.get(0))) != null) {
            for (int i10 = 1; i10 < jSONArray.size(); ++i10) {
                SQLException sQLException2 = this.parseSQLExceptionX((JSONArray)jSONArray.get(i10));
                sQLException.setNextException(sQLException2);
            }
        }
        return sQLException;
    }

    private ClientInfo parseClientInfo(JSONArray jSONArray, int n2) {
        ClientInfo clientInfo = null;
        if (jSONArray != null) {
            clientInfo = n2 >= 10 ? new ClientInfo((String)jSONArray.get(0), (String)jSONArray.get(1), (String)jSONArray.get(2), (String)jSONArray.get(3), (String)jSONArray.get(4)) : new ClientInfo((String)jSONArray.get(0), (String)jSONArray.get(1), (String)jSONArray.get(2), (String)jSONArray.get(3));
        }
        return clientInfo;
    }

    private HashSet<ClientInfo> parseClientInfoSet(JSONArray jSONArray, int n2) {
        HashSet<ClientInfo> hashSet = null;
        if (jSONArray != null) {
            hashSet = new HashSet<ClientInfo>();
            for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
                hashSet.add(this.parseClientInfo((JSONArray)jSONArray.get(i10), n2));
            }
        }
        return hashSet;
    }

    Set<ClientInfo>[] parseClientInfoSets(JSONArray jSONArray, int n2) {
        ArrayList<HashSet<ClientInfo>> arrayList = null;
        if (jSONArray != null) {
            arrayList = new ArrayList<HashSet<ClientInfo>>();
            for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
                arrayList.add(this.parseClientInfoSet((JSONArray)jSONArray.get(i10), n2));
            }
        }
        return ControllerMessageHelper.getInstance().clientInfoSetsListToArray(arrayList);
    }

    HashMap<String, com.ibm.db2.cmx.TransportPoolStatistics> parseTransportPoolStatisticsObject(JSONObject jSONObject) {
        HashMap<String, com.ibm.db2.cmx.TransportPoolStatistics> hashMap = null;
        if (jSONObject != null) {
            hashMap = new HashMap<String, com.ibm.db2.cmx.TransportPoolStatistics>();
            for (Object k10 : jSONObject.keySet()) {
                hashMap.put((String)k10, this.parseTransportPoolStatistic((JSONArray)jSONObject.get(k10)));
            }
        }
        return hashMap;
    }

    private TransportPoolStatistics.MemberAllocation[] parseMemberAllocations(JSONArray jSONArray) {
        TransportPoolStatistics.MemberAllocation[] memberAllocationArray = null;
        if (jSONArray != null) {
            memberAllocationArray = new TransportPoolStatistics.MemberAllocation[jSONArray.size()];
            for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
                TransportPoolStatistics.MemberAllocation memberAllocation = null;
                if (jSONArray.get(i10) != null) {
                    JSONArray jSONArray2 = (JSONArray)jSONArray.get(i10);
                    memberAllocation = new TransportPoolStatistics.MemberAllocation((String)jSONArray2.get(0), ((Number)jSONArray2.get(1)).intValue(), ((Number)jSONArray2.get(2)).intValue(), ((Number)jSONArray2.get(3)).intValue());
                }
                memberAllocationArray[i10] = memberAllocation;
            }
        }
        return memberAllocationArray;
    }

    private com.ibm.db2.cmx.TransportPoolStatistics parseTransportPoolStatistic(JSONArray jSONArray) {
        TransportPoolStatistics transportPoolStatistics = null;
        if (jSONArray != null) {
            transportPoolStatistics = new TransportPoolStatistics();
            transportPoolStatistics.setMemberAllocations(this.parseMemberAllocations((JSONArray)jSONArray.get(0)));
            transportPoolStatistics.setAgedOutObjectCount(((Number)jSONArray.get(1)).intValue());
            transportPoolStatistics.setCreatedObjectCount(((Number)jSONArray.get(2)).intValue());
            transportPoolStatistics.setHeavyWeightReusedObjectCount(((Number)jSONArray.get(3)).intValue());
            transportPoolStatistics.setLightWeightReusedObjectCount(((Number)jSONArray.get(4)).intValue());
            transportPoolStatistics.setLongestBlockedRequestTime(TransportPoolStatistics.TimePrecision.valueOf((String)jSONArray.get(5)), ((Number)jSONArray.get(6)).longValue());
            transportPoolStatistics.setNumberOfConnectionReleasesRefused(((Number)jSONArray.get(7)).intValue());
            transportPoolStatistics.setNumberOfRequestsBlocked(((Number)jSONArray.get(8)).intValue());
            transportPoolStatistics.setNumberOfRequestsBlockedDataSourceMax(((Number)jSONArray.get(9)).intValue());
            transportPoolStatistics.setRemovedObjectCount(((Number)jSONArray.get(10)).intValue());
            transportPoolStatistics.setShortestBlockedRequestTime(TransportPoolStatistics.TimePrecision.valueOf((String)jSONArray.get(11)), ((Number)jSONArray.get(12)).longValue());
            transportPoolStatistics.setSuccessfulRequestsFromPool(((Number)jSONArray.get(13)).intValue());
            transportPoolStatistics.setTotalPoolObjects(((Number)jSONArray.get(14)).intValue());
            transportPoolStatistics.setTotalRequestsToPool(((Number)jSONArray.get(15)).intValue());
            transportPoolStatistics.setTotalTimeBlocked(TransportPoolStatistics.TimePrecision.valueOf((String)jSONArray.get(16)), ((Number)jSONArray.get(17)).longValue());
            transportPoolStatistics.setHwmForConcurrentlyAllocatedTransports(((Number)jSONArray.get(18)).intValue());
            if (jSONArray.size() > 19) {
                transportPoolStatistics.setNumberOfRequestsBlockedPoolMax(((Number)jSONArray.get(19)).intValue());
            }
        }
        return transportPoolStatistics;
    }

    public DataSourceDescriptor newDataSourceDescriptor(Map<String, Object> map) {
        DriverDescriptor driverDescriptor = this.newDriverDescriptor();
        return new DataSourceDescriptor(driverDescriptor, (String)map.get("dsDescriptorProfileName"), (String)map.get("dsDescriptorJDBCDSName"), ((Number)map.get("dsDescriptorWASMaxPoolSize")).intValue(), (String)map.get("dsDescriptorWASJNDIDSName"), (String)map.get("dsDescriptorDBServer"), ((Number)map.get("dsDescriptorDBPort")).intValue(), (String)map.get("dsDescriptorDBName"), (HashMap)map.get("dsDescriptorClientPropertySettings"));
    }

    DataSourceDescriptor parseDataSourceDescriptor(DriverDescriptor driverDescriptor, JSONObject jSONObject) {
        return new DataSourceDescriptor(driverDescriptor, (String)jSONObject.get("dsDescriptorProfileName"), (String)jSONObject.get("dsDescriptorJDBCDSName"), ((Number)jSONObject.get("dsDescriptorWASMaxPoolSize")).intValue(), (String)jSONObject.get("dsDescriptorWASJNDIDSName"), (String)jSONObject.get("dsDescriptorDBServer"), ((Number)jSONObject.get("dsDescriptorDBPort")).intValue(), (String)jSONObject.get("dsDescriptorDBName"), JSONHelper.createObjectHashMapFromJSONObject((JSONObject)jSONObject.get("dsDescriptorClientPropertySettings")));
    }

    public DriverDescriptor newDriverDescriptor() {
        Map<String, Object> map = ControlDriver.getInstance().getDriverDescriptorMap();
        ProductInformation.Driver driver = null;
        ProductInformation.CMX cMX = null;
        ProductInformation.WAS wAS = null;
        ProductInformation.Client client = null;
        driver = new ProductInformation.Driver(ProductInformation.Driver.DriverKind.valueOf((String)map.get("driverKind")), (String)map.get("driverName"), ((Number)map.get("driverMajorVersion")).intValue(), ((Number)map.get("driverMinorVersion")).intValue(), ((Number)map.get("driverMicroVersion")).intValue(), (String)map.get("driverBuildQualifier"), ProductInformation.Basic.BuildCertification.valueOf((String)map.get("driverBuildCertification")));
        cMX = new ProductInformation.CMX((String)map.get("cmxComponentName"), ((Number)map.get("cmxMajorVersion")).intValue(), ((Number)map.get("cmxMinorVersion")).intValue(), ((Number)map.get("cmxMicroVersion")).intValue(), (String)map.get("cmxBuildQualifier"), ProductInformation.Basic.BuildCertification.valueOf((String)map.get("cmxBuildCertification")), ((Number)map.get("cmxSpecVersion")).intValue());
        wAS = new ProductInformation.WAS((String)map.get("wasServerName"), (String)map.get("wasServerVersion"));
        client = new ProductInformation.Client(driver, cMX, wAS);
        DriverDescriptor driverDescriptor = new DriverDescriptor((String)map.get("driverDescriptorUUID"), (String[])map.get("driverDescriptorClientIP"), client, (HashMap)map.get("driverDescriptorClientPropertySettings"));
        return driverDescriptor;
    }

    DriverDescriptor parseDriverDescriptor(JSONObject jSONObject) {
        ProductInformation.Driver driver = null;
        ProductInformation.CMX cMX = null;
        ProductInformation.WAS wAS = null;
        ProductInformation.Client client = null;
        DriverDescriptor driverDescriptor = null;
        if (jSONObject != null) {
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("driverDescriptorClientProductInformation");
            if (jSONObject2 != null) {
                driver = new ProductInformation.Driver(ProductInformation.Driver.DriverKind.valueOf((String)jSONObject2.get("driverKind")), (String)jSONObject2.get("driverName"), ((Number)jSONObject2.get("driverMajorVersion")).intValue(), ((Number)jSONObject2.get("driverMinorVersion")).intValue(), ((Number)jSONObject2.get("driverMicroVersion")).intValue(), (String)jSONObject2.get("driverBuildQualifier"), ProductInformation.Basic.BuildCertification.valueOf((String)jSONObject2.get("driverBuildCertification")));
                cMX = new ProductInformation.CMX((String)jSONObject2.get("cmxComponentName"), ((Number)jSONObject2.get("cmxMajorVersion")).intValue(), ((Number)jSONObject2.get("cmxMinorVersion")).intValue(), ((Number)jSONObject2.get("cmxMicroVersion")).intValue(), (String)jSONObject2.get("cmxBuildQualifier"), ProductInformation.Basic.BuildCertification.valueOf((String)jSONObject2.get("cmxBuildCertification")), ((Number)jSONObject2.get("cmxSpecVersion")).intValue());
                wAS = new ProductInformation.WAS((String)jSONObject2.get("wasServerName"), (String)jSONObject2.get("wasServerVersion"));
                client = new ProductInformation.Client(driver, cMX, wAS);
            }
            driverDescriptor = new DriverDescriptor((String)jSONObject.get("driverDescriptorUUID"), JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONObject.get("driverDescriptorClientIP")), client, JSONHelper.createObjectHashMapFromJSONObject((JSONObject)jSONObject.get("driverDescriptorClientPropertySettings")));
        }
        return driverDescriptor;
    }

    private TransportPoolStatistics.MemberAllocation[] createMemberAllocationArray(Object[][] objectArray) {
        TransportPoolStatistics.MemberAllocation[] memberAllocationArray = null;
        if (objectArray != null) {
            memberAllocationArray = new TransportPoolStatistics.MemberAllocation[objectArray.length];
            for (int i10 = 0; i10 < objectArray.length; ++i10) {
                memberAllocationArray[i10] = new TransportPoolStatistics.MemberAllocation((String)objectArray[i10][0], ((Number)objectArray[i10][1]).intValue(), ((Number)objectArray[i10][2]).intValue(), ((Number)objectArray[i10][3]).intValue());
            }
        }
        return memberAllocationArray;
    }

    public com.ibm.db2.cmx.TransportPoolStatistics createTransportPoolStatistics(Database database) {
        Object[] objectArray = null;
        TransportPoolStatistics transportPoolStatistics = null;
        if (database != null && database.getLogicalName() != null && Configuration.isJCCAtCMX5ProtocolLevel__) {
            objectArray = GlobalProperties.pullData(5001, new Object[]{database.getServerName(), new Integer(database.getPort()), database.getDatabaseName()});
        }
        if (objectArray != null) {
            transportPoolStatistics = new TransportPoolStatistics();
            transportPoolStatistics.setMemberAllocations(this.createMemberAllocationArray((Object[][])objectArray[0]));
            transportPoolStatistics.setAgedOutObjectCount(((Number)objectArray[1]).intValue());
            transportPoolStatistics.setCreatedObjectCount(((Number)objectArray[2]).intValue());
            transportPoolStatistics.setHeavyWeightReusedObjectCount(((Number)objectArray[3]).intValue());
            transportPoolStatistics.setLightWeightReusedObjectCount(((Number)objectArray[4]).intValue());
            transportPoolStatistics.setLongestBlockedRequestTime(TransportPoolStatistics.TimePrecision.values()[((Number)objectArray[5]).intValue()], ((Number)objectArray[6]).longValue());
            transportPoolStatistics.setNumberOfConnectionReleasesRefused(((Number)objectArray[7]).intValue());
            transportPoolStatistics.setNumberOfRequestsBlocked(((Number)objectArray[8]).intValue());
            transportPoolStatistics.setNumberOfRequestsBlockedDataSourceMax(((Number)objectArray[9]).intValue());
            transportPoolStatistics.setNumberOfRequestsBlockedPoolMax(((Number)objectArray[10]).intValue());
            transportPoolStatistics.setRemovedObjectCount(((Number)objectArray[11]).intValue());
            transportPoolStatistics.setShortestBlockedRequestTime(TransportPoolStatistics.TimePrecision.values()[((Number)objectArray[12]).intValue()], ((Number)objectArray[13]).longValue());
            transportPoolStatistics.setSuccessfulRequestsFromPool(((Number)objectArray[14]).intValue());
            transportPoolStatistics.setTotalPoolObjects(((Number)objectArray[15]).intValue());
            transportPoolStatistics.setTotalRequestsToPool(((Number)objectArray[16]).intValue());
            transportPoolStatistics.setTotalTimeBlocked(TransportPoolStatistics.TimePrecision.values()[((Number)objectArray[17]).intValue()], ((Number)objectArray[18]).longValue());
            transportPoolStatistics.setHwmForConcurrentlyAllocatedTransports(((Number)objectArray[19]).intValue());
        }
        return transportPoolStatistics;
    }

    long[] parseNumberOfTransactionsPenaltyBoxedForDataSource(JSONArray jSONArray) {
        long[] lArray = null;
        int n2 = 0;
        if (jSONArray != null && jSONArray.size() > 0) {
            lArray = new long[jSONArray.size()];
            for (n2 = 0; n2 < jSONArray.size(); ++n2) {
                lArray[n2] = ((Number)jSONArray.get(n2)).longValue();
            }
        }
        return lArray;
    }

    long[][] parseNumberOfTransactionsPenaltyBoxed(JSONArray jSONArray) {
        Object object = null;
        int n2 = 0;
        int n3 = 0;
        if (jSONArray != null && jSONArray.size() > 0) {
            JSONArray jSONArray2 = null;
            object = new long[jSONArray.size()][];
            for (n2 = 0; n2 < jSONArray.size(); ++n2) {
                jSONArray2 = (JSONArray)jSONArray.get(n2);
                if (jSONArray2 != null && jSONArray2.size() > 0) {
                    object[n2] = new long[jSONArray2.size()];
                    for (n3 = 0; n3 < jSONArray2.size(); ++n3) {
                        object[n2][n3] = ((Number)jSONArray2.get(n3)).longValue();
                    }
                    continue;
                }
                object[n2] = null;
            }
        }
        return object;
    }

    Object[][] parseWASPoolStatistics(JSONArray jSONArray) {
        Object[][] objectArray = null;
        int n2 = 0;
        int n3 = 0;
        if (jSONArray != null && jSONArray.size() > 0) {
            JSONArray jSONArray2 = null;
            objectArray = new Object[jSONArray.size()][];
            for (n2 = 0; n2 < jSONArray.size(); ++n2) {
                jSONArray2 = (JSONArray)jSONArray.get(n2);
                if (jSONArray2 != null && jSONArray2.size() > 0) {
                    objectArray[n2] = new Object[jSONArray2.size()];
                    for (n3 = 0; n3 < jSONArray2.size(); ++n3) {
                        objectArray[n2][n3] = jSONArray2.get(n3);
                    }
                    continue;
                }
                objectArray[n2] = null;
            }
        }
        return objectArray;
    }

    String[] parseDatabaseLogicalNames(JSONArray jSONArray) {
        String[] stringArray = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            stringArray = new String[jSONArray.size()];
            for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
                stringArray[i10] = (String)jSONArray.get(i10);
            }
        }
        return stringArray;
    }

    DataSourceDescriptor[] parseDataSourceDescriptors(DriverDescriptor driverDescriptor, JSONArray jSONArray) {
        DataSourceDescriptor[] dataSourceDescriptorArray = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            dataSourceDescriptorArray = new DataSourceDescriptor[jSONArray.size()];
            for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
                dataSourceDescriptorArray[i10] = this.parseDataSourceDescriptor(driverDescriptor, (JSONObject)jSONArray.get(i10));
            }
        }
        return dataSourceDescriptorArray;
    }

    HashMap<String, String>[] parseWASPoolConfigStatus(JSONArray jSONArray) {
        HashMap[] hashMapArray = null;
        if (jSONArray != null && jSONArray.size() > 0) {
            hashMapArray = new HashMap[jSONArray.size()];
            for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
                hashMapArray[i10] = JSONHelper.createStringHashMapFromJSONObject((JSONObject)jSONArray.get(i10));
            }
        }
        return hashMapArray;
    }
}

