/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth;

import com.ibm.cloud.objectstorage.AmazonClientException;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.InstanceMetadataServiceCredentialsFetcher;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceProfileCredentialsProvider
implements AWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(InstanceProfileCredentialsProvider.class);
    private static final int ASYNC_REFRESH_INTERVAL_TIME_MINUTES = 1;
    private static final InstanceProfileCredentialsProvider INSTANCE = new InstanceProfileCredentialsProvider();
    private final InstanceMetadataServiceCredentialsFetcher credentialsFetcher = new InstanceMetadataServiceCredentialsFetcher();
    private volatile ScheduledExecutorService executor;
    private volatile boolean shouldRefresh = false;

    @Deprecated
    public InstanceProfileCredentialsProvider() {
        this(false);
    }

    public InstanceProfileCredentialsProvider(boolean refreshCredentialsAsync) {
        this(refreshCredentialsAsync, true);
    }

    public static InstanceProfileCredentialsProvider createAsyncRefreshingProvider(boolean eagerlyRefreshCredentialsAsync) {
        return new InstanceProfileCredentialsProvider(true, eagerlyRefreshCredentialsAsync);
    }

    private InstanceProfileCredentialsProvider(boolean refreshCredentialsAsync, boolean eagerlyRefreshCredentialsAsync) {
        this.shouldRefresh = eagerlyRefreshCredentialsAsync;
        if (refreshCredentialsAsync) {
            this.executor = Executors.newScheduledThreadPool(1);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (InstanceProfileCredentialsProvider.this.shouldRefresh) {
                            InstanceProfileCredentialsProvider.this.credentialsFetcher.getCredentials();
                        }
                    }
                    catch (AmazonClientException ace) {
                        InstanceProfileCredentialsProvider.this.handleError(ace);
                    }
                    catch (RuntimeException re) {
                        InstanceProfileCredentialsProvider.this.handleError(re);
                    }
                    catch (Error e) {
                        InstanceProfileCredentialsProvider.this.handleError(e);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
    }

    public static InstanceProfileCredentialsProvider getInstance() {
        return INSTANCE;
    }

    private void handleError(Throwable t) {
        this.refresh();
        LOG.error((Object)t.getMessage(), t);
    }

    protected void finalize() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        AWSCredentials creds = this.credentialsFetcher.getCredentials();
        this.shouldRefresh = true;
        return creds;
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }
}

