/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.oauth;

import com.ibm.cloud.objectstorage.ClientConfiguration;
import com.ibm.cloud.objectstorage.SDKGlobalConfiguration;
import com.ibm.cloud.objectstorage.http.apache.SdkProxyRoutePlanner;
import com.ibm.cloud.objectstorage.http.apache.utils.ApacheUtils;
import com.ibm.cloud.objectstorage.http.settings.HttpClientSettings;
import com.ibm.cloud.objectstorage.log.InternalLogApi;
import com.ibm.cloud.objectstorage.log.InternalLogFactory;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenProvider;
import com.ibm.cloud.objectstorage.oauth.DelegateTokenProvider;
import com.ibm.cloud.objectstorage.oauth.OAuthServiceException;
import com.ibm.cloud.objectstorage.oauth.Token;
import com.ibm.cloud.objectstorage.oauth.TokenManager;
import com.ibm.cloud.objectstorage.oauth.TokenProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClientBuilder;

public class DefaultTokenManager
implements TokenManager {
    protected static final InternalLogApi log = InternalLogFactory.getLog(DefaultTokenManager.class);
    private TokenProvider provider;
    private volatile Token token;
    private volatile boolean asyncInProgress = false;
    private String iamEndpoint = SDKGlobalConfiguration.IAM_ENDPOINT;
    private int iamMaxRetry = SDKGlobalConfiguration.IAM_MAX_RETRY;
    private double iamRefreshOffset = SDKGlobalConfiguration.IAM_REFRESH_OFFSET;
    private ClientConfiguration clientConfiguration;
    private HttpClientSettings httpClientSettings;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final Set<Integer> NON_RETRYABLE_STATUS_CODES = new HashSet<Integer>(4);

    public DefaultTokenManager(String apiKey) {
        log.debug("DefaultTokenManager api key constructor");
        this.provider = new DefaultTokenProvider(apiKey);
    }

    public DefaultTokenManager(TokenProvider provider) {
        this.provider = provider;
    }

    public void setIamEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
        if (this.getProvider() instanceof DefaultTokenProvider) {
            DefaultTokenProvider defaultProvider = (DefaultTokenProvider)this.getProvider();
            defaultProvider.setIamEndpoint(iamEndpoint);
        }
    }

    public void setIamRefreshOffset(double offset) {
        this.iamRefreshOffset = offset;
    }

    public void setIamMaxRetry(int count) {
        this.iamMaxRetry = count;
    }

    public TokenProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getToken() {
        log.debug("DefaultTokenManager getToken()");
        if (!this.checkCache()) {
            this.retrieveToken();
        }
        if (this.token == null) {
            this.token = this.retrieveTokenFromCache();
        }
        if (this.hasTokenExpired(this.token)) {
            this.token = this.retrieveTokenFromCache();
        }
        if (this.isTokenExpiring(this.token) && !this.isAsyncInProgress()) {
            if (null != this.token.getRefresh_token() && "not_supported" != this.token.getRefresh_token()) {
                this.asyncInProgress = true;
                this.submitRefreshTask();
            } else {
                this.retrieveToken();
                this.token = this.retrieveTokenFromCache();
            }
        }
        if (this.token.getAccess_token() != null && !this.token.getAccess_token().isEmpty()) {
            return this.token.getAccess_token();
        }
        if (this.token.getDelegated_refresh_token() != null && !this.token.getDelegated_refresh_token().isEmpty()) {
            return this.token.getDelegated_refresh_token();
        }
        if (this.token.getIms_token() != null && !this.token.getIms_token().isEmpty()) {
            return this.token.getIms_token();
        }
        return this.token.getUaa_token();
    }

    protected boolean checkCache() {
        log.debug("OAuthTokenManager.checkCache()");
        boolean tokenExists = this.getCachedToken() != null;
        return tokenExists;
    }

    protected synchronized void cacheToken(Token token) {
        long tokenExpirationTime;
        int tokenExpiresInSecs;
        log.debug("OAuthTokenManager.cacheToken");
        try {
            tokenExpiresInSecs = Integer.parseInt(token.getExpires_in());
        }
        catch (NumberFormatException exception) {
            tokenExpiresInSecs = 0;
        }
        try {
            tokenExpirationTime = Long.parseLong(token.getExpiration());
        }
        catch (NumberFormatException exception) {
            tokenExpirationTime = 0L;
        }
        long refreshBeforeExpirySecs = (long)((double)tokenExpiresInSecs * this.iamRefreshOffset);
        long tokenRefreshTime = tokenExpirationTime - refreshBeforeExpirySecs;
        token.setRefreshTime(tokenRefreshTime);
        token.setExpirationTime(tokenExpirationTime);
        this.setTokenCache(token);
    }

    protected Token retrieveTokenFromCache() {
        log.debug("OAuthTokenManager.retrieveTokenFromCache");
        return this.getCachedToken();
    }

    protected boolean hasTokenExpired(Token token) {
        log.debug("OAuthTokenManager.hasTokenExpired");
        long currentTime = System.currentTimeMillis() / 1000L;
        if (Long.valueOf(token.getExpiration()) < currentTime) {
            this.retrieveToken();
            return true;
        }
        return false;
    }

    protected boolean isTokenExpiring(Token token) {
        log.debug("OAuthTokenManager.isTokenExpiring");
        long currentTime = System.currentTimeMillis() / 1000L;
        if (currentTime > token.getRefreshTime()) {
            log.debug("Token is expiring");
            return true;
        }
        log.debug("Token is not expiring." + token.getRefreshTime() + " > " + currentTime);
        return false;
    }

    protected Token getCachedToken() {
        return this.token;
    }

    protected void setTokenCache(Token token) {
        this.token = token;
    }

    protected synchronized void retrieveToken() {
        log.debug("OAuthTokenManager.retrieveToken");
        if (this.token == null || Long.valueOf(this.token.getExpiration()) < System.currentTimeMillis() / 1000L) {
            log.debug("Token needs to be refreshed, retrieving from provider");
            for (int attempt = 1; attempt <= this.iamMaxRetry; ++attempt) {
                try {
                    this.token = this.provider.retrieveToken();
                    break;
                }
                catch (OAuthServiceException exception) {
                    log.debug("Exception retrieving IAM token on attempt " + attempt + ". Returned status code " + exception.getStatusCode() + ". Error Message: " + exception.getErrorMessage() + ". Status Message: " + exception.getStatusMessage());
                    if (attempt < this.iamMaxRetry) continue;
                    throw exception;
                }
            }
            if (this.token == null) {
                throw new OAuthServiceException("TokenProvider.retrieveToken()  returned null and instead of throwing an exception. This is a bug. Custom TokenProvider classes should return a token or thrown exceptions.");
            }
            this.cacheToken(this.token);
        }
    }

    protected void submitRefreshTask() {
        TokenRefreshTask tokenRefreshTask = new TokenRefreshTask(this);
        this.executor.execute(tokenRefreshTask);
        log.debug("Submitted token refresh task");
    }

    protected boolean isAsyncInProgress() {
        log.debug("Aysnchrnonous job in progress : " + this.asyncInProgress);
        return this.asyncInProgress;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        if (clientConfiguration != null) {
            this.httpClientSettings = HttpClientSettings.adapt(clientConfiguration);
            if (this.getProvider() instanceof DefaultTokenProvider) {
                DefaultTokenProvider defaultProvider = (DefaultTokenProvider)this.getProvider();
                defaultProvider.setHttpClientSettings(this.httpClientSettings);
            }
            if (this.getProvider() instanceof DelegateTokenProvider) {
                DelegateTokenProvider delegateProvider = (DelegateTokenProvider)this.getProvider();
                delegateProvider.setHttpClientSettings(this.httpClientSettings);
            }
        }
    }

    private boolean shouldRetry(int statusCode) {
        return !NON_RETRYABLE_STATUS_CODES.contains(statusCode);
    }

    protected void finalize() throws Throwable {
        try {
            this.executor.shutdown();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }

    public static void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (settings.isProxyEnabled()) {
            log.info("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort() + " Proxy Protocol: " + (Object)((Object)settings.getProxyProtocol()));
            builder.setRoutePlanner((HttpRoutePlanner)new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getProxyProtocol(), settings.getNonProxyHosts()));
            if (settings.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    static {
        NON_RETRYABLE_STATUS_CODES.add(400);
        NON_RETRYABLE_STATUS_CODES.add(401);
        NON_RETRYABLE_STATUS_CODES.add(403);
        NON_RETRYABLE_STATUS_CODES.add(404);
    }

    class TokenRefreshTask
    implements Runnable {
        private DefaultTokenManager tokenManager;
        private Token refreshedToken = null;

        TokenRefreshTask(DefaultTokenManager tokenManager) {
            this.tokenManager = tokenManager;
        }

        @Override
        public void run() {
            try {
                if (!(this.tokenManager.getProvider() instanceof DefaultTokenProvider)) {
                    log.info("OAuthTokenManager.TokenRefreshTask: Token Provider is not of type DefaultTokenProvider, so using the refresh token is not supported.");
                    return;
                }
                while (this.refreshedToken == null && System.currentTimeMillis() / 1000L < this.tokenManager.token.getExpirationTime()) {
                    try {
                        log.info("OAuthTokenManager.TokenRefreshTask: Attempting to retrieve refresh token");
                        this.refreshedToken = ((DefaultTokenProvider)this.tokenManager.getProvider()).retrieveTokenWithRefresh(this.tokenManager.token.getRefresh_token());
                        break;
                    }
                    catch (OAuthServiceException exception) {
                        log.info("OAuthTokenManager.TokenRefreshTask: Exception retrieving IAM token. Returned status code " + exception.getStatusCode() + ". Error Message: " + exception.getErrorMessage() + ". Status Message: " + exception.getStatusMessage());
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException e) {
                            log.info("Token refresh task interrupted: " + e.getMessage());
                        }
                        if (System.currentTimeMillis() / 1000L < this.tokenManager.token.getExpirationTime()) continue;
                        throw exception;
                    }
                }
                if (this.refreshedToken != null) {
                    this.tokenManager.cacheToken(this.refreshedToken);
                    log.info("OAuthTokenManager.TokenRefreshTask: Token refreshed");
                } else {
                    if (System.currentTimeMillis() / 1000L < this.tokenManager.token.getExpirationTime()) {
                        log.info("OAuthTokenManager.TokenRefreshTask: Refresh aborted before token expiration");
                        throw new OAuthServiceException("OAuthTokenManager.TokenRefreshTask:  TokenProvider.retrieveTokenWithRefresh() returned null and instead of throwing an exception. This is a bug. Custom TokenProvider classes should return a token or thrown exceptions.");
                    }
                    log.info("OAuthTokenManager.TokenRefreshTask: Failed to refresh token");
                }
            }
            finally {
                this.tokenManager.asyncInProgress = false;
            }
        }
    }
}

