/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.client.builder;

import com.ibm.cloud.objectstorage.AmazonWebServiceClient;
import com.ibm.cloud.objectstorage.ClientConfiguration;
import com.ibm.cloud.objectstorage.ClientConfigurationFactory;
import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.annotation.NotThreadSafe;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.annotation.SdkProtectedApi;
import com.ibm.cloud.objectstorage.annotation.SdkTestInternalApi;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.DefaultAWSCredentialsProviderChain;
import com.ibm.cloud.objectstorage.client.AwsAsyncClientParams;
import com.ibm.cloud.objectstorage.client.AwsSyncClientParams;
import com.ibm.cloud.objectstorage.handlers.RequestHandler2;
import com.ibm.cloud.objectstorage.metrics.RequestMetricCollector;
import com.ibm.cloud.objectstorage.monitoring.MonitoringListener;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenManager;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenProvider;
import com.ibm.cloud.objectstorage.oauth.IBMOAuthCredentials;
import com.ibm.cloud.objectstorage.regions.AwsRegionProvider;
import com.ibm.cloud.objectstorage.regions.DefaultAwsRegionProviderChain;
import com.ibm.cloud.objectstorage.regions.Region;
import com.ibm.cloud.objectstorage.regions.RegionUtils;
import com.ibm.cloud.objectstorage.regions.Regions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;

@NotThreadSafe
@SdkProtectedApi
public abstract class AwsClientBuilder<Subclass extends AwsClientBuilder, TypeToBuild> {
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    private final ClientConfigurationFactory clientConfigFactory;
    private final AwsRegionProvider regionProvider;
    private AWSCredentialsProvider credentials;
    private ClientConfiguration clientConfig;
    private RequestMetricCollector metricsCollector;
    private Region region;
    private List<RequestHandler2> requestHandlers;
    private EndpointConfiguration endpointConfiguration;
    private MonitoringListener monitoringListener;
    private String iamEndpoint;
    private double iamTokenRefreshOffset;
    private int iamMaxRetry;

    protected AwsClientBuilder(ClientConfigurationFactory clientConfigFactory) {
        this(clientConfigFactory, DEFAULT_REGION_PROVIDER);
    }

    @SdkTestInternalApi
    protected AwsClientBuilder(ClientConfigurationFactory clientConfigFactory, AwsRegionProvider regionProvider) {
        this.clientConfigFactory = clientConfigFactory;
        this.regionProvider = regionProvider;
    }

    public final AWSCredentialsProvider getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(AWSCredentialsProvider credentialsProvider) {
        this.credentials = credentialsProvider;
        if (null != this.iamEndpoint && this.credentials.getCredentials() instanceof IBMOAuthCredentials && ((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager() instanceof DefaultTokenManager) {
            ((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).setIamEndpoint(this.iamEndpoint);
            if (((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).getProvider() instanceof DefaultTokenProvider) {
                ((DefaultTokenProvider)((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).getProvider()).setIamEndpoint(this.iamEndpoint);
            }
        }
        if (this.iamTokenRefreshOffset > 0.0 && this.credentials.getCredentials() instanceof IBMOAuthCredentials && ((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager() instanceof DefaultTokenManager) {
            ((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).setIamRefreshOffset(this.iamTokenRefreshOffset);
        }
        if (this.iamMaxRetry > 0 && this.credentials.getCredentials() instanceof IBMOAuthCredentials && ((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager() instanceof DefaultTokenManager) {
            ((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).setIamMaxRetry(this.iamMaxRetry);
        }
    }

    public final Subclass withCredentials(AWSCredentialsProvider credentialsProvider) {
        this.setCredentials(credentialsProvider);
        return this.getSubclass();
    }

    public Subclass withIAMEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
        if (this.credentials.getCredentials() instanceof IBMOAuthCredentials && ((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager() instanceof DefaultTokenManager) {
            ((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).setIamEndpoint(iamEndpoint);
            if (((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).getProvider() instanceof DefaultTokenProvider) {
                ((DefaultTokenProvider)((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).getProvider()).setIamEndpoint(iamEndpoint);
                ((DefaultTokenProvider)((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).getProvider()).retrieveToken();
            }
        }
        return this.getSubclass();
    }

    public Subclass withIAMTokenRefresh(double offset) {
        this.iamTokenRefreshOffset = offset;
        if (offset > 0.0 && this.credentials.getCredentials() instanceof IBMOAuthCredentials && ((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager() instanceof DefaultTokenManager) {
            ((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).setIamRefreshOffset(this.iamTokenRefreshOffset);
        }
        return this.getSubclass();
    }

    public Subclass withIAMMaxRetry(int retryCount) {
        this.iamMaxRetry = retryCount;
        if (retryCount > 0 && this.credentials.getCredentials() instanceof IBMOAuthCredentials && ((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager() instanceof DefaultTokenManager) {
            ((DefaultTokenManager)((IBMOAuthCredentials)this.credentials.getCredentials()).getTokenManager()).setIamMaxRetry(this.iamMaxRetry);
        }
        return this.getSubclass();
    }

    private AWSCredentialsProvider resolveCredentials() {
        return this.credentials == null ? DefaultAWSCredentialsProviderChain.getInstance() : this.credentials;
    }

    public final ClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }

    public final void setClientConfiguration(ClientConfiguration config) {
        this.clientConfig = config;
    }

    public final Subclass withClientConfiguration(ClientConfiguration config) {
        this.setClientConfiguration(config);
        return this.getSubclass();
    }

    private ClientConfiguration resolveClientConfiguration() {
        return this.clientConfig == null ? this.clientConfigFactory.getConfig() : new ClientConfiguration(this.clientConfig);
    }

    public final RequestMetricCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    public final void setMetricsCollector(RequestMetricCollector metrics) {
        this.metricsCollector = metrics;
    }

    public final Subclass withMetricsCollector(RequestMetricCollector metrics) {
        this.setMetricsCollector(metrics);
        return this.getSubclass();
    }

    public final String getRegion() {
        return this.region == null ? null : this.region.getName();
    }

    public final void setRegion(String region) {
        this.withRegion(region);
    }

    public final Subclass withRegion(Regions region) {
        return this.withRegion(region.getName());
    }

    public final Subclass withRegion(String region) {
        return this.withRegion(this.getRegionObject(region));
    }

    private Region getRegionObject(String regionStr) {
        Region regionObj = RegionUtils.getRegion(regionStr);
        if (regionObj == null) {
            throw new SdkClientException(String.format("Could not find region information for '%s' in SDK metadata.", regionStr));
        }
        return regionObj;
    }

    private Subclass withRegion(Region region) {
        this.region = region;
        return this.getSubclass();
    }

    public final EndpointConfiguration getEndpoint() {
        return this.endpointConfiguration;
    }

    public final void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.withEndpointConfiguration(endpointConfiguration);
    }

    public final Subclass withEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        return this.getSubclass();
    }

    public final List<RequestHandler2> getRequestHandlers() {
        return this.requestHandlers == null ? null : Collections.unmodifiableList(this.requestHandlers);
    }

    public final void setRequestHandlers(RequestHandler2 ... handlers) {
        this.requestHandlers = Arrays.asList(handlers);
    }

    public final Subclass withRequestHandlers(RequestHandler2 ... handlers) {
        this.setRequestHandlers(handlers);
        return this.getSubclass();
    }

    private List<RequestHandler2> resolveRequestHandlers() {
        return this.requestHandlers == null ? new ArrayList<RequestHandler2>() : new ArrayList<RequestHandler2>(this.requestHandlers);
    }

    @SdkInternalApi
    final TypeToBuild configureMutableProperties(TypeToBuild clientInterface) {
        AmazonWebServiceClient client = (AmazonWebServiceClient)clientInterface;
        this.setRegion(client);
        client.makeImmutable();
        return clientInterface;
    }

    public abstract TypeToBuild build();

    protected final AwsSyncClientParams getSyncClientParams() {
        return new SyncBuilderParams();
    }

    private void setRegion(AmazonWebServiceClient client) {
        if (this.region != null && this.endpointConfiguration != null) {
            throw new IllegalStateException("Only one of Region or EndpointConfiguration may be set.");
        }
        if (this.endpointConfiguration != null) {
            client.setEndpoint(this.endpointConfiguration.getServiceEndpoint());
            client.setSignerRegionOverride(this.endpointConfiguration.getSigningRegion());
        } else if (this.region != null) {
            client.setRegion(this.region);
        } else {
            String region = this.determineRegionFromRegionProvider();
            if (region != null) {
                client.setRegion(this.getRegionObject(region));
            } else {
                throw new SdkClientException("Unable to find a region via the region provider chain. Must provide an explicit region in the builder or setup environment to supply a region.");
            }
        }
    }

    private String determineRegionFromRegionProvider() {
        try {
            return this.regionProvider.getRegion();
        }
        catch (SdkClientException e) {
            return null;
        }
    }

    protected final Subclass getSubclass() {
        return (Subclass)this;
    }

    public static final class EndpointConfiguration {
        private final String serviceEndpoint;
        private final String signingRegion;

        public EndpointConfiguration(String serviceEndpoint, String signingRegion) {
            this.serviceEndpoint = serviceEndpoint;
            this.signingRegion = signingRegion;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public String getSigningRegion() {
            return this.signingRegion;
        }
    }

    protected class SyncBuilderParams
    extends AwsAsyncClientParams {
        private final ClientConfiguration _clientConfig;
        private final AWSCredentialsProvider _credentials;
        private final RequestMetricCollector _metricsCollector;
        private final List<RequestHandler2> _requestHandlers;
        private final MonitoringListener _monitoringListener;

        protected SyncBuilderParams() {
            this._clientConfig = AwsClientBuilder.this.resolveClientConfiguration();
            this._credentials = AwsClientBuilder.this.resolveCredentials();
            this._metricsCollector = AwsClientBuilder.this.metricsCollector;
            this._requestHandlers = AwsClientBuilder.this.resolveRequestHandlers();
            this._monitoringListener = AwsClientBuilder.this.monitoringListener;
        }

        @Override
        public AWSCredentialsProvider getCredentialsProvider() {
            return this._credentials;
        }

        @Override
        public ClientConfiguration getClientConfiguration() {
            return this._clientConfig;
        }

        @Override
        public RequestMetricCollector getRequestMetricCollector() {
            return this._metricsCollector;
        }

        @Override
        public List<RequestHandler2> getRequestHandlers() {
            return this._requestHandlers;
        }

        @Override
        public MonitoringListener getMonitoringListener() {
            return this._monitoringListener;
        }

        @Override
        public ExecutorService getExecutor() {
            throw new UnsupportedOperationException("ExecutorService is not used for sync client.");
        }
    }
}

