/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.util;

import com.ibm.cloud.objectstorage.annotation.ThreadSafe;
import com.ibm.cloud.objectstorage.internal.config.InternalConfig;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import com.ibm.cloud.objectstorage.util.ClassLoaderHelper;
import com.ibm.cloud.objectstorage.util.IOUtils;
import com.ibm.cloud.objectstorage.util.StringUtils;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarInputStream;

@ThreadSafe
public class VersionInfoUtils {
    static final String VERSION_INFO_FILE = "/com/ibm/cloud/objectstorage/sdk/versionInfo.properties";
    private static volatile String version;
    private static volatile String platform;
    private static volatile String userAgent;
    private static final Log log;
    private static final String UNKNOWN = "unknown";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (version != null) return version;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPlatform() {
        if (platform != null) return platform;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (platform != null) return platform;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (userAgent != null) return userAgent;
            VersionInfoUtils.initializeUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    private static void initializeVersion() {
        InputStream inputStream = ClassLoaderHelper.getResourceAsStream(VERSION_INFO_FILE, true, VersionInfoUtils.class);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("/com/ibm/cloud/objectstorage/sdk/versionInfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
            platform = versionInfoProperties.getProperty("platform");
        }
        catch (Exception e) {
            log.info("Unable to load version information for the running SDK: " + e.getMessage());
            version = "unknown-version";
            platform = "java";
        }
        finally {
            IOUtils.closeQuietly(inputStream, log);
        }
    }

    private static void initializeUserAgent() {
        userAgent = VersionInfoUtils.userAgent();
    }

    static String userAgent() {
        String ua = InternalConfig.Factory.getInternalConfig().getUserAgentTemplate();
        if (ua == null) {
            return "aws-sdk-java";
        }
        ua = ua.replace("aws", "ibm-cos").replace("{platform}", StringUtils.lowerCase(VersionInfoUtils.getPlatform())).replace("{version}", VersionInfoUtils.getVersion()).replace("{os.name}", VersionInfoUtils.replaceSpaces(System.getProperty("os.name"))).replace("{os.version}", VersionInfoUtils.replaceSpaces(System.getProperty("os.version"))).replace("{java.vm.name}", VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.name"))).replace("{java.vm.version}", VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.version"))).replace("{java.version}", VersionInfoUtils.replaceSpaces(System.getProperty("java.version"))).replace("{additional.languages}", VersionInfoUtils.getAdditionalJvmLanguages());
        String language = System.getProperty("user.language");
        String region = System.getProperty("user.region");
        String languageAndRegion = "";
        if (language != null && region != null) {
            languageAndRegion = " " + VersionInfoUtils.replaceSpaces(language) + "_" + VersionInfoUtils.replaceSpaces(region);
        }
        ua = ua.replace("{language.and.region}", languageAndRegion);
        return ua;
    }

    private static String replaceSpaces(String input) {
        return input == null ? UNKNOWN : input.replace(' ', '_');
    }

    private static String getAdditionalJvmLanguages() {
        return VersionInfoUtils.concat(VersionInfoUtils.concat("", VersionInfoUtils.scalaVersion(), " "), VersionInfoUtils.kotlinVersion(), " ");
    }

    private static String scalaVersion() {
        String scalaVersion;
        block3: {
            scalaVersion = "";
            try {
                Class<?> scalaProperties = Class.forName("scala.util.Properties");
                scalaVersion = "scala";
                String version = (String)scalaProperties.getMethod("versionNumberString", new Class[0]).invoke(null, new Object[0]);
                scalaVersion = VersionInfoUtils.concat(scalaVersion, version, "/");
            }
            catch (ClassNotFoundException scalaProperties) {
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Exception attempting to get Scala version.", e);
            }
        }
        return scalaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String kotlinVersion() {
        String kotlinVersion = "";
        JarInputStream kotlinJar = null;
        try {
            Class<?> kotlinUnit = Class.forName("kotlin.Unit");
            kotlinVersion = "kotlin";
            kotlinJar = new JarInputStream(kotlinUnit.getProtectionDomain().getCodeSource().getLocation().openStream());
            String version = kotlinJar.getManifest().getMainAttributes().getValue("Implementation-Version");
            kotlinVersion = VersionInfoUtils.concat(kotlinVersion, version, "/");
            IOUtils.closeQuietly(kotlinJar, log);
        }
        catch (ClassNotFoundException kotlinUnit) {
            IOUtils.closeQuietly(kotlinJar, log);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception attempting to get Kotlin version.", e);
            }
        }
        finally {
            IOUtils.closeQuietly(kotlinJar, log);
        }
        return kotlinVersion;
    }

    private static String concat(String prefix, String suffix, String separator) {
        return suffix != null && !suffix.isEmpty() ? prefix + separator + suffix : prefix;
    }

    static {
        log = LogFactory.getLog(VersionInfoUtils.class);
    }
}

