/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.ion.impl;

import com.ibm.cloud.objectstorage.thirdparty.ion.IonCatalog;
import com.ibm.cloud.objectstorage.thirdparty.ion.IonException;
import com.ibm.cloud.objectstorage.thirdparty.ion.IonReader;
import com.ibm.cloud.objectstorage.thirdparty.ion.IonSystem;
import com.ibm.cloud.objectstorage.thirdparty.ion.IonValue;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.IonReaderBinarySystemX;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.IonReaderBinaryUserX;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.IonReaderTextSystemX;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.IonReaderTextUserX;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.IonReaderTreeSystem;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.IonReaderTreeUserX;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.LocalSymbolTable;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.PrivateIonConstants;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.PrivateLocalSymbolTableFactory;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.UnifiedInputStreamX;
import com.ibm.cloud.objectstorage.thirdparty.ion.util.IonStreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.zip.GZIPInputStream;

@Deprecated
public final class PrivateIonReaderFactory {
    public static final IonReader makeReader(IonCatalog catalog, byte[] bytes) {
        return PrivateIonReaderFactory.makeReader(catalog, bytes, 0, bytes.length);
    }

    public static final IonReader makeReader(IonCatalog catalog, byte[] bytes, PrivateLocalSymbolTableFactory lstFactory) {
        return PrivateIonReaderFactory.makeReader(catalog, bytes, 0, bytes.length, lstFactory);
    }

    public static IonReader makeSystemReader(byte[] bytes) {
        return PrivateIonReaderFactory.makeSystemReader(bytes, 0, bytes.length);
    }

    public static final IonReader makeReader(IonCatalog catalog, byte[] bytes, int offset, int length) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(bytes, offset, length);
            return PrivateIonReaderFactory.makeReader(catalog, uis, offset, LocalSymbolTable.DEFAULT_LST_FACTORY);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonReader makeReader(IonCatalog catalog, byte[] bytes, int offset, int length, PrivateLocalSymbolTableFactory lstFactory) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(bytes, offset, length);
            return PrivateIonReaderFactory.makeReader(catalog, uis, offset, lstFactory);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static IonReader makeSystemReader(byte[] bytes, int offset, int length) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(bytes, offset, length);
            return PrivateIonReaderFactory.makeSystemReader(uis, offset);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonReader makeReader(IonCatalog catalog, char[] chars) {
        return PrivateIonReaderFactory.makeReader(catalog, chars, 0, chars.length);
    }

    public static final IonReader makeSystemReader(char[] chars) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
        return new IonReaderTextSystemX(in);
    }

    public static final IonReader makeReader(IonCatalog catalog, char[] chars, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars, offset, length);
        return new IonReaderTextUserX(catalog, LocalSymbolTable.DEFAULT_LST_FACTORY, in, offset);
    }

    public static final IonReader makeSystemReader(char[] chars, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars, offset, length);
        return new IonReaderTextSystemX(in);
    }

    public static final IonReader makeReader(IonCatalog catalog, CharSequence chars) {
        return PrivateIonReaderFactory.makeReader(catalog, chars, (PrivateLocalSymbolTableFactory)LocalSymbolTable.DEFAULT_LST_FACTORY);
    }

    public static final IonReader makeReader(IonCatalog catalog, CharSequence chars, PrivateLocalSymbolTableFactory lstFactory) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
        return new IonReaderTextUserX(catalog, lstFactory, in);
    }

    public static final IonReader makeSystemReader(CharSequence chars) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
        return new IonReaderTextSystemX(in);
    }

    public static final IonReader makeReader(IonCatalog catalog, CharSequence chars, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars, offset, length);
        return new IonReaderTextUserX(catalog, LocalSymbolTable.DEFAULT_LST_FACTORY, in, offset);
    }

    public static final IonReader makeSystemReader(CharSequence chars, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars, offset, length);
        return new IonReaderTextSystemX(in);
    }

    public static final IonReader makeReader(IonCatalog catalog, InputStream is) {
        return PrivateIonReaderFactory.makeReader(catalog, is, (PrivateLocalSymbolTableFactory)LocalSymbolTable.DEFAULT_LST_FACTORY);
    }

    public static final IonReader makeReader(IonCatalog catalog, InputStream is, PrivateLocalSymbolTableFactory lstFactory) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(is);
            return PrivateIonReaderFactory.makeReader(catalog, uis, 0, lstFactory);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static IonReader makeSystemReader(InputStream is) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(is);
            return PrivateIonReaderFactory.makeSystemReader(uis, 0);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonReader makeReader(IonCatalog catalog, Reader chars) {
        return PrivateIonReaderFactory.makeReader(catalog, chars, (PrivateLocalSymbolTableFactory)LocalSymbolTable.DEFAULT_LST_FACTORY);
    }

    public static final IonReader makeReader(IonCatalog catalog, Reader chars, PrivateLocalSymbolTableFactory lstFactory) {
        try {
            UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
            return new IonReaderTextUserX(catalog, lstFactory, in);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonReader makeSystemReader(Reader chars) {
        try {
            UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars);
            return new IonReaderTextSystemX(in);
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    public static final IonReader makeReader(IonCatalog catalog, IonValue value) {
        return new IonReaderTreeUserX(value, catalog, LocalSymbolTable.DEFAULT_LST_FACTORY);
    }

    public static final IonReader makeSystemReader(IonSystem system, IonValue value) {
        if (system != null && system != value.getSystem()) {
            throw new IonException("you can't mix values from different systems");
        }
        return new IonReaderTreeSystem(value);
    }

    private static IonReader makeReader(IonCatalog catalog, UnifiedInputStreamX uis, int offset, PrivateLocalSymbolTableFactory lstFactory) throws IOException {
        IonReader r = PrivateIonReaderFactory.has_binary_cookie(uis) ? new IonReaderBinaryUserX(catalog, lstFactory, uis, offset) : new IonReaderTextUserX(catalog, lstFactory, uis, offset);
        return r;
    }

    private static IonReader makeSystemReader(UnifiedInputStreamX uis, int offset) throws IOException {
        IonReader r = PrivateIonReaderFactory.has_binary_cookie(uis) ? new IonReaderBinarySystemX(uis) : new IonReaderTextSystemX(uis);
        return r;
    }

    private static UnifiedInputStreamX makeUnifiedStream(byte[] bytes, int offset, int length) throws IOException {
        UnifiedInputStreamX uis;
        if (IonStreamUtils.isGzip(bytes, offset, length)) {
            ByteArrayInputStream baos = new ByteArrayInputStream(bytes, offset, length);
            GZIPInputStream gzip = new GZIPInputStream(baos);
            uis = UnifiedInputStreamX.makeStream(gzip);
        } else {
            uis = UnifiedInputStreamX.makeStream(bytes, offset, length);
        }
        return uis;
    }

    private static UnifiedInputStreamX makeUnifiedStream(InputStream in) throws IOException {
        in.getClass();
        in = IonStreamUtils.unGzip(in);
        UnifiedInputStreamX uis = UnifiedInputStreamX.makeStream(in);
        return uis;
    }

    private static final boolean has_binary_cookie(UnifiedInputStreamX uis) throws IOException {
        int c;
        int len;
        byte[] bytes = new byte[PrivateIonConstants.BINARY_VERSION_MARKER_SIZE];
        for (len = 0; len < PrivateIonConstants.BINARY_VERSION_MARKER_SIZE && (c = uis.read()) != -1; ++len) {
            bytes[len] = (byte)c;
        }
        int ii = len;
        while (ii > 0) {
            uis.unread(bytes[--ii] & 0xFF);
        }
        boolean is_cookie = IonStreamUtils.isIonBinary(bytes, 0, len);
        return is_cookie;
    }
}

