/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal;

import com.ibm.cloud.objectstorage.AmazonClientException;
import com.ibm.cloud.objectstorage.AmazonWebServiceRequest;
import com.ibm.cloud.objectstorage.annotation.SdkTestInternalApi;
import com.ibm.cloud.objectstorage.internal.SdkPredicate;
import com.ibm.cloud.objectstorage.retry.RetryPolicy;
import com.ibm.cloud.objectstorage.services.s3.internal.CompleteMultipartUploadRetryablePredicate;
import com.ibm.cloud.objectstorage.services.s3.model.AmazonS3Exception;
import com.ibm.cloud.objectstorage.util.ValidationUtils;

public class CompleteMultipartUploadRetryCondition
implements RetryPolicy.RetryCondition {
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private final SdkPredicate<AmazonS3Exception> completeMultipartRetryablePredicate;
    private final int maxCompleteMultipartUploadRetries;

    public CompleteMultipartUploadRetryCondition() {
        this(new CompleteMultipartUploadRetryablePredicate(), 3);
    }

    @SdkTestInternalApi
    CompleteMultipartUploadRetryCondition(SdkPredicate<AmazonS3Exception> predicate, int maxRetryAttempts) {
        ValidationUtils.assertNotNull(predicate, "sdk predicate");
        this.completeMultipartRetryablePredicate = predicate;
        this.maxCompleteMultipartUploadRetries = maxRetryAttempts;
    }

    @Override
    public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        if (exception instanceof AmazonS3Exception) {
            return this.completeMultipartRetryablePredicate.test((AmazonS3Exception)exception) && retriesAttempted < this.maxCompleteMultipartUploadRetries;
        }
        return false;
    }
}

