/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.http.timers.request;

import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.annotation.SdkTestInternalApi;
import com.ibm.cloud.objectstorage.annotation.ThreadSafe;
import com.ibm.cloud.objectstorage.http.timers.TimeoutThreadPoolBuilder;
import com.ibm.cloud.objectstorage.http.timers.request.HttpRequestAbortTaskImpl;
import com.ibm.cloud.objectstorage.http.timers.request.HttpRequestAbortTaskTracker;
import com.ibm.cloud.objectstorage.http.timers.request.HttpRequestAbortTaskTrackerImpl;
import com.ibm.cloud.objectstorage.http.timers.request.NoOpHttpRequestAbortTaskTracker;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.methods.HttpRequestBase;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@ThreadSafe
@SdkInternalApi
public class HttpRequestTimer {
    private static final String threadNamePrefix = "AwsSdkRequestTimerThread";
    private volatile ScheduledThreadPoolExecutor executor;

    public HttpRequestAbortTaskTracker startTimer(HttpRequestBase apacheRequest, int requestTimeoutMillis) {
        if (this.isTimeoutDisabled(requestTimeoutMillis)) {
            return NoOpHttpRequestAbortTaskTracker.INSTANCE;
        }
        if (this.executor == null) {
            this.initializeExecutor();
        }
        HttpRequestAbortTaskImpl timerTask = new HttpRequestAbortTaskImpl(apacheRequest);
        ScheduledFuture<?> timerTaskFuture = this.executor.schedule(timerTask, (long)requestTimeoutMillis, TimeUnit.MILLISECONDS);
        return new HttpRequestAbortTaskTrackerImpl(timerTask, timerTaskFuture);
    }

    private boolean isTimeoutDisabled(int requestTimeoutMillis) {
        return requestTimeoutMillis <= 0;
    }

    private synchronized void initializeExecutor() {
        if (this.executor == null) {
            this.executor = TimeoutThreadPoolBuilder.buildDefaultTimeoutThreadPool(threadNamePrefix);
        }
    }

    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @SdkTestInternalApi
    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

