/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.http.protocol;

import com.ibm.cloud.objectstorage.internal.SdkMetricsSocket;
import com.ibm.cloud.objectstorage.internal.SdkSSLMetricsSocket;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpClientConnection;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpException;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpRequest;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpResponse;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.ManagedHttpClientConnection;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpContext;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpRequestExecutor;
import com.ibm.cloud.objectstorage.util.AWSRequestMetrics;
import java.io.IOException;
import java.net.Socket;

public class SdkHttpRequestExecutor
extends HttpRequestExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        AWSRequestMetrics awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.class.getSimpleName());
        if (awsRequestMetrics == null) {
            return super.doSendRequest(request, conn, context);
        }
        if (conn instanceof ManagedHttpClientConnection) {
            ManagedHttpClientConnection managedConn = (ManagedHttpClientConnection)conn;
            Socket sock = managedConn.getSocket();
            if (sock instanceof SdkMetricsSocket) {
                SdkMetricsSocket sdkMetricsSocket = (SdkMetricsSocket)sock;
                sdkMetricsSocket.setMetrics(awsRequestMetrics);
            } else if (sock instanceof SdkSSLMetricsSocket) {
                SdkSSLMetricsSocket sdkSSLMetricsSocket = (SdkSSLMetricsSocket)sock;
                sdkSSLMetricsSocket.setMetrics(awsRequestMetrics);
            }
        }
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        try {
            HttpResponse httpResponse = super.doSendRequest(request, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        AWSRequestMetrics awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.class.getSimpleName());
        if (awsRequestMetrics == null) {
            return super.doReceiveResponse(request, conn, context);
        }
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        try {
            HttpResponse httpResponse = super.doReceiveResponse(request, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        }
    }
}

