/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.http.apache;

import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpException;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpHost;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpRequest;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.conn.DefaultRoutePlanner;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.conn.DefaultSchemePortResolver;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpContext;
import com.ibm.cloud.objectstorage.util.StringUtils;

@SdkInternalApi
public class SdkProxyRoutePlanner
extends DefaultRoutePlanner {
    private HttpHost proxy;
    private String[] hostPatterns;

    public SdkProxyRoutePlanner(String proxyHost, int proxyPort, String nonProxyHosts) {
        super(DefaultSchemePortResolver.INSTANCE);
        this.proxy = new HttpHost(proxyHost, proxyPort);
        this.parseNonProxyHosts(nonProxyHosts);
    }

    private void parseNonProxyHosts(String nonProxyHosts) {
        if (!StringUtils.isNullOrEmpty(nonProxyHosts)) {
            String[] hosts = nonProxyHosts.split("\\|");
            this.hostPatterns = new String[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                this.hostPatterns[i] = hosts[i].toLowerCase().replace("*", ".*?");
            }
        }
    }

    boolean doesTargetMatchNonProxyHosts(HttpHost target) {
        if (this.hostPatterns == null) {
            return false;
        }
        String targetHost = target.getHostName().toLowerCase();
        for (String pattern : this.hostPatterns) {
            if (!targetHost.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return this.doesTargetMatchNonProxyHosts(target) ? null : this.proxy;
    }
}

