/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ibm.cloud.sdk.core.http.InputStreamRequestBody;
import com.ibm.cloud.sdk.core.http.NameValue;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.StringHelper;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;

public class RequestBuilder {
    private static Escaper pathEscaper = UrlEscapers.urlPathSegmentEscaper();
    private RequestBody body;
    private HttpUrl httpUrl;
    private final List<NameValue> formParams = new ArrayList<NameValue>();
    private final List<NameValue> headers = new ArrayList<NameValue>();
    private final HTTPMethod method;
    private final List<NameValue> queryParams = new ArrayList<NameValue>();

    public static RequestBuilder delete(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.DELETE, url);
    }

    public static RequestBuilder get(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.GET, url);
    }

    public static RequestBuilder post(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.POST, url);
    }

    public static RequestBuilder put(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.PUT, url);
    }

    public static RequestBuilder patch(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.PATCH, url);
    }

    public static RequestBuilder head(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.HEAD, url);
    }

    public static HttpUrl constructHttpUrl(String serviceUrl, String[] pathSegments) {
        Validator.notEmpty(serviceUrl, "The serviceUrl cannot be null");
        HttpUrl.Builder httpUrlBuilder = HttpUrl.parse((String)serviceUrl).newBuilder();
        for (String segment : pathSegments) {
            if (segment.isEmpty()) continue;
            httpUrlBuilder.addPathSegments(segment);
        }
        return httpUrlBuilder.build();
    }

    public static HttpUrl constructHttpUrl(String serviceUrl, String[] pathSegments, String[] pathParameters) {
        Validator.notEmpty(serviceUrl, "The serviceUrl cannot be null");
        HttpUrl.Builder httpUrlBuilder = HttpUrl.parse((String)serviceUrl).newBuilder();
        for (int i = 0; i < pathSegments.length; ++i) {
            if (!pathSegments[i].isEmpty()) {
                httpUrlBuilder.addPathSegments(pathSegments[i]);
            }
            if (i >= pathParameters.length || pathParameters[i].isEmpty()) continue;
            httpUrlBuilder.addPathSegment(pathParameters[i]);
        }
        return httpUrlBuilder.build();
    }

    public static HttpUrl resolveRequestUrl(String serviceUrl, String path, Map<String, String> pathParams) {
        Validator.notEmpty(serviceUrl, "The serviceUrl cannot be null");
        HttpUrl.Builder builder = HttpUrl.get((String)serviceUrl).newBuilder();
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            if (pathParams != null) {
                for (Map.Entry<String, String> paramEntry : pathParams.entrySet()) {
                    if (StringUtils.isEmpty((CharSequence)paramEntry.getValue())) {
                        throw new IllegalArgumentException(String.format("Path parameter '%s' is empty", paramEntry.getKey()));
                    }
                    String encodedValue = pathEscaper.escape(paramEntry.getValue());
                    String ref = String.format("{%s}", paramEntry.getKey());
                    path = path.replace(ref, encodedValue);
                }
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            builder.addEncodedPathSegments(path);
        }
        return builder.build();
    }

    public static HttpUrl resolveRequestUrl(String serviceUrl, String path) {
        return RequestBuilder.resolveRequestUrl(serviceUrl, path, null);
    }

    private RequestBuilder(HTTPMethod method, HttpUrl url) {
        this.method = method;
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this.httpUrl = url;
    }

    private RequestBuilder add(List<NameValue> params, String name, Object value) {
        if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.addParam(params, name, o);
            }
        } else if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                this.addParam(params, name, o);
            }
        } else {
            this.addParam(params, name, value);
        }
        return this;
    }

    private void addParam(List<NameValue> params, String name, Object value) {
        params.add(new NameValue(name, value == null ? null : String.valueOf(value)));
    }

    public Request build() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.toUrl());
        if (this.method == HTTPMethod.GET || this.method == HTTPMethod.HEAD) {
            Validator.isNull(this.body, "cannot send a RequestBody in a GET or HEAD request");
        } else if (!this.formParams.isEmpty()) {
            FormBody.Builder formBody = new FormBody.Builder();
            for (NameValue param : this.formParams) {
                String value = param.getValue() != null ? param.getValue() : "";
                formBody.add(param.getName(), value);
            }
            this.body = formBody.build();
        } else if (this.body == null) {
            this.body = RequestBody.create(null, (byte[])new byte[0]);
        }
        builder.method(this.method.name(), this.body);
        builder.header("Accept", "application/json");
        for (NameValue header : this.headers) {
            builder.header(header.getName(), header.getValue());
        }
        return builder.build();
    }

    public String toString() {
        return "RequestBuilder [method=" + (Object)((Object)this.method) + ", formParams=" + this.formParams + ", headers=" + this.headers + ", queryParams=" + this.queryParams + ", httpUrl=" + this.httpUrl.toString() + "]";
    }

    private String toUrl() {
        HttpUrl.Builder builder = this.httpUrl.newBuilder();
        for (NameValue param : this.queryParams) {
            builder.addQueryParameter(param.getName(), param.getValue());
        }
        return builder.build().uri().toString();
    }

    private RequestBuilder with(List<NameValue> params, Object ... args) {
        if (args != null) {
            Validator.isTrue(args.length % 2 == 0, "need even number of arguments");
            for (int i = 0; i < args.length; i += 2) {
                this.add(params, args[i].toString(), args[i + 1]);
            }
        }
        return this;
    }

    public RequestBuilder body(RequestBody body) {
        this.body = body;
        return this;
    }

    public RequestBuilder bodyContent(String content, String contentType) {
        return this.body(RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content));
    }

    public RequestBuilder bodyContent(InputStream stream, String contentType) {
        return this.body(InputStreamRequestBody.create(MediaType.parse((String)contentType), stream));
    }

    public RequestBuilder bodyContent(String contentType, Object jsonContent, Object jsonPatchContent, InputStream nonJsonContent) {
        if (contentType != null) {
            Gson requestGson = GsonSingleton.getGsonWithoutPrettyPrinting().newBuilder().create();
            if (jsonContent != null) {
                this.bodyContent(requestGson.toJson(jsonContent), contentType);
            } else if (jsonPatchContent != null) {
                this.bodyContent(requestGson.toJson(jsonPatchContent), contentType);
            } else {
                this.bodyContent(nonJsonContent, contentType);
            }
        }
        return this;
    }

    public RequestBuilder bodyContent(String contentType, Object jsonContent, Object jsonPatchContent, String nonJsonContent) {
        InputStream nonJson = null;
        if (nonJsonContent != null) {
            nonJson = StringHelper.toInputStream(nonJsonContent);
        }
        return this.bodyContent(contentType, jsonContent, jsonPatchContent, nonJson);
    }

    public RequestBuilder bodyJson(JsonObject json) {
        return this.bodyContent(json.toString(), "application/json");
    }

    public RequestBuilder bodyJson(JsonObject json, String mediaType) {
        return this.bodyContent(json.toString(), mediaType);
    }

    public RequestBuilder form(Object ... args) {
        return this.with(this.formParams, args);
    }

    public RequestBuilder header(Object ... args) {
        return this.with(this.headers, args);
    }

    public RequestBuilder query(Object ... args) {
        return this.with(this.queryParams, args);
    }

    private static enum HTTPMethod {
        DELETE,
        GET,
        POST,
        PUT,
        PATCH,
        HEAD;

    }
}

