/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamToken;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.net.Proxy;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;

public class IamAuthenticator
extends TokenRequestBasedAuthenticator<IamToken, IamToken>
implements Authenticator {
    private static final String DEFAULT_IAM_URL = "https://iam.cloud.ibm.com";
    private static final String OPERATION_PATH = "/identity/token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REQUEST_GRANT_TYPE = "urn:ibm:params:oauth:grant-type:apikey";
    private static final String API_KEY = "apikey";
    private static final String RESPONSE_TYPE = "response_type";
    private static final String CLOUD_IAM = "cloud_iam";
    private static final String SCOPE = "scope";
    private String url;
    private String apikey;
    private String scope;
    private String clientId;
    private String clientSecret;
    private String cachedAuthorizationHeader = null;

    protected IamAuthenticator() {
    }

    protected IamAuthenticator(Builder builder) {
        this.url = builder.url;
        this.apikey = builder.apikey;
        this.scope = builder.scope;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.setDisableSSLVerification(builder.disableSSLVerification);
        this.setHeaders(builder.headers);
        this.setProxy(builder.proxy);
        this.setProxyAuthenticator(builder.proxyAuthenticator);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public IamAuthenticator(String apikey) {
        this.init(apikey, null, null, null, false, null, null);
    }

    @Deprecated
    public IamAuthenticator(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers) {
        this.init(apikey, url, clientId, clientSecret, disableSSLVerification, headers, null);
    }

    @Deprecated
    public IamAuthenticator(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers, String scope) {
        this.init(apikey, url, clientId, clientSecret, disableSSLVerification, headers, scope);
    }

    @Deprecated
    public IamAuthenticator(Map<String, String> config) {
        String apikey = config.get("APIKEY");
        if (StringUtils.isEmpty((CharSequence)apikey)) {
            apikey = config.get("IAM_APIKEY");
        }
        this.init(apikey, config.get("AUTH_URL"), config.get("CLIENT_ID"), config.get("CLIENT_SECRET"), Boolean.valueOf(config.get("AUTH_DISABLE_SSL")), null, config.get("SCOPE"));
    }

    public static IamAuthenticator fromConfiguration(Map<String, String> config) {
        String apikey = config.get("APIKEY");
        if (StringUtils.isEmpty((CharSequence)apikey)) {
            apikey = config.get("IAM_APIKEY");
        }
        return new Builder().url(config.get("AUTH_URL")).apikey(apikey).scope(config.get("SCOPE")).clientId(config.get("CLIENT_ID")).clientSecret(config.get("CLIENT_SECRET")).disableSSLVerification(Boolean.valueOf(config.get("AUTH_DISABLE_SSL"))).build();
    }

    protected void init(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers, String scope) {
        this.apikey = apikey;
        this.url = url;
        this.setClientIdAndSecret(clientId, clientSecret);
        this.setScope(scope);
        this.validate();
        this.setDisableSSLVerification(disableSSLVerification);
        this.setHeaders(headers);
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            this.url = DEFAULT_IAM_URL;
        } else if (this.url.endsWith(OPERATION_PATH)) {
            this.url = this.url.substring(0, this.url.length() - OPERATION_PATH.length());
        }
        if (StringUtils.isEmpty((CharSequence)this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", API_KEY));
        }
        if (CredentialUtils.hasBadStartOrEndChar(this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is invalid. Please remove any surrounding {, }, or \" characters.", API_KEY));
        }
        if (!StringUtils.isEmpty((CharSequence)this.getUsername()) || !StringUtils.isEmpty((CharSequence)this.getPassword())) {
            if (StringUtils.isEmpty((CharSequence)this.getUsername())) {
                throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "clientId"));
            }
            if (StringUtils.isEmpty((CharSequence)this.getPassword())) {
                throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "clientSecret"));
            }
        }
        this.cachedAuthorizationHeader = IamAuthenticator.constructBasicAuthHeader(this.clientId, this.clientSecret);
    }

    @Override
    public String authenticationType() {
        return "iam";
    }

    public String getApiKey() {
        return this.apikey;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = DEFAULT_IAM_URL;
        }
        this.url = url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUsername() {
        return this.getClientId();
    }

    public String getPassword() {
        return this.getClientSecret();
    }

    @Deprecated
    public void setBasicAuthInfo(String clientId, String clientSecret) {
        this.setClientIdAndSecret(clientId, clientSecret);
    }

    public void setClientIdAndSecret(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.validate();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String value) {
        this.scope = value;
    }

    @Override
    public IamToken requestToken() {
        IamToken token;
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.url, OPERATION_PATH));
        builder.header("Content-Type", "application/x-www-form-urlencoded");
        if (StringUtils.isNotEmpty((CharSequence)this.cachedAuthorizationHeader)) {
            builder.header("Authorization", this.cachedAuthorizationHeader);
        }
        FormBody.Builder formBodyBuilder = new FormBody.Builder().add(GRANT_TYPE, REQUEST_GRANT_TYPE).add(API_KEY, this.apikey).add(RESPONSE_TYPE, CLOUD_IAM);
        if (!StringUtils.isEmpty((CharSequence)this.getScope())) {
            formBodyBuilder.add(SCOPE, this.getScope());
        }
        FormBody formBody = formBodyBuilder.build();
        builder.body((RequestBody)formBody);
        try {
            token = this.invokeRequest(builder, IamToken.class);
        }
        catch (Throwable t) {
            token = new IamToken(t);
        }
        return token;
    }

    public static class Builder {
        private String url;
        private String apikey;
        private String scope;
        private String clientId;
        private String clientSecret;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;

        public Builder() {
        }

        private Builder(IamAuthenticator obj) {
            this.url = obj.url;
            this.apikey = obj.apikey;
            this.scope = obj.scope;
            this.clientId = obj.clientId;
            this.clientSecret = obj.clientSecret;
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
        }

        public IamAuthenticator build() {
            return new IamAuthenticator(this);
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder apikey(String apikey) {
            this.apikey = apikey;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }
    }
}

